/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.feature.nav;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.lang.reflect.Constructor;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreePath;
import jaxx.demo.entities.*;
import jaxx.demo.feature.nav.*;
import jaxx.demo.feature.nav.content.*;
import jaxx.demo.feature.nav.tree.*;
import jaxx.demo.feature.nav.treetable.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class NavDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Wz08TQRTHh2qLBUWEiOAPRMUYjW7VgwdBRfkRbAoSSgzai9PdgQ5Od8bZ2bJ4MP4J/gl692LizZPx4NmDF+O/YIwHr8Y3u9vdrizQpHIoZN57n/ej733D2x8o60h0ZgN7niFdW9E6MYp3V1cfVDeIqWaIY0oqFJco+OnKoEwF9VrRu6PQuUpJhxfC8MI0rwtuE7sleqKEehy1xYhTI0QpdCoZYTpOoRyZJzzhyiY1KiqN+vrXz8wr6+WbDEKegOr6oJWxvaLiTvaXUIZaCg1ApgYuMGyvQxmS2utQ7yH9Ns2w4yziOnmGXqDuEsoJLAGm0Nn2W/YZfrwnFOodnyF1voRtwq7CHPxiLXgx1ghWriSGjRvGIm5oLyH8uJxCh0xuK8CX8BZ3If1ooklnE0o2prG0Avv1OPCghRVekrxBLSIVurhrvpkW3xjRoyQh84QJDbicDtAuTcpK5B4zDmuHFVxlEejGziCl/VppLYExMu8IRpUepEJD+rvywjkUy02D9szHMxwvAqhKLG2C2R9LBMUm7T7cGlU2JWcsNSo2afcTUVQf9ELXsaLc1g0odCSZDN6052h6mmv6cSxJHEwS/ZEodJrLdWMDrvGp4iKge0ZxNfLQweMRozvcItj4RDn+Nibbzo9D/H17jUPLx1OWLbSK7QF+8QYYJDqRCIQjN+Ijj6+wq4Ky0oVnhYYr23VhGUyBIgz/owga6Fv/DA1+/fD9/VxTBo5A7qOpri0qBucpJNe7SHXqw4EGuIqywgIWExVYMMJAAn2JO5lSWDk0Q3GQz/+CDR1uzGOnBohs97ePn4aefNmHMnOoh3FszWHtfx/lVU3CFDizPHFnyq/o4OYB+OzXtSmUY+GZ903q8x2rUtuCod/2YAgnU4YQVVLNf/49WH431RxEFxQ2sqN7PIzsY5SjNqM28RUxFLtUBewVDnEtHotamsx16d89ItyOG/7nzbROB0A0V7hr1mY9gW0rWOqByaCWMaxAjKuuItC5Rtz2W9J/TfkZRtrIkKtyCXKm7bfSKafboIzUuKTP4XowC870HpZLnFFzq0PwsYZeQPN/Y/NrUOsVhz73v7bZdNDZNkDZOrcCbdihmnYgvZJz9ZA6NFSkDurph7PZdJaBNw/7AqLREU8/F3dp7nxbhAcdE1Y6JjzaZQ4X2iKYHRNqHRFA7aJ/Ehb2WLr26pnchXAJCH8BCuDvkPwKAAA=";
    private static final Log log = LogFactory.getLog(jaxx.demo.feature.nav.NavDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel content;
    protected jaxx.runtime.swing.CardLayout2 contentLayout;
    protected jaxx.demo.feature.nav.NavDemoDataProvider dataProvider;
    protected javax.swing.JTree navigationTree;
    protected org.jdesktop.swingx.JXTreeTable navigationTreeTable;
    protected javax.swing.JSplitPane splitPane;
    protected jaxx.demo.feature.nav.tree.NavDemoTreeHelper treeHelper;
    protected jaxx.demo.feature.nav.treetable.NavDemoTreeTableHelper treeTableHelper;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private NavDemo $DemoPanel0 = this;
    private javax.swing.JTabbedPane $JTabbedPane0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JScrollPane $JScrollPane1;
    private jaxx.runtime.swing.TabInfo $TabInfo0;
    private jaxx.runtime.swing.TabInfo $TabInfo1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected String[] getSources() {
        return new String[]{ getDefaultSource(),
                "tree/NavDemoTreeNode.java",
                "tree/NavDemoTreeHelper.java",
                "tree/NavDemoTreeCellRenderer.java",
                "tree/ActorsTreeNodeLoador.java",
                "tree/MoviesTreeNodeLoador.java",
                "treetable/NavDemoTreeTableNode.java",
                "treetable/NavDemoTreeTableHelper.java",
                "treetable/ActorsTreeTableNodeLoador.java",
                "treetable/MoviesTreeTableNodeLoador.java"
         };
    }
    
    private void $afterCompleteSetup() {
        setContextValue(treeHelper, "treeHelper");
        setContextValue(treeTableHelper, "treeTableHelper");
    
        // Creation of selection listener to open ui when tree selection change
        TreeSelectionListener treeSelectionListener = new TreeSelectionListener() {
            @Override
            public void valueChanged(TreeSelectionEvent event) {
                TreePath path = event.getPath();
                NavDemoTreeNode demoNode = (NavDemoTreeNode) path.getLastPathComponent();
    
                if (log.isDebugEnabled()) {
                    log.debug("Select demoNode " + demoNode);
                }
    
                // Do nothing for root
                if (demoNode.isRoot()) {
                    return;
                }
                openUI(demoNode);
            }
        };
    
        // Creation of selection listener to open ui when tree selection change
        TreeSelectionListener treeTableSelectionListener = new TreeSelectionListener() {
            @Override
            public void valueChanged(TreeSelectionEvent event) {
                TreePath path = event.getPath();
                NavDemoTreeTableNode demoNode = (NavDemoTreeTableNode) path.getLastPathComponent();
    
                if (log.isDebugEnabled()) {
                    log.debug("Select demoNode " + demoNode);
                }
    
                // Do nothing for root
                if (demoNode.isRoot()) {
                    return;
                }
                openUI(demoNode);
            }
        };
    
        // Register decorator
        DecoratorProvider decoratorProvider = getContextValue(DecoratorProvider.class);
    
        // Attach renderer
        navigationTree.setCellRenderer(new NavDemoTreeCellRenderer(decoratorProvider, dataProvider));
    
        // Register tree
        treeHelper.setUI(navigationTree, true, treeSelectionListener);
    
        // Register tree table
        treeTableHelper.setUI(navigationTreeTable, true, treeTableSelectionListener);
    
        SwingUtilities.invokeLater(new Runnable() {
    
            @Override
            public void run() {
                navigationTree.setSelectionInterval(0, 0);
                splitPane.resetToPreferredSizes();
            }
        });
    
        // expand the tree
        SwingUtil.expandTree(navigationTree);
        SwingUtil.expandTreeTable(navigationTreeTable);
    
        // auto-expand demoNode when selected
        SwingUtil.addExpandOnClickListener(navigationTree);
        SwingUtil.addExpandOnClickListener(navigationTreeTable);
    }
    
    protected void openUI(NavNode demoNode) {
    
        // Get demoNode type
        Class<?> editType = demoNode.getInternalClass();
        String id = demoNode.getId();
    
        // If it's category demoNode
        if (editType.equals(String.class)) {
    
            // Actors categorie demoNode
            if (NavDemoTreeHelper.ACTORS_CATEGORY_NODE.equals(id)) {
    
                java.util.List<People> peoples = dataProvider.getPeoples();
                showUI(peoples, ActorsContentUI.class);
    
            // Movies categorie demoNode
            } else if (NavDemoTreeHelper.MOVIES_CATEGORY_NODE.equals(id)) {
    
                java.util.List<Movie> movies = dataProvider.getMovies();
                showUI(movies, MoviesContentUI.class);
            }
    
        // People demoNode
        } else if (editType.equals(People.class)) {
            People people = dataProvider.getPeople(id);
            showUI(people, ActorContentUI.class);
    
        // Movie demoNode
        } else if (editType.equals(Movie.class)) {
            Movie movie = dataProvider.getMovie(id);
            showUI(movie, MovieContentUI.class);
        }
    }
    
    // Create by introspection content ui
    protected <B> void showUI(B bean, Class<? extends AbstractContentUI> uiClass) {
    
        // Verify if instance is existing
        AbstractContentUI ui = getContentIfExist(uiClass);
    
        // Get layout identifier
        String contentName = uiClass.getName();
        
        if (ui == null) {
            try {
                // Get constructor
                Constructor<? extends AbstractContentUI> constructor =
                        uiClass.getConstructor(JAXXContext.class);
    
                // Invoke instance creation
                ui = constructor.newInstance(this);
            } catch (Exception eee) {
                log.error(eee);
                ErrorDialogUI.showError(eee);
            }
    
            // Add to content panel
            content.add(ui, contentName);
        }
    
        // Attach bean
        ui.setData(bean);
    
        // show ui
        contentLayout.show(content, contentName);
    }
    
    // Get content if exist in content, else return null
    protected <E extends Component> E getContentIfExist(Class<E> uiClass) {
        String contentName = uiClass.getName();
        if (log.isDebugEnabled()) {
            log.debug("Get content if exist " + contentName);
        }
        if (!contentLayout.contains(contentName)) {
            return null;
        }
        return (E) contentLayout.getComponent(content, contentName);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NavDemo() {
        super();
        $initialize();
    }

    public NavDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getContent() {
        return content;
    }

    public jaxx.runtime.swing.CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public jaxx.demo.feature.nav.NavDemoDataProvider getDataProvider() {
        return dataProvider;
    }

    public javax.swing.JTree getNavigationTree() {
        return navigationTree;
    }

    public org.jdesktop.swingx.JXTreeTable getNavigationTreeTable() {
        return navigationTreeTable;
    }

    public javax.swing.JSplitPane getSplitPane() {
        return splitPane;
    }

    public jaxx.demo.feature.nav.tree.NavDemoTreeHelper getTreeHelper() {
        return treeHelper;
    }

    public jaxx.demo.feature.nav.treetable.NavDemoTreeTableHelper getTreeTableHelper() {
        return treeTableHelper;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTabbedPane get$JTabbedPane0() {
        return $JTabbedPane0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add($JTabbedPane0, JSplitPane.LEFT);
        splitPane.add(content, JSplitPane.RIGHT);
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new jaxx.runtime.swing.CardLayout2());
    }

    protected void createDataProvider() {
        $objectMap.put("dataProvider", dataProvider = new jaxx.demo.feature.nav.NavDemoDataProvider());
    }

    protected void createNavigationTree() {
        $objectMap.put("navigationTree", navigationTree = new javax.swing.JTree());
        
        navigationTree.setName("navigationTree");
        if (navigationTree.getFont() != null) {
            navigationTree.setFont(navigationTree.getFont().deriveFont((float) 11));
        }
        navigationTree.setRootVisible(false);
        navigationTree.setShowsRootHandles(false);
    }

    protected void createNavigationTreeTable() {
        $objectMap.put("navigationTreeTable", navigationTreeTable = new org.jdesktop.swingx.JXTreeTable());
        
        navigationTreeTable.setName("navigationTreeTable");
        if (navigationTreeTable.getFont() != null) {
            navigationTreeTable.setFont(navigationTreeTable.getFont().deriveFont((float) 11));
        }
        navigationTreeTable.setRootVisible(false);
        navigationTreeTable.setShowsRootHandles(false);
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new javax.swing.JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setOneTouchExpandable(true);
    }

    protected void createTreeHelper() {
        $objectMap.put("treeHelper", treeHelper = new jaxx.demo.feature.nav.tree.NavDemoTreeHelper(getDataProvider()));
    }

    protected void createTreeTableHelper() {
        $objectMap.put("treeTableHelper", treeTableHelper = new jaxx.demo.feature.nav.treetable.NavDemoTreeTableHelper(getDataProvider()));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add(splitPane, BorderLayout.CENTER);
        addChildrenToSplitPane();
        // inline complete setup of $JTabbedPane0
        $JTabbedPane0.add($JScrollPane0);
        $JTabbedPane0.add($JScrollPane1);
        $TabInfo0.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener($JTabbedPane0, 0));
        $JTabbedPane0.setTitleAt(0, _("jaxxdemo.tree.tabtitle"));
        $TabInfo1.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener($JTabbedPane0, 1));
        $JTabbedPane0.setTitleAt(1, _("jaxxdemo.treeTable.tabtitle"));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(navigationTree);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(navigationTreeTable);
        
        // apply 10 property setters
        $JScrollPane0.setBorder(null);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        navigationTree.setModel(treeHelper.createModel());
        $JScrollPane1.setBorder(null);
        $JScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        navigationTreeTable.setTreeTableModel(treeTableHelper.createModel());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        createContentLayout();
        createDataProvider();
        createTreeHelper();
        createTreeTableHelper();
        createSplitPane();
        // inline creation of $JTabbedPane0
        $objectMap.put("$JTabbedPane0", $JTabbedPane0 = new javax.swing.JTabbedPane());
        
        $JTabbedPane0.setName("$JTabbedPane0");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createNavigationTree();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createNavigationTreeTable();
        createContent();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo0.setTitle(_("jaxxdemo.tree.tabtitle"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo1.setTitle(_("jaxxdemo.treeTable.tabtitle"));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}