/*
 * *##% 
 * JAXX Demo
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.demo.component.jaxx.navigation;

import jaxx.demo.component.jaxx.navigation.content.ActorContentUI;
import jaxx.demo.component.jaxx.navigation.content.ActorsContentUI;
import jaxx.demo.component.jaxx.navigation.content.MovieContentUI;
import jaxx.demo.component.jaxx.navigation.content.MoviesContentUI;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModelBuilder;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * @author chemit
 * @since 2.0.0
 */
public class FullNavigationTreeModelBuilder extends NavigationTreeModelBuilder {

    /** Logger */
    static private final Log log = LogFactory.getLog(FullNavigationTreeModelBuilder.class);

    protected FullNavigationTreeModelBuilder(JAXXContext context) {
        super("/", context, null, null);
    }

    public void addMovie(Movie movie) {
        //TODO
    }

    public void addActor(People people, Movie... movies) {
        //TODO
    }

    public void createInitialModel() {

        List<Movie> movies = FullNavigationTreeHelper.MOVIES.getContextValue(getModel().getContext());
        List<People> actors = FullNavigationTreeHelper.ACTORS.getContextValue(getModel().getContext());

        if (log.isDebugEnabled()) {
            log.debug("for " + movies.size() + " movie(s)");
        }


        DecoratorProvider decoratorProvider = getModel().getContext().getContextValue(DecoratorProvider.class);
        Decorator<Movie> mDecorator = decoratorProvider.getDecorator(Movie.class);
        Decorator<People> pDecorator = decoratorProvider.getDecorator(People.class);

        // construction du noeud root
        // il ne contient pas de context et ne sera pas visible
        NavigationTreeNode rootNode = buildEmptyRoot(null, "$root");

        // construction du noeud avec les films recupere la liste des films
        // dans le context avec la clef movies
        // navigation path = $root/movies
        NavigationTreeNode moviesNode = build(
                rootNode,
                _("movies"),
                FullNavigationTreeHelper.MOVIES,
                "movies",
                MoviesContentUI.class,
                null);

        for (Movie m : movies) {

            // navigation path = $root/movies/m.id
            NavigationTreeNode movieNode = build(
                    moviesNode,
                    mDecorator,
                    "..[@id=\"" + m.getId() + "\"]",
                    m.getId(),
                    MovieContentUI.class,
                    null);

            // navigation path = $root/movies/m.id/actors
            NavigationTreeNode actorsNode = build(
                    movieNode,
                    _("actors"),
                    "../actors",
                    "actors",
                    ActorsContentUI.class,
                    null);

            for (People p : m.getActors()) {
                // navigation path = $root/movies/m.id/actors/p.id
                build(
                        actorsNode,
                        pDecorator,
                        "..[@id=\"" + p.getId() + "\"]",
                        p.getId(),
                        ActorContentUI.class,
                        null);
            }
        }

        // construction du noeud avec les acteurs
        NavigationTreeNode actorsNode = build(rootNode, _("actors"),
                                              FullNavigationTreeHelper.ACTORS,
                                              "actors", ActorsContentUI.class, null);

        for (People p : actors) {
            // navigation path = $root/actors/p.id
            build(
                    actorsNode,
                    pDecorator,
                    "..[@id=\"" + p.getId() + "\"]",
                    p.getId(),
                    ActorContentUI.class,
                    null);
        }

        if (log.isDebugEnabled()) {
            printModel(getModel().getRoot());
        }
    }
}
