package jaxx.demo.component.jaxx.editor;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.Arrays;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.component.jaxx.editor.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.I18nEditor;
import org.nuiton.i18n.I18n;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class I18nEditorDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_POPUP_BORDER = "editor.popupBorder";
    public static final String BINDING_EDITOR_SHOW_ICON = "editor.showIcon";
    public static final String BINDING_EDITOR_SHOW_POPUP_ICON = "editor.showPopupIcon";
    public static final String BINDING_EDITOR_SHOW_POPUP_TEXT = "editor.showPopupText";
    public static final String BINDING_EDITOR_SHOW_TEXT = "editor.showText";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL1_TEXT = "$JLabel1.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Vv2/TQBTHX0KTNk1Lf9Go0AItRGLCoQIEUqvSX0QUBahoh4osnO1T4+L4DvtM3QXxJ/AnwM6CxMaEGJgZWBD/AkIMrIi7sx3XjZMGTAbHfvfe577v7t67N98h59gwt4c8T7FdixlNrNxd2dl5oO5hja1jR7MNyogN/i+ThWwdinrL7jC4WK+J8EoQXlkjTUosbB2KXqjBoMMOTOw0MGYMzsYjNMepbLWGFzzq2iG1JSqJ+urnj+xL/cXrLIBHubohnsrscVFRJn01yBo6g3E+0zNUMZG1y2XYhrXL9Q4L25qJHOc+auKn8Bz6a5CnyOYwBhd6T1kyZLxHGRTL67hJNpGFzSsMFClW5xZFCxG+DesGhygb8zet2/JVhFEqQXkGBT2kMJiKZezsc/3KNlJNHLkPlO+GU46LvLzAzbcKp6HI12mQ/W3s8SwnY75rDaw9WSWe8BuJu29oxBLfp+Jjw2Jsk1CXCl5Xhw6EUPi8+B5rG6shNSEpaRVO0y3fESomWSW2jm0/t1IsRNiqBjb1eFje3wYG5YQ1btuiI+sYyJPSzwdjNkzHSPzkK9HJj45mpg452+Vmvr319mJ5yIf8Mpk6UiYCKEd/lya+vP/2rhrWxiSfezLR9VBp8zNLbUKxzQwx9YhfGC4zzMo9RBfqUHCwyfuCrPuZBGFbwTAXx+cbE+GKCFfuIKfBEbn+rx8+lh5/PgHZKgyaBOlVJPw3oMAaNl8FYuoevbUsFQ3tD/DnqNDGt0KVm8fg5KKOGJpVDUvnu7Dk8UWYSViElhK18OnXxNbb5XAhMlzY6Y7u0WLkHkHesEzDwrJNBB0gsS0UqYNdnUSVnlT7GfE/SoOivCyf84mZmuiAuLJcrnmu+LsuZYu3Gz1TBvydwqK/Lfp5zCLGu5vqMryUzJ3ogdvHglJe+VeGMC93IZR6IlRTE7ppmEqtoTdCNw1nUms4nsDPiSmaVNXvXh3O27nUSv6C0EHDXA+59JtEQ7xpdsGUe8AUD10WKVGx2zEFp/2i/C+w8FpOm2FqjjBf7UK4lPr8CMIfGbH5R+4KAAA=";
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.editor.I18nEditor editor;
    protected javax.swing.JTextField popupBorderText;
    protected javax.swing.JCheckBox showIcon;
    protected javax.swing.JCheckBox showPopupIcon;
    protected javax.swing.JCheckBox showPopupText;
    protected javax.swing.JCheckBox showText;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private I18nEditorDemo $DemoPanel0 = this;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected Border getPopupBorder(String text) {
        if (text==null || text.trim().isEmpty()) {
            return null;
        }
        return new TitledBorder(_(text));
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public I18nEditorDemo() {
        super();
        $initialize();
    }

    public I18nEditorDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.editor.I18nEditor getEditor() {
        return editor;
    }

    public javax.swing.JTextField getPopupBorderText() {
        return popupBorderText;
    }

    public javax.swing.JCheckBox getShowIcon() {
        return showIcon;
    }

    public javax.swing.JCheckBox getShowPopupIcon() {
        return showPopupIcon;
    }

    public javax.swing.JCheckBox getShowPopupText() {
        return showPopupText;
    }

    public javax.swing.JCheckBox getShowText() {
        return showText;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDemoPanel() {
        if (!allComponentsCreated) {
            return;
        }
        demoPanel.add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        demoPanel.add(editor, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        demoPanel.add($JLabel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    @Override
    protected void createDemoPanel() {
        $objectMap.put("demoPanel", demoPanel = new jaxx.runtime.swing.Table());
        demoPanel.setName("demoPanel");
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new jaxx.runtime.swing.editor.I18nEditor());
        editor.setName("editor");
    }

    protected void createPopupBorderText() {
        $objectMap.put("popupBorderText", popupBorderText = new javax.swing.JTextField());
        popupBorderText.setName("popupBorderText");
        popupBorderText.setColumns(15);
    }

    protected void createShowIcon() {
        $objectMap.put("showIcon", showIcon = new javax.swing.JCheckBox());
        showIcon.setName("showIcon");
        showIcon.setSelected(true);
        showIcon.setText(_("jaxxdemo.i18neditor.showIcon"));
    }

    protected void createShowPopupIcon() {
        $objectMap.put("showPopupIcon", showPopupIcon = new javax.swing.JCheckBox());
        showPopupIcon.setName("showPopupIcon");
        showPopupIcon.setSelected(true);
        showPopupIcon.setText(_("jaxxdemo.i18neditor.showPopupIcon"));
    }

    protected void createShowPopupText() {
        $objectMap.put("showPopupText", showPopupText = new javax.swing.JCheckBox());
        showPopupText.setName("showPopupText");
        showPopupText.setSelected(true);
        showPopupText.setText(_("jaxxdemo.i18neditor.showPopupText"));
    }

    protected void createShowText() {
        $objectMap.put("showText", showText = new javax.swing.JCheckBox());
        showText.setName("showText");
        showText.setSelected(true);
        showText.setText(_("jaxxdemo.i18neditor.showText"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToDemoPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(showText);
        $JPanel0.add(showIcon);
        $JPanel0.add(showPopupText);
        $JPanel0.add(showPopupIcon);
        $JPanel0.add($JPanel1);
        // inline complete setup of $JPanel1
        $JPanel1.add($JLabel0);
        $JPanel1.add(popupBorderText);
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        $JPanel0.setBorder(new TitledBorder(_("jaxxdemo.i18neditor.configuration")));
        $JLabel0.setLabelFor(popupBorderText);
        jaxx.runtime.SwingUtil.setText(popupBorderText, _("i18neditor.popup.title"));
        
        editor.setLocales(Arrays.asList(I18n.getStore().getLocales()));
        $JLabel1.setBorder(new TitledBorder(_("jaxxdemo.i18neditor.selected.locale")));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 6 data bindings
        $registerDefaultBindings();
        $objectMap.put("$DemoPanel0", this);
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(0,1));
        createShowText();
        createShowIcon();
        createShowPopupText();
        createShowPopupIcon();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("jaxxdemo.i18neditor.popupBorderText"));
        createPopupBorderText();
        createEditor();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_POPUP_BORDER, true) {
        
            @Override
            public void applyDataBinding() {
                if (popupBorderText != null) {
                    $bindingSources.put("popupBorderText.getDocument()", popupBorderText.getDocument());
                    popupBorderText.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    popupBorderText.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_POPUP_BORDER));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (popupBorderText != null) {
                    editor.setPopupBorder(getPopupBorder(popupBorderText.getText()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (popupBorderText != null) {
                    javax.swing.text.Document $target = ((javax.swing.text.Document) $bindingSources.remove("popupBorderText.getDocument()"));
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    }
                    popupBorderText.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_POPUP_BORDER));
                }
            }
        
            public void $pr$u0(javax.swing.event.DocumentEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_ICON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showIcon != null) {
                    $bindingSources.put("showIcon.getModel()", showIcon.getModel());
                    showIcon.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    showIcon.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_ICON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showIcon != null) {
                    editor.setShowIcon(showIcon.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showIcon != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("showIcon.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    showIcon.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_ICON));
                }
            }
        
            public void $pr$u1(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_POPUP_ICON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupIcon != null) {
                    $bindingSources.put("showPopupIcon.getModel()", showPopupIcon.getModel());
                    showPopupIcon.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    showPopupIcon.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_POPUP_ICON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupIcon != null) {
                    editor.setShowPopupIcon(showPopupIcon.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupIcon != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("showPopupIcon.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    showPopupIcon.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_POPUP_ICON));
                }
            }
        
            public void $pr$u2(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_POPUP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (showPopupText != null) {
                    $bindingSources.put("showPopupText.getModel()", showPopupText.getModel());
                    showPopupText.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    showPopupText.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_POPUP_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showPopupText != null) {
                    editor.setShowPopupText(showPopupText.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showPopupText != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("showPopupText.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    showPopupText.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_POPUP_TEXT));
                }
            }
        
            public void $pr$u3(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (showText != null) {
                    $bindingSources.put("showText.getModel()", showText.getModel());
                    showText.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    showText.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showText != null) {
                    editor.setShowText(showText.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showText != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("showText.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    showText.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.I18nEditorDemo.this, BINDING_EDITOR_SHOW_TEXT));
                }
            }
        
            public void $pr$u4(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL1_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (editor != null) {
                    editor.addPropertyChangeListener("selectedLocale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (editor != null && editor.getSelectedLocale() != null) {
                    $JLabel1.setText(_(editor.getSelectedLocale().toString()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (editor != null) {
                    editor.removePropertyChangeListener("selectedLocale", this);
                }
            }
        });
    }

}