/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.tags.validator;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.compiler.CompilerException;
import org.nuiton.jaxx.compiler.JAXXCompiler;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptor;
import org.nuiton.jaxx.compiler.reflect.ClassDescriptorHelper;
import org.nuiton.jaxx.compiler.tags.TagHandler;
import org.nuiton.jaxx.compiler.tags.validator.BeanValidatorHandler;
import org.nuiton.jaxx.validator.swing.SwingValidator;
import org.w3c.dom.Element;

public class ExcludeFieldValidatorHandler
implements TagHandler {
    public static final String TAG = "excludeField";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String COMPONENT_ATTRIBUTE = "component";
    private static final Log log = LogFactory.getLog(ExcludeFieldValidatorHandler.class);

    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        if (compiler.getConfiguration().isVerbose()) {
            log.info((Object)tag);
        }
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        ClassDescriptor descriptor;
        if (compiler.getConfiguration().isVerbose()) {
            log.debug((Object)tag);
        }
        if (!(descriptor = ClassDescriptorHelper.getClassDescriptor(SwingValidator.class)).isAssignableFrom(compiler.getOpenComponent().getObjectClass())) {
            compiler.reportError("excludeField tag may only appear within BeanValidator tag but was " + tag);
            return;
        }
        BeanValidatorHandler.CompiledBeanValidator info = (BeanValidatorHandler.CompiledBeanValidator)compiler.getOpenComponent();
        if (!info.getAutoField()) {
            compiler.reportError("excludeField tag can not be used without an 'autoField' validator : " + tag);
            return;
        }
        String name = tag.getAttribute(NAME_ATTRIBUTE);
        String component = tag.getAttribute(COMPONENT_ATTRIBUTE);
        if (name == null || name.trim().isEmpty()) {
            compiler.reportError("excludeField tag requires a name attribute");
            return;
        }
        name = name.trim();
        if (component == null || component.trim().isEmpty()) {
            if (!compiler.checkReference(tag, name, false, name)) {
                compiler.reportError("excludeField tag requires a component attribute, try to use the name attribute [" + name + "] for the component, but no such component found");
                return;
            }
            component = name;
        }
        if (info.containsFieldEditor(component = component.trim())) {
            compiler.reportError("excludeField tag found a attribute component [" + component + "] already used in this validator");
            return;
        }
        if (info.containsExcludeFieldEditor(component)) {
            compiler.reportError("excludeField tag found a attribute component [" + component + "] already used in this validator");
            return;
        }
        if (compiler.checkReference(tag, component, true, COMPONENT_ATTRIBUTE)) {
            info.registerField(name, component, compiler);
        }
    }
}

