/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.java;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaElement;
import jaxx.compiler.java.JavaField;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.java.JavaMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;

public class JavaFileGenerator {
    private static final Log log = LogFactory.getLog(JavaFileGenerator.class);
    protected final String eol;
    protected final boolean verbose;
    protected int indentationLevel = 0;

    public static JavaField newField(int modifiers, String returnType, String name, boolean override) {
        return JavaFileGenerator.newField(modifiers, returnType, name, override, null);
    }

    public static JavaField newField(int modifiers, String returnType, String name, boolean override, String initializer) {
        return new JavaField(modifiers, returnType, name, override, initializer);
    }

    public static JavaMethod newMethod(int modifiers, String returnType, String name, String initializer, boolean override, String[] exceptions, JavaArgument ... arguments) {
        return new JavaMethod(modifiers, returnType, name, arguments, exceptions, initializer, override);
    }

    public static JavaMethod newMethod(int modifiers, String returnType, String name, String initializer, boolean override, JavaArgument ... arguments) {
        return JavaFileGenerator.newMethod(modifiers, returnType, name, initializer, override, StringUtil.EMPTY_STRING_ARRAY, arguments);
    }

    public static String getHeader(String header) {
        String all = "/*-----------------------------------------------------------------------*/";
        int size = header.length();
        if (size % 2 == 0) {
            ++size;
            header = header + " ";
        }
        int semi = (all.length() - size) / 2 - 5;
        char[] prefix = new char[semi];
        Arrays.fill(prefix, '-');
        String eol = JAXXCompiler.getLineSeparator();
        return all + eol + "/*--" + new String(prefix) + " " + header + " " + new String(prefix) + "--*/" + eol + all + eol;
    }

    public JavaFileGenerator(String eol, boolean verbose) {
        this.eol = eol;
        this.verbose = verbose && log.isDebugEnabled();
    }

    public String generateImport(String anImport) {
        return "import " + anImport + ';' + this.eol;
    }

    public void generateFile(JavaFile f, PrintWriter result) {
        String[] imports;
        String name = f.getName();
        if (this.verbose) {
            log.info((Object)name);
        }
        this.indentationLevel = 0;
        if (name.contains(".")) {
            result.append("package ");
            result.append(name.substring(0, name.lastIndexOf(".")));
            result.append(";");
            result.append(this.eol).append(this.eol);
        }
        if ((imports = f.getImports()).length > 0) {
            for (String anImport : imports) {
                result.append(this.generateImport(anImport));
            }
            result.append(this.eol);
        }
        result.append(this.generateClass(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateClass(JavaFile f) {
        StringBuffer rawBodyCode;
        List<String> interfaces;
        if (this.verbose) {
            log.info((Object)f.getName());
        }
        StringBuffer result = new StringBuffer();
        String genericType = f.getGenericType();
        result.append(f.getModifiersText());
        if (f.isAbstractClass()) {
            result.append("abstract ");
        }
        result.append("class ");
        result.append(f.getName().substring(f.getName().lastIndexOf(".") + 1));
        if (genericType != null) {
            result.append('<').append(genericType).append('>');
        }
        result.append(" extends ");
        result.append(f.getSuperClass());
        if (f.getSuperGenericType() != null) {
            result.append('<').append(f.getSuperGenericType()).append('>');
        }
        if ((interfaces = f.getInterfaces()) != null && !interfaces.isEmpty()) {
            result.append(" implements ").append(interfaces.get(0));
            for (int i = 1; i < interfaces.size(); ++i) {
                result.append(", ").append(interfaces.get(i));
            }
        }
        result.append(" {").append(this.eol);
        List<JavaField> fields = f.getFields();
        if (!fields.isEmpty()) {
            EnumMap<JavaField.FieldOrder, List<JavaField>> map = JavaField.getSortedFields(fields);
            for (Map.Entry<JavaField.FieldOrder, List<JavaField>> entry : map.entrySet()) {
                List<JavaField> list = entry.getValue();
                Collections.sort(list);
                if (!list.isEmpty()) {
                    result.append(this.eol);
                    result.append(this.addIndentation(entry.getKey().getHeader(), 4, this.eol));
                    result.append(this.eol);
                    result.append(this.eol);
                    for (JavaField method : list) {
                        String txt = this.generateField(method);
                        result.append(this.addIndentation(txt, 4, this.eol)).append(this.eol);
                    }
                }
                list.clear();
            }
            map.clear();
            result.append(this.eol);
        }
        if ((rawBodyCode = f.getRawBodyCode()).length() > 0) {
            result.append(this.addIndentation(JavaFileGenerator.getHeader("Raw body code from script"), 4, this.eol));
            result.append(this.eol);
            String s = rawBodyCode.toString();
            if (!s.startsWith(this.eol)) {
                result.append(this.eol);
            }
            result.append(this.addIndentation(s, 4, this.eol)).append(this.eol).append(this.eol);
        }
        List<JavaFile> innerClasses = f.getInnerClasses();
        for (JavaFile innerClass : innerClasses) {
            this.indentationLevel += 4;
            try {
                String txt = this.generateClass(innerClass);
                result.append(this.addIndentation(txt, 4, this.eol));
                result.append(this.eol);
                result.append(this.eol);
            }
            finally {
                this.indentationLevel -= 4;
            }
        }
        EnumMap<JavaMethod.MethodOrder, List<JavaMethod>> map = JavaMethod.getSortedMethods(f.getMethods());
        for (Map.Entry<JavaMethod.MethodOrder, List<JavaMethod>> entry : map.entrySet()) {
            List<JavaMethod> list = entry.getValue();
            if (!list.isEmpty()) {
                Collections.sort(list);
                result.append(this.addIndentation(entry.getKey().getHeader(), 4, this.eol));
                result.append(this.eol);
                result.append(this.eol);
                for (JavaMethod method : list) {
                    String txt = this.generateMethod(method);
                    result.append(this.addIndentation(txt, 4, this.eol));
                    result.append(this.eol);
                    result.append(this.eol);
                }
            }
            list.clear();
        }
        map.clear();
        result.append("}");
        return result.toString();
    }

    public String generateField(JavaField f) {
        if (this.verbose && log.isDebugEnabled()) {
            log.debug((Object)f.getName());
        }
        StringBuffer result = new StringBuffer();
        this.generateAnnotations(f, result, this.eol);
        result.append(f.getModifiersText());
        result.append(f.getType()).append(' ').append(f.getName());
        if (f.getInitializer() != null) {
            result.append(" = ").append(f.getInitializer());
        }
        result.append(';').append(this.eol);
        return result.toString();
    }

    protected void generateAnnotations(JavaElement element, StringBuffer result, String separator) {
        if (element.hasAnnotations()) {
            for (String annotation : element.getAnnotations()) {
                if (!annotation.startsWith("@")) {
                    result.append("@");
                }
                result.append(annotation).append(separator);
            }
        }
    }

    public String generateMethod(JavaMethod m) {
        String formattedBodyCode;
        if (this.verbose) {
            log.info((Object)m.getName());
        }
        StringBuffer result = new StringBuffer();
        if (m.isOverride()) {
            m.addAnnotation(Override.class.getSimpleName());
        }
        this.generateAnnotations(m, result, this.eol);
        result.append(m.getModifiersText());
        if (m.getReturnType() != null) {
            result.append(m.getReturnType());
            result.append(' ');
        }
        result.append(m.getName());
        result.append('(');
        JavaArgument[] arguments = m.getArguments();
        if (arguments != null && arguments.length > 0) {
            result.append(this.generateArgument(arguments[0]));
            for (int i = 1; i < arguments.length; ++i) {
                result.append(", ").append(this.generateArgument(arguments[i]));
            }
        }
        result.append(")");
        String[] exceptions = m.getExceptions();
        if (exceptions != null && exceptions.length > 0) {
            result.append(" throws ").append(exceptions[0]);
            for (int i = 1; i < exceptions.length; ++i) {
                result.append(", ").append(exceptions[i]);
            }
        }
        result.append(" {");
        result.append(this.eol);
        String body = m.getBody();
        if (body != null && (formattedBodyCode = this.addIndentation(body.trim(), 4, this.eol)).length() > 0) {
            result.append(formattedBodyCode).append(this.eol);
        }
        result.append("}");
        return result.toString();
    }

    public String generateArgument(JavaArgument argument) {
        String result = argument.getType() + ' ' + argument.getName();
        return argument.isFinal() ? "final " + result : result;
    }

    public String addIndentation(String source, int indentation, String lineSeparator) {
        return JavaFileGenerator.indent(source, this.indentationLevel + indentation, false, lineSeparator);
    }

    public static String indent(String source, int indentation, boolean trim, String lineSeparator) {
        if (trim) {
            source = source.trim();
        }
        char[] spaces = new char[indentation];
        Arrays.fill(spaces, ' ');
        StringBuffer result = new StringBuffer();
        String[] lines = source.split(lineSeparator + "|\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                result.append(lineSeparator);
            }
            result.append(spaces);
            result.append(trim ? lines[i].trim() : lines[i]);
        }
        return result.toString();
    }
}

