/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tags.validator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.beans.JAXXBeanInfo;
import jaxx.compiler.beans.JAXXPropertyDescriptor;
import jaxx.compiler.binding.DataBindingHelper;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.tags.DefaultObjectHandler;
import jaxx.compiler.types.TypeManager;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.ui.AbstractBeanValidatorUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class BeanValidatorHandler
extends DefaultObjectHandler {
    public static final String TAG = "BeanValidator";
    public static final String BEAN_ATTRIBUTE = "bean";
    public static final String BEAN_CLASS_ATTRIBUTE = "beanClass";
    public static final String BEAN_INITIALIZER_ATTRIBUTE = "beanInitializer";
    public static final String ERROR_LIST_MODEL_ATTRIBUTE = "errorListModel";
    public static final String ERROR_TABLE_MODEL_ATTRIBUTE = "errorTableModel";
    public static final String ERROR_LIST_ATTRIBUTE = "errorList";
    public static final String ERROR_TABLE_ATTRIBUTE = "errorTable";
    public static final String ERROR_LIST_MODEL_DEFAULT = "errors";
    public static final String ERROR_TABLE_MODEL_DEFAULT = "errors2";
    public static final String ERROR_LIST_DEFAULT = "errorList";
    public static final String ERROR_TABLE_DEFAULT = "errorTable";
    public static final String AUTOFIELD_ATTRIBUTE = "autoField";
    public static final String UI_CLASS_ATTRIBUTE = "uiClass";
    public static final String STRICT_MODE_ATTRIBUTE = "strictMode";
    public static final String CONTEXT_NAME_ATTRIBUTE = "contextName";
    public static final String PARENT_VALIDATOR_ATTRIBUTE = "parentValidator";
    static Log log = LogFactory.getLog(BeanValidatorHandler.class);
    protected static Map<JAXXCompiler, List<CompiledBeanValidator>> validators = new HashMap<JAXXCompiler, List<CompiledBeanValidator>>();
    protected static Map<JAXXCompiler, List<String>> validatedComponents = new HashMap<JAXXCompiler, List<String>>();

    public BeanValidatorHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorHelper.checkSupportClass(this.getClass(), beanClass, SwingValidator.class);
    }

    @Override
    protected CompiledObject createCompiledObject(String id, JAXXCompiler compiler) {
        return new CompiledBeanValidator(id, this.getBeanClass(), compiler);
    }

    @Override
    protected void compileChildTagFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)tag);
        }
        if (!tag.getLocalName().equals("field")) {
            compiler.reportError("tag '" + tag.getParentNode().getLocalName() + "' may only contain " + "field" + " as children, but found : " + tag.getLocalName());
        } else {
            compiler.compileFirstPass(tag);
        }
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        super.compileSecondPass(tag, compiler);
        CompiledBeanValidator info = (CompiledBeanValidator)objectMap.get(tag);
        boolean error = info.addErrorListModel(tag, this, compiler);
        if (!error) {
            error = info.addErrorList(tag, compiler);
        }
        if (!error) {
            error = info.addErrorTableModel(tag, this, compiler);
        }
        if (!error) {
            error = info.addErrorTable(tag, compiler);
        }
        if (!error) {
            error = info.addUiClass(this, compiler);
        }
        if (!error) {
            error = info.addBean(tag, this, compiler);
        }
        if (!error) {
            error = info.addParentValidator(tag, this, compiler);
        }
        if (error) {
            log.warn((Object)("error were detected in second compile pass of CompiledObject [" + info + "]"));
        }
        compiler.closeComponent(info);
    }

    @Override
    protected void setDefaults(CompiledObject object, Element tag, JAXXCompiler compiler) {
        compiler.openInvisibleComponent(object);
    }

    @Override
    public void setAttribute(CompiledObject object, String propertyName, String stringValue, boolean inline, JAXXCompiler compiler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(propertyName + " : " + stringValue + " for " + object));
        }
        object.addProperty(propertyName, stringValue);
    }

    public static boolean isBeanUsedByValidator(JAXXCompiler compiler, String beanId) {
        List<CompiledBeanValidator> beanValidatorList = validators.get(compiler);
        if (beanValidatorList != null) {
            for (CompiledBeanValidator validator : beanValidatorList) {
                if (!beanId.equals(validator.getBean())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasValidator(JAXXCompiler compiler) {
        List<CompiledBeanValidator> beanValidatorList = validators.get(compiler);
        return beanValidatorList != null && !beanValidatorList.isEmpty();
    }

    public static boolean isComponentUsedByValidator(JAXXCompiler compiler, String componentId) {
        List<String> ids = validatedComponents.get(compiler);
        return ids != null && ids.contains(componentId);
    }

    public static List<CompiledBeanValidator> getValidators(JAXXCompiler compiler) {
        return validators.get(compiler);
    }

    public static class CompiledBeanValidator
    extends CompiledObject {
        protected Map<String, String> fields = new TreeMap<String, String>();
        protected Map<String, String> excludeFields = new TreeMap<String, String>();
        protected String bean;
        protected String beanClass;
        protected String contextName;
        protected String uiClass;
        protected String errorListModel;
        protected String errorList;
        protected Boolean autoField;
        protected Boolean strictMode;
        protected JAXXBeanInfo beanDescriptor;
        protected String errorTableModel;
        protected String errorTable;
        protected String parentValidator;

        public CompiledBeanValidator(String id, ClassDescriptor objectClass, JAXXCompiler compiler) {
            super(id, CompiledBeanValidator.getDescriptor(objectClass, compiler), compiler);
            if (log.isDebugEnabled()) {
                log.debug((Object)("validator objectClass " + this.getObjectClass()));
            }
        }

        protected static ClassDescriptor getDescriptor(ClassDescriptor objectClass, JAXXCompiler compiler) {
            Class<?> validatorClass = compiler.getConfiguration().getValidatorClass();
            ClassDescriptor result = ClassDescriptorHelper.getClassDescriptor(validatorClass);
            return result;
        }

        public Map<String, String> getFields() {
            return this.fields;
        }

        public Map<String, String> getExcludeFields() {
            return this.excludeFields;
        }

        public void setFields(Map<String, String> fields) {
            this.fields = fields;
        }

        public void setExcludeFields(Map<String, String> excludeFields) {
            this.excludeFields = excludeFields;
        }

        @Override
        public void addProperty(String property, String value) {
            if (BeanValidatorHandler.BEAN_ATTRIBUTE.equals(property)) {
                if (value != null && !value.trim().isEmpty()) {
                    this.bean = value.trim();
                }
                return;
            }
            if (BeanValidatorHandler.CONTEXT_NAME_ATTRIBUTE.equals(property)) {
                if (value != null && !value.trim().isEmpty()) {
                    this.contextName = value.trim();
                }
                return;
            }
            if (BeanValidatorHandler.BEAN_CLASS_ATTRIBUTE.equals(property)) {
                if (value != null && !value.trim().isEmpty()) {
                    this.beanClass = value.trim();
                }
                return;
            }
            if (BeanValidatorHandler.ERROR_LIST_MODEL_ATTRIBUTE.equals(property)) {
                if (value != null && !value.trim().isEmpty()) {
                    this.errorListModel = value.trim();
                }
                return;
            }
            if ("errorList".equals(property)) {
                if (value != null && !value.trim().isEmpty()) {
                    this.errorList = value.trim();
                }
                return;
            }
            if (BeanValidatorHandler.ERROR_TABLE_MODEL_ATTRIBUTE.equals(property)) {
                if (value != null && !value.trim().isEmpty()) {
                    this.errorTableModel = value.trim();
                }
                return;
            }
            if ("errorTable".equals(property)) {
                if (value != null && !value.trim().isEmpty()) {
                    this.errorTable = value.trim();
                }
                return;
            }
            if (BeanValidatorHandler.UI_CLASS_ATTRIBUTE.equals(property)) {
                if (value != null && !value.trim().isEmpty()) {
                    this.uiClass = value.trim();
                }
                return;
            }
            if (BeanValidatorHandler.AUTOFIELD_ATTRIBUTE.equals(property)) {
                if (value != null && !value.trim().isEmpty()) {
                    this.autoField = (Boolean)TypeManager.convertFromString(value.trim(), Boolean.class);
                }
                return;
            }
            if (BeanValidatorHandler.STRICT_MODE_ATTRIBUTE.equals(property)) {
                if (value != null && !value.trim().isEmpty()) {
                    this.strictMode = (Boolean)TypeManager.convertFromString(value.trim(), Boolean.class);
                }
                return;
            }
            if (BeanValidatorHandler.PARENT_VALIDATOR_ATTRIBUTE.equals(property)) {
                if (value != null && !value.trim().isEmpty()) {
                    this.parentValidator = value.trim();
                }
                return;
            }
            throw new CompilerException("property " + property + " is not allowed on object " + this);
        }

        public String getBean() {
            return this.bean;
        }

        public String getErrorListModel() {
            return this.errorListModel;
        }

        public boolean getAutoField() {
            return this.autoField != null && this.autoField != false;
        }

        public boolean getStrictMode() {
            return this.strictMode != null && this.strictMode != false;
        }

        public String getUiClass() {
            return this.uiClass;
        }

        public String getBeanClass() {
            return this.beanClass;
        }

        public String getContextName() {
            return this.contextName;
        }

        public String getParentValidator() {
            return this.parentValidator;
        }

        public JAXXBeanInfo getBeanDescriptor(JAXXCompiler compiler) {
            if (this.beanDescriptor == null && this.foundBean()) {
                String beanClassName = null;
                try {
                    ClassDescriptor beanClassDescriptor = ClassDescriptorHelper.getClassDescriptor(this.beanClass);
                    this.beanDescriptor = DefaultObjectHandler.getJAXXBeanInfo(beanClassDescriptor);
                }
                catch (Exception e) {
                    compiler.reportError("could not load class " + beanClassName);
                }
            }
            return this.beanDescriptor;
        }

        @Override
        public void addChild(CompiledObject child, String constraints, JAXXCompiler compiler) throws CompilerException {
            compiler.reportError("can not add CompiledObject in the tag 'BeanValidator (only field tags)");
        }

        public boolean foundBean() {
            return this.beanClass != null && !this.beanClass.isEmpty();
        }

        protected boolean addUiClass(BeanValidatorHandler handler, JAXXCompiler compiler) {
            boolean withError = false;
            if (this.uiClass == null && compiler.getConfiguration().getDefaultErrorUI() != null) {
                this.uiClass = compiler.getConfiguration().getDefaultErrorUI().getName();
            }
            if (this.uiClass != null) {
                try {
                    ClassDescriptor uiClazz = ClassDescriptorHelper.getClassDescriptor(this.uiClass);
                    if (!ClassDescriptorHelper.getClassDescriptor(AbstractBeanValidatorUI.class).isAssignableFrom(uiClazz)) {
                        compiler.reportError("attribute 'ui'  :'" + this.uiClass + "' is not assignable from class " + AbstractBeanValidatorUI.class);
                        withError = true;
                    } else {
                        String code = handler.getSetPropertyCode(this.getJavaCode(), BeanValidatorHandler.UI_CLASS_ATTRIBUTE, uiClazz.getName() + ".class", compiler);
                        this.appendAdditionCode(code);
                    }
                }
                catch (ClassNotFoundException e) {
                    compiler.reportError("class not found '" + this.uiClass + "'");
                    withError = true;
                }
            }
            return withError;
        }

        protected boolean addErrorListModel(Element tag, BeanValidatorHandler handler, JAXXCompiler compiler) {
            if (this.errorListModel == null) {
                if (!compiler.checkReference(tag, BeanValidatorHandler.ERROR_LIST_MODEL_DEFAULT, false, BeanValidatorHandler.ERROR_LIST_MODEL_ATTRIBUTE)) {
                    return false;
                }
                this.errorListModel = BeanValidatorHandler.ERROR_LIST_MODEL_DEFAULT;
            } else if (this.errorListModel.startsWith("{") && this.errorListModel.endsWith("}")) {
                this.errorListModel = this.errorListModel.substring(1, this.errorListModel.length() - 1).trim();
            } else if (!compiler.checkReference(tag, this.errorListModel, true, BeanValidatorHandler.ERROR_LIST_MODEL_ATTRIBUTE)) {
                return true;
            }
            String code = handler.getSetPropertyCode(this.getJavaCode(), BeanValidatorHandler.ERROR_LIST_MODEL_ATTRIBUTE, this.errorListModel, compiler);
            this.appendAdditionCode(code);
            return false;
        }

        protected boolean addErrorTableModel(Element tag, BeanValidatorHandler handler, JAXXCompiler compiler) {
            if (this.errorTableModel == null) {
                if (!compiler.checkReference(tag, BeanValidatorHandler.ERROR_TABLE_MODEL_DEFAULT, false, BeanValidatorHandler.ERROR_LIST_MODEL_ATTRIBUTE)) {
                    return false;
                }
                this.errorTableModel = BeanValidatorHandler.ERROR_TABLE_MODEL_DEFAULT;
            } else if (this.errorTableModel.startsWith("{") && this.errorTableModel.endsWith("}")) {
                this.errorTableModel = this.errorTableModel.substring(1, this.errorTableModel.length() - 1).trim();
            } else if (!compiler.checkReference(tag, this.errorTableModel, true, BeanValidatorHandler.ERROR_TABLE_MODEL_ATTRIBUTE)) {
                return true;
            }
            String code = handler.getSetPropertyCode(this.getJavaCode(), BeanValidatorHandler.ERROR_TABLE_MODEL_ATTRIBUTE, this.errorTableModel, compiler);
            this.appendAdditionCode(code);
            return false;
        }

        protected boolean addParentValidator(Element tag, BeanValidatorHandler handler, JAXXCompiler compiler) {
            if (this.parentValidator != null) {
                String initializer;
                if (this.parentValidator.startsWith("{") && this.parentValidator.endsWith("}")) {
                    initializer = this.parentValidator.substring(1, this.parentValidator.length() - 1);
                } else {
                    if (!compiler.checkReference(tag, this.parentValidator, true, BeanValidatorHandler.PARENT_VALIDATOR_ATTRIBUTE)) {
                        return true;
                    }
                    initializer = this.parentValidator;
                }
                String code = handler.getSetPropertyCode(this.getJavaCode(), BeanValidatorHandler.PARENT_VALIDATOR_ATTRIBUTE, initializer, compiler);
                this.appendAdditionCode(code);
            }
            return false;
        }

        protected boolean addErrorList(Element tag, JAXXCompiler compiler) {
            if (this.errorList == null) {
                if (!compiler.checkReference(tag, "errorList", false, "errorList")) {
                    return false;
                }
                this.errorList = "errorList";
            } else if (!compiler.checkReference(tag, this.errorList, true, "errorList")) {
                return true;
            }
            String code = SwingValidatorUtil.class.getName() + ".registerErrorListMouseListener(" + this.errorList + ");";
            this.appendAdditionCode(code);
            return false;
        }

        protected boolean addErrorTable(Element tag, JAXXCompiler compiler) {
            if (this.errorTable == null) {
                if (!compiler.checkReference(tag, "errorTable", false, "errorTable")) {
                    return false;
                }
                this.errorTable = "errorTable";
            } else if (!compiler.checkReference(tag, this.errorTable, true, "errorTable")) {
                return true;
            }
            String code = SwingValidatorUtil.class.getName() + ".registerErrorTableMouseListener(" + this.errorTable + ");";
            this.appendAdditionCode(code);
            return false;
        }

        protected boolean addBean(Element tag, BeanValidatorHandler handler, JAXXCompiler compiler) {
            if ((this.beanClass == null || this.beanClass.isEmpty()) && this.bean != null && !this.bean.isEmpty()) {
                this.beanClass = compiler.getSymbolTable().getClassTagIds().get(this.bean);
                if (this.beanClass == null) {
                    compiler.reportError("could not find class of the bean '" + this.bean + "', and no beanClass was setted");
                    return true;
                }
            }
            if (this.beanClass == null) {
                compiler.reportError("tag '" + tag + "' requires a 'beanClass' attribute, " + "and could not guest it from 'bean' attribute " + "(no bean attribute setted...)");
                return true;
            }
            JAXXBeanInfo beanInfo = this.getBeanDescriptor(compiler);
            if (beanInfo == null) {
                compiler.reportError(tag, "could not find descriptor of class " + this.beanClass);
                return true;
            }
            String beanInitializer = null;
            if (this.bean != null) {
                if (this.bean.startsWith("{") && this.bean.endsWith("}")) {
                    String labelBinding = DataBindingHelper.processDataBindings(this.bean);
                    if (labelBinding != null) {
                        compiler.getBindingHelper().registerDataBinding(this.getId() + ".bean", labelBinding, this.getId() + ".setBean(" + labelBinding + ");");
                    }
                    this.bean = null;
                } else {
                    if (!compiler.checkReference(tag, this.bean, true, BeanValidatorHandler.BEAN_ATTRIBUTE)) {
                        return true;
                    }
                    if (BeanValidatorHandler.isBeanUsedByValidator(compiler, this.bean)) {
                        compiler.reportError("the bean '" + this.bean + "' is already used in " + "another the validator, can not used it in  '" + tag + "'");
                        return true;
                    }
                    beanInitializer = this.bean;
                }
            }
            if (beanInitializer != null) {
                String code = handler.getSetPropertyCode(this.getJavaCode(), BeanValidatorHandler.BEAN_ATTRIBUTE, compiler.checkJavaCode(beanInitializer), compiler);
                this.appendAdditionCode(code);
            }
            String beanClassName = beanInfo.getJAXXBeanDescriptor().getClassDescriptor().getName();
            this.setConstructorParams(beanClassName + ".class, " + TypeManager.getJavaCode(this.contextName));
            this.setGenericTypes(new String[]{beanClassName});
            if (this.getAutoField()) {
                this.registerAutoFieldBean(tag, compiler, beanInfo);
            }
            if (this.getBeanDescriptor(compiler) != null) {
                this.registerValidator(compiler, this);
            }
            return false;
        }

        private void registerValidator(JAXXCompiler compiler, CompiledBeanValidator compiledBeanValidator) {
            List<CompiledBeanValidator> vals = validators.get(compiler);
            if (vals == null) {
                vals = new ArrayList<CompiledBeanValidator>();
                validators.put(compiler, vals);
            }
            vals.add(compiledBeanValidator);
            List<String> ids = validatedComponents.get(compiler);
            if (ids == null) {
                ids = new ArrayList<String>();
                validatedComponents.put(compiler, ids);
            }
            ids.addAll(compiledBeanValidator.getFields().values());
        }

        @Deprecated
        protected void addFieldRepresentations(Element tag, JAXXCompiler compiler) {
            for (Map.Entry<String, String> entry : this.fields.entrySet()) {
                String propertyName = entry.getKey();
                String component = entry.getValue();
                if (!this.checkBeanProperty(compiler, propertyName)) continue;
                String keyCode = TypeManager.getJavaCode(propertyName);
                this.appendAdditionCode(this.getJavaCode() + ".setFieldRepresentation(" + keyCode + ", " + component + ");");
            }
        }

        public void addFieldRepresentations(JAXXCompiler compiler, StringBuilder buffer) {
            for (Map.Entry<String, String> entry : this.fields.entrySet()) {
                String propertyName = entry.getKey();
                String component = entry.getValue();
                if (!this.checkBeanProperty(compiler, propertyName)) continue;
                String keyCode = TypeManager.getJavaCode(propertyName);
                buffer.append(this.getJavaCode());
                buffer.append(".setFieldRepresentation(");
                buffer.append(keyCode);
                buffer.append(", ");
                buffer.append(component);
                buffer.append(");\n");
            }
        }

        protected void registerAutoFieldBean(Element tag, JAXXCompiler compiler, JAXXBeanInfo beanInfo) {
            for (JAXXPropertyDescriptor beanProperty : beanInfo.getJAXXPropertyDescriptors()) {
                String descriptionName = beanProperty.getName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("try to bind on bean " + beanInfo.getJAXXBeanDescriptor().getName() + " property " + descriptionName));
                }
                if (beanProperty.getWriteMethodDescriptor() == null || this.fields.containsKey(descriptionName) || this.excludeFields.containsKey(descriptionName) || !compiler.checkReference(tag, descriptionName, this.getStrictMode(), null)) continue;
                this.registerField(descriptionName, descriptionName, compiler);
            }
            for (Map.Entry<String, String> entry : this.excludeFields.entrySet()) {
                String key = entry.getKey();
                if (!this.fields.containsKey(key)) continue;
                compiler.reportWarning("field '" + key + "' can not be used and " + "excluded at same time ! (field is skipped) " + "for validator " + this);
                this.fields.remove(key);
            }
        }

        public void registerField(String id, String component, JAXXCompiler compiler) {
            if (this.fields.containsKey(id)) {
                compiler.reportError("duplicate field '" + id + "' for validator " + this);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("add field <" + id + ":" + component + ">"));
                }
                this.fields.put(id, component);
            }
        }

        public void registerExcludeField(String id, String component, JAXXCompiler compiler) {
            if (this.excludeFields.containsKey(id)) {
                compiler.reportError("duplicate field '" + id + "' for validator " + this);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("add excludeField <" + id + ":" + component + ">"));
                }
                this.excludeFields.put(id, component);
            }
        }

        protected boolean checkBeanProperty(JAXXCompiler compiler, String propertyName) {
            for (JAXXPropertyDescriptor beanProperty : this.getBeanDescriptor(compiler).getJAXXPropertyDescriptors()) {
                if (!beanProperty.getName().equals(propertyName)) continue;
                if (beanProperty.getWriteMethodDescriptor() == null) {
                    compiler.reportError("could not bind the readonly property '" + propertyName + "' on bean [" + this.getBean() + "] ");
                    return false;
                }
                return true;
            }
            compiler.reportError("could not find the property '" + propertyName + "' on bean [" + this.getBean() + "] ");
            return false;
        }
    }
}

