/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tags;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.tags.TagHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ImportHandler
implements TagHandler {
    protected static final Log log = LogFactory.getLog(ImportHandler.class);
    public static final String TAG_NAME = "import";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws IOException {
        StringBuffer script = new StringBuffer();
        NodeList children = tag.getChildNodes();
        block7: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    compiler.reportError("<import> tag may not contain child elements: " + tag);
                }
                case 3: 
                case 4: {
                    String txt = ((Text)child).getData();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Will treate imports  :[\n" + txt + "\n]"));
                    }
                    String eol = JAXXCompiler.getLineSeparator();
                    LineNumberReader reader = new LineNumberReader(new StringReader(txt.trim()));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if ((line = line.trim()).isEmpty()) continue;
                            script.append("import ").append(line);
                            if (!line.endsWith(";")) {
                                script.append(';');
                            }
                            script.append(eol);
                        }
                        continue block7;
                    }
                    finally {
                        reader.close();
                    }
                }
            }
        }
        String scriptString = script.toString().trim();
        if (!scriptString.isEmpty()) {
            compiler.registerScript(script.toString());
        }
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) {
    }
}

