/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.finalizers;

import java.util.List;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFinalizer;
import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaField;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.tags.validator.BeanValidatorHandler;
import jaxx.compiler.types.TypeManager;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;

public class ValidatorFinalizer
implements JAXXCompilerFinalizer {
    protected static final JavaField VALIDATOR_IDS_FIELD = JavaFileGenerator.newField(4, "java.util.List<String>", "validatorIds", true, "new ArrayList<String>()");

    @Override
    public boolean accept(JAXXCompiler compiler) {
        return BeanValidatorHandler.hasValidator(compiler);
    }

    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
        for (CompiledObject object : compiler.getObjects().values()) {
            List<CompiledObject.ChildRef> childs = object.getChilds();
            if (childs == null || childs.isEmpty()) continue;
            for (CompiledObject.ChildRef child : childs) {
                String javaCode = child.getChildJavaCode();
                boolean found = BeanValidatorHandler.isComponentUsedByValidator(compiler, child.getChild().getId());
                if (!found) continue;
                child.setChildJavaCode(SwingUtil.class.getSimpleName() + ".boxComponentWithJxLayer(" + javaCode + ")");
            }
        }
        String eol = JAXXCompiler.getLineSeparator();
        StringBuilder builder = new StringBuilder();
        List<BeanValidatorHandler.CompiledBeanValidator> validators = BeanValidatorHandler.getValidators(compiler);
        builder.append("// register ");
        builder.append(validators.size());
        builder.append(" validator(s)");
        builder.append(eol);
        for (BeanValidatorHandler.CompiledBeanValidator validator : validators) {
            String id = TypeManager.getJavaCode(validator.getId());
            builder.append("validatorIds.add(");
            builder.append(id);
            builder.append(");");
            builder.append(eol);
            builder.append("getValidator(");
            builder.append(id);
            builder.append(").installUIs();");
            builder.append(eol);
            builder.append("getValidator(");
            builder.append(id);
            builder.append(").reloadBean();");
            builder.append(eol);
        }
        builder.append("validatorIds = java.util.Collections.unmodifiableList(validatorIds);");
        builder.append(eol);
        compiler.appendLateInitializer(builder.toString());
    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws ClassNotFoundException {
        Class<?> validatorClass = compiler.getConfiguration().getValidatorClass();
        String validatorFQN = validatorClass.getName();
        javaFile.addImport(validatorFQN);
        Class<JAXXValidator> validatorInterface = JAXXValidator.class;
        ClassDescriptor superClass = ClassDescriptorHelper.getClassDescriptor(javaFile.getSuperClass());
        ClassDescriptor validatorInterfaceDescriptor = ClassDescriptorHelper.getClassDescriptor(validatorInterface);
        boolean parentIsValidator = validatorInterfaceDescriptor.isAssignableFrom(superClass);
        if (parentIsValidator) {
            return;
        }
        javaFile.addInterface(JAXXCompiler.getCanonicalName(validatorInterface));
        javaFile.addField(VALIDATOR_IDS_FIELD);
        javaFile.addMethod(JavaFileGenerator.newMethod(1, validatorFQN + "<?>", "getValidator", "return (" + validatorFQN + "<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);", true, new JavaArgument("String", "validatorId")));
    }
}

