/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: JSplitPaneHandler.java 1873 2010-05-04 19:48:38Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.0.2/jaxx-compiler/src/main/java/jaxx/compiler/tags/swing/JSplitPaneHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.compiler.tags.swing;

import jaxx.compiler.CompilerException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.tags.DefaultComponentHandler;
import org.w3c.dom.Element;

import javax.swing.JSplitPane;
import java.awt.Component;

public class JSplitPaneHandler extends DefaultComponentHandler {

    public JSplitPaneHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorHelper.checkSupportClass(getClass(), beanClass, JSplitPane.class);
    }

    protected Component createRawComponent(Element tag) {
        return new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
    }

    /**
     * Add support for <code>orientation="vertical"</code> and <code>orientation="horizontal"</code>.  The
     * values required by the JAXXBeanInfo are the unwieldy <code>vertical_split</code> and <code>horizontal_split</code>
     * (which are also recognized).
     */
    @Override
    protected int constantValue(String key, String value) {
        if (key.equals("orientation")) {
            value = value.trim().toLowerCase();
            if (value.equals("horizontal") || value.equals("horizontal_split")) {
                return JSplitPane.HORIZONTAL_SPLIT;
            }
            if (value.equals("vertical") || value.equals("vertical_split")) {
                return JSplitPane.VERTICAL_SPLIT;
            }
            throw new IllegalArgumentException("orientation must be 'horizontal' or 'vertical', found '" + value + "'");
        }
        return super.constantValue(key, value);
    }

    @Override
    public CompiledObject createCompiledObject(String id, JAXXCompiler compiler) throws CompilerException {
        return new CompiledObject(id, getBeanClass(), compiler) {

            private int count;

            @Override
            public void addChild(CompiledObject child, String constraints, JAXXCompiler compiler) throws CompilerException {
                if (constraints != null) {
                    compiler.reportError("JSplitPane does not accept constraints");
                }
                if (count == 0) {
                    super.addChild(child, "JSplitPane.LEFT", compiler);
                } else if (count == 1) {
                    super.addChild(child, "JSplitPane.RIGHT", compiler);
                } else {
                    compiler.reportError("JSplitPane is limited to two children");
                }
                count++;
            }
        };
    }
}
