/*
 * *##% 
 * JAXX Compiler
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.compiler.java;

import java.lang.reflect.Modifier;

/**
 * Base Java element
 * @author chemit
 * @since 2.0.0
 */
public abstract class JavaElement {

//    private String lineSeparator;
    private String name;
    private int modifiers;

    public JavaElement(int modifiers, String name) {
        this.modifiers = modifiers;
        this.name = name;
    }

    public final int getModifiers() {
        return modifiers;
    }

    public final void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public final String getName() {
        return name;
    }

    public final void setName(String className) {
        this.name = className;
    }

    public final String getModifiersText() {
        if (modifiers == 0) {
            return "";
        } else {
            return Modifier.toString(modifiers) + ' ';
        }
    }

//    public final String getLineSeparator() {
//        if (lineSeparator == null) {
//            lineSeparator = JAXXCompiler.getLineSeparator();
//        }
//        return lineSeparator;
//    }
//
//    public static String addIndentation(String source, int indentation, String lineSeparator) {
//        return indent(source, indentation, false, lineSeparator);
//    }
//
//    public static String setIndentation(String source, int indentation, String lineSeparator) {
//        return indent(source, indentation, true, lineSeparator);
//    }
//
//    public static String indent(String source, int indentation, boolean trim, String lineSeparator) {
//        if (trim) {
//            source = source.trim();
//        }
//        char[] spaces = new char[indentation];
//        Arrays.fill(spaces, ' ');
//        StringBuffer result = new StringBuffer();
//        String[] lines = source.split(System.getProperty("line.separator") + "|\n");
//        for (int i = 0; i < lines.length; i++) {
//            if (i > 0) {
//                result.append(lineSeparator);
//            }
//            result.append(spaces);
//            result.append(trim ? lines[i].trim() : lines[i]);
//        }
//        return result.toString();
//    }
}
