/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tags.swing;

import java.awt.Color;
import java.awt.event.ContainerListener;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompilerException;
import jaxx.compiler.I18nHelper;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorLoader;
import jaxx.compiler.tags.DefaultComponentHandler;
import jaxx.runtime.swing.TabInfo;

public class JTabbedPaneHandler
extends DefaultComponentHandler {
    public JTabbedPaneHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorLoader.checkSupportClass(this.getClass(), beanClass, JTabbedPane.class);
    }

    @Override
    public CompiledObject createCompiledObject(String id, JAXXCompiler compiler) throws CompilerException {
        return new CompiledTabbedPane(id, this.getBeanClass(), compiler);
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        this.addProxyEventInfo("getSelectedIndex", ChangeListener.class);
        this.addProxyEventInfo("getSelectedComponent", ChangeListener.class);
        this.addProxyEventInfo("getTabCount", ContainerListener.class);
    }

    public static class CompiledTabbedPane
    extends CompiledObject {
        private static final TabInfo USED = new TabInfo("ALREADY USED");
        int tabCount;
        TabInfo tabInfo;

        public CompiledTabbedPane(String id, ClassDescriptor objectClass, JAXXCompiler compiler) throws CompilerException {
            super(id, objectClass, compiler);
        }

        @Override
        public void addChild(CompiledObject child, String constraints, JAXXCompiler compiler) throws CompilerException {
            Icon disabledIcon;
            Icon icon;
            int displayedMnemonicIndex;
            int mnemonic;
            Color background;
            Color foreground;
            boolean enabled;
            String toolTipText;
            if (constraints != null) {
                compiler.reportError("JTabbedPane tabs may not have constraints");
            }
            super.addChild(child, constraints, compiler);
            if (this.tabInfo == null) {
                compiler.reportError("JTabbedPaneHandler may only have 'tab' tags as children (found " + child.getObjectClass() + ")");
                return;
            }
            if (this.tabInfo == USED) {
                compiler.reportError("<tab> tags may only have one child component");
                return;
            }
            int tabIndex = ++this.tabCount - 1;
            this.appendAdditionCode(this.tabInfo.getId() + ".addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(" + this.getId() + ", " + tabIndex + "));");
            String title = this.tabInfo.getTitle();
            if (title != null) {
                if (I18nHelper.isI18nAttribute("title")) {
                    if (!title.startsWith("_(\"")) {
                        title = I18nHelper.addI18nInvocation(this.getId(), "title", compiler.getJavaCode(title), compiler);
                    }
                } else {
                    title = compiler.getJavaCode(title);
                }
                this.appendAdditionCode(this.getId() + ".setTitleAt(" + tabIndex + ", " + title + ");");
            }
            if ((toolTipText = this.tabInfo.getToolTipText()) != null) {
                if (I18nHelper.isI18nAttribute("toolTipText")) {
                    if (!toolTipText.startsWith("_(\"")) {
                        toolTipText = I18nHelper.addI18nInvocation(this.getId(), "toolTipText", compiler.getJavaCode(toolTipText), compiler);
                    }
                } else {
                    toolTipText = compiler.getJavaCode(toolTipText);
                }
                this.appendAdditionCode(this.getId() + ".setToolTipTextAt(" + tabIndex + ", " + toolTipText + ");");
            }
            if (!(enabled = this.tabInfo.isEnabled())) {
                this.appendAdditionCode(this.getId() + ".setEnabledAt(" + tabIndex + ", false);");
            }
            if ((foreground = this.tabInfo.getForeground()) != null) {
                this.appendAdditionCode(this.getId() + ".setForegroundAt(" + tabIndex + ", " + compiler.getJavaCode(foreground) + ");");
            }
            if ((background = this.tabInfo.getBackground()) != null) {
                this.appendAdditionCode(this.getId() + ".setBackgroundAt(" + tabIndex + ", " + compiler.getJavaCode(background) + ");");
            }
            if ((mnemonic = this.tabInfo.getMnemonic()) != -1) {
                this.appendAdditionCode(this.getId() + ".setMnemonicAt(" + tabIndex + ", " + mnemonic + ");");
            }
            if ((displayedMnemonicIndex = this.tabInfo.getDisplayedMnemonicIndex()) != -1) {
                this.appendAdditionCode(this.getId() + ".setDisplayedMnemonicIndexAt(" + tabIndex + ", " + displayedMnemonicIndex + ");");
            }
            if ((icon = this.tabInfo.getIcon()) != null) {
                this.appendAdditionCode(this.getId() + ".setIconAt(" + tabIndex + ", " + icon + ");");
            }
            if ((disabledIcon = this.tabInfo.getDisabledIcon()) != null) {
                this.appendAdditionCode(this.getId() + ".setDisabledIconAt(" + tabIndex + ", " + disabledIcon + ");");
            }
            this.tabInfo = USED;
        }
    }
}

