/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import jaxx.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.ScriptInitializer;
import jaxx.parser.JavaParser;
import jaxx.parser.JavaParserTreeConstants;
import jaxx.parser.SimpleNode;
import jaxx.reflect.FieldDescriptor;
import jaxx.reflect.MethodDescriptor;
import jaxx.tags.TagManager;

public class ScriptManager {
    private JAXXCompiler compiler;

    ScriptManager(JAXXCompiler compiler) {
        this.compiler = compiler;
    }

    public String trimScript(String script) {
        if ((script = script.trim()).startsWith("{") && script.endsWith("}")) {
            this.compiler.reportWarning("curly braces are unnecessary for script '" + script + "'");
            script = script.substring(1, script.length() - 1);
        }
        return script;
    }

    public void checkParse(String script) throws CompilerException {
        script = this.trimScript(script);
        JavaParser p = new JavaParser(new StringReader(script));
        while (!p.Line()) {
        }
    }

    public String preprocessScript(String script) throws CompilerException {
        script = this.trimScript(script);
        StringBuffer result = new StringBuffer();
        JavaParser p = new JavaParser(new StringReader(script));
        while (!p.Line()) {
            SimpleNode node = p.popNode();
            if (node == null) continue;
            this.preprocessScriptNode(node, false);
            result.append(node.getText());
        }
        return result.toString();
    }

    private void scanCompoundSymbol(String symbol) {
        String[] tokens = symbol.split("\\.");
        StringBuffer currentSymbol = new StringBuffer();
        for (String token : tokens) {
            if (currentSymbol.length() > 0) {
                currentSymbol.append('.');
            }
            currentSymbol.append(token.trim());
            String contextClass = TagManager.resolveClassName(currentSymbol.toString(), this.compiler);
            if (contextClass == null) continue;
            this.compiler.addDependencyClass(contextClass);
        }
    }

    private void preprocessScriptNode(SimpleNode node, boolean staticContext) throws CompilerException {
        if (node.getId() == 22) {
            if (node.getParent().getChild(0).getText().indexOf("static") != -1) {
                staticContext = true;
            }
        } else if (node.getId() == 28 && node.getText().trim().startsWith("static")) {
            staticContext = true;
        }
        int count = node.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            this.preprocessScriptNode(node.getChild(i), staticContext);
        }
        int id = node.getId();
        if (id == 37 || id == 31) {
            this.scanCompoundSymbol(node.getText());
        }
        if (!staticContext) {
            String lhs = null;
            if (id == 41 || id == 59 && node.jjtGetNumChildren() == 2) {
                lhs = ((SimpleNode)node.jjtGetChild(0)).getText().trim();
            } else if (id == 55 || id == 56) {
                lhs = ((SimpleNode)node.jjtGetChild(0)).getText().trim();
            }
            if (lhs != null) {
                FieldDescriptor[] fields;
                for (FieldDescriptor field : fields = this.compiler.getScriptFields()) {
                    if (!field.getName().equals(lhs)) continue;
                    node.firstToken.image = "jaxx.runtime.Util.assignment(" + node.firstToken.image;
                    String outputClassName = this.compiler.getOutputClassName();
                    node.lastToken.image = node.lastToken.image + ", \"" + lhs + "\", " + outputClassName + ".this)";
                }
            }
        }
    }

    private int getLineType(SimpleNode line) {
        if (line.jjtGetNumChildren() == 1) {
            SimpleNode node = line.getChild(0);
            if (node.getId() == 77) {
                if (node.jjtGetNumChildren() == 1) {
                    return node.getChild(0).getId();
                }
            } else if (node.getId() == 16) {
                int id = node.getChild(0).getId();
                if (id == 4) {
                    return node.getChild(1).getId();
                }
                if (id == 28) {
                    return id;
                }
            }
            return node.getId();
        }
        return 0;
    }

    private SimpleNode findExplicitConstructorInvocation(SimpleNode parent) {
        if (parent.getId() == 27) {
            return parent;
        }
        int count = parent.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            SimpleNode result = this.findExplicitConstructorInvocation(parent.getChild(i));
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void processConstructor(String modifiers, SimpleNode node) {
        assert (node.getId() == 26) : "expected node to be ConstructorDeclaration, found " + JavaParserTreeConstants.jjtNodeName[node.getId()] + " instead";
        assert (node.getChild(0).getId() == 24) : "expected node 0 to be FormalParameters, found " + JavaParserTreeConstants.jjtNodeName[node.getChild(1).getId()] + " instead";
        String code = "";
        if (node.getChild(0).jjtGetNumChildren() == 0) {
            this.compiler.reportError("The default no-argument constructor may not be redefined");
        } else {
            SimpleNode explicitConstructorInvocation = this.findExplicitConstructorInvocation(node);
            if (explicitConstructorInvocation == null || explicitConstructorInvocation.getText().trim().startsWith("super(")) {
                code = "$initialize();" + JAXXCompiler.getLineSeparator();
                if (explicitConstructorInvocation == null) {
                    node.getChild((int)1).firstToken.image = node.getChild((int)1).firstToken.image;
                } else {
                    explicitConstructorInvocation.lastToken.image = explicitConstructorInvocation.lastToken.image + code;
                }
            }
        }
        this.compiler.appendBodyCode(modifiers + " " + node.getText().substring(0, node.getText().length() - 1) + code + "}");
    }

    private void scanScriptNode(SimpleNode node) throws CompilerException {
        String text;
        int nodeType = this.getLineType(node);
        if (nodeType == 3) {
            text = node.getChild(0).getText().trim();
            if (text.startsWith("import")) {
                text = text.substring("import".length()).trim();
            }
            if (text.endsWith(";")) {
                text = text.substring(0, text.length() - 1);
            }
            this.compiler.addImport(text);
        }
        this.preprocessScriptNode(node, false);
        if (nodeType != 3) {
            if (nodeType == 22) {
                String returnType = null;
                String name = null;
                ArrayList<String> parameterTypes = new ArrayList<String>();
                SimpleNode methodDeclaration = node.getChild(0).getChild(1);
                assert (methodDeclaration.getId() == 22);
                for (int i = 0; i < methodDeclaration.jjtGetNumChildren(); ++i) {
                    SimpleNode child = methodDeclaration.getChild(i);
                    int type = child.getId();
                    if (type == 36) {
                        String rawReturnType = child.getText().trim();
                        returnType = TagManager.resolveClassName(rawReturnType, this.compiler);
                        continue;
                    }
                    if (type != 23) continue;
                    name = child.firstToken.image.trim();
                    SimpleNode formalParameters = child.getChild(0);
                    assert (formalParameters.getId() == 24);
                    for (int j = 0; j < formalParameters.jjtGetNumChildren(); ++j) {
                        SimpleNode parameter = formalParameters.getChild(j);
                        String rawParameterType = parameter.getChild(1).getText().trim().replaceAll("\\.\\.\\.", "[]");
                        String parameterType = TagManager.resolveClassName(rawParameterType, this.compiler);
                        parameterTypes.add(parameterType);
                    }
                }
                this.compiler.appendBodyCode(node.getText());
                this.compiler.addScriptMethod(new MethodDescriptor(name, 1, returnType, parameterTypes.toArray(new String[parameterTypes.size()]), this.compiler.getClassLoader()));
            } else if (nodeType == 6 || nodeType == 28) {
                String str = node.getText().trim();
                if (str.endsWith(";")) {
                    str = str + ";";
                }
                this.compiler.appendBodyCode(str);
            } else if (nodeType == 26) {
                this.processConstructor(node.getChild(0).getChild(0).getText(), node.getChild(0).getChild(1));
            } else if (nodeType == 78 || nodeType == 17) {
                text = node.getText().trim();
                if (!text.endsWith(";")) {
                    text = text + ";";
                }
                String declaration = text;
                int equals = text.indexOf("=");
                if (equals != -1) {
                    declaration = declaration.substring(0, equals);
                }
                declaration = declaration.trim();
                String[] declarationTokens = declaration.split("\\s");
                boolean isFinal = Arrays.asList(declarationTokens).contains("final");
                boolean isStatic = Arrays.asList(declarationTokens).contains("static");
                String name = declarationTokens[declarationTokens.length - 1];
                if (name.endsWith(";")) {
                    name = name.substring(0, name.length() - 1).trim();
                }
                String className = declarationTokens[declarationTokens.length - 2];
                String type = TagManager.resolveClassName(className, this.compiler);
                this.compiler.addScriptField(new FieldDescriptor(name, 1, type, this.compiler.getClassLoader()));
                if (equals != -1 && !isFinal && !isStatic) {
                    this.compiler.appendBodyCode(text.substring(0, equals).trim() + ";");
                    String initializer = text.substring(equals + 1).trim();
                    if (type.endsWith("[]")) {
                        initializer = "new " + type + " " + initializer;
                    }
                    final String finalInitializer = name + " = " + initializer;
                    this.compiler.registerInitializer(new Runnable(){

                        @Override
                        public void run() {
                            ScriptManager.this.compiler.registerCompiledObject(new ScriptInitializer(finalInitializer, ScriptManager.this.compiler));
                        }
                    });
                } else {
                    this.compiler.appendBodyCode(text);
                }
                this.compiler.appendBodyCode("\n");
            } else {
                text = node.getText().trim();
                if (text.length() > 0) {
                    if (!text.endsWith(";")) {
                        text = text + ";";
                    }
                    this.compiler.appendInitializerCode(text);
                }
            }
        }
    }

    public void registerScript(String script) throws CompilerException {
        JavaParser p = new JavaParser(new StringReader(script));
        while (!p.Line()) {
            SimpleNode node = p.popNode();
            if (node == null) continue;
            this.scanScriptNode(node);
        }
    }
}

