/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.tags.swing;

import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.tags.DefaultComponentHandler;

import javax.swing.JToolBar;

public class JToolBarHandler extends DefaultComponentHandler {
    public JToolBarHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorLoader.checkSupportClass(getClass(), beanClass, JToolBar.class);
    }

    /**
     * Add support for <code>orientation="vertical"</code> and <code>orientation="horizontal"</code>.  These values should
     * have been supported without any special effort on my part, but JToolBar's BeanInfo doesn't contain the enum attribute
     * for the orientation property.
     */
    @Override
    protected int constantValue(String key, String value) {
        if (key.equals("orientation")) {
            value = value.trim().toLowerCase();
            if (value.equals("horizontal")) {
                return JToolBar.HORIZONTAL;
            }
            if (value.equals("vertical")) {
                return JToolBar.VERTICAL;
            }
            throw new IllegalArgumentException("orientation must be 'horizontal' or 'vertical', found '" + value + "'");
        }
        return super.constantValue(key, value);
    }
}