/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.application;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ApplicationDataUtil {
    public static void setProperty(Object bean, String property, Object value) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)property);
        try {
            PropertyUtils.setSimpleProperty((Object)bean, (String)property, (Object)value);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(String.format("Property %1s not found on object of type %2s", property, bean.getClass().getName()), e);
        }
    }

    public static Object getProperty(Object bean, String property) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)property);
        try {
            return PropertyUtils.getSimpleProperty((Object)bean, (String)property);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(String.format("Property %1s not found on object of type %2s", property, bean.getClass().getName()), e);
        }
    }

    public static String getDuration(Date startDate, Date endDate, String format) {
        String duration = "";
        if (startDate != null && endDate != null && !startDate.after(endDate)) {
            duration = DurationFormatUtils.formatPeriod((long)startDate.getTime(), (long)endDate.getTime(), (String)format);
        }
        return duration;
    }
}

