package org.nuiton.jaxx.application.type;

/*
 * #%L
 * JAXX :: Application API
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.jdesktop.beans.AbstractSerializableBean;

/**
 * Simple model for a progression long task.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.8
 */
public class ApplicationProgressionModel extends AbstractSerializableBean {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_TOTAL = "total";

    public static final String PROPERTY_CURRENT = "current";

    public static final String PROPERTY_RATE = "rate";

    public static final String PROPERTY_MESSAGE = "message";

    protected int total;

    protected int current;

    protected float rate;

    protected String message;

    public int getTotal() {
        return total;
    }

    public void setTotal(int total) {
        Object oldValue = getTotal();
        this.total = total;
        firePropertyChange(PROPERTY_TOTAL, oldValue, total);
        setCurrent(0);
    }

    public void adaptTotal(int total) {
        int current = getCurrent();
        setTotal(total);
        increments(current);
        Object oldValue = getTotal();
        this.total = total;
        firePropertyChange(PROPERTY_TOTAL, oldValue, total);
        setCurrent(current);
    }

    public int getCurrent() {
        return current;
    }

    public void setCurrent(int current) {
        Object oldValue = getCurrent();
        this.current = current;
        firePropertyChange(PROPERTY_CURRENT, oldValue, current);
    }

    public void increments(int nb) {
        setCurrent(current + nb);
        setRate(getCurrent() / getTotal());
    }

    public float getRate() {
        return rate;
    }

    public void setRate(float rate) {
        Object oldValue = getRate();
        this.rate = rate;
        firePropertyChange(PROPERTY_RATE, oldValue, rate);
    }

    public String getMessage() {
        return message;
    }

    public void increments(String message) {
        increments(1);
        setMessage(message);
    }

    public void setMessage(String message) {
        Object oldValue = getMessage();
        this.message = message;
        firePropertyChange(PROPERTY_MESSAGE, oldValue, message);
    }
}
