/*
 * *##% 
 * I18n :: Api
 * Copyright (C) 2004 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.i18n.init;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.bundle.I18nBundle;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleUtil;

import java.net.URL;
import java.util.List;

/**
 * Contract of a resolver of {@link I18nBundle}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.1
 */
public abstract class I18nInitializer {

    /** Logger */
    private static final Log log = LogFactory.getLog(I18nInitializer.class);

    /**
     * Resolv the bundles.
     *
     * @return the bundles detected
     * @throws Exception if any pb while getting bundles
     */
    public abstract I18nBundle[] resolvBundles() throws Exception;

    public I18nBundle[] resolvBundles(URL... urls) throws Exception {

        // detect bundles

        List<I18nBundle> bundles = I18nBundleUtil.detectBundles(urls);
        I18nBundle[] result = bundles.toArray(new I18nBundle[bundles.size()]);

        if (log.isInfoEnabled()) {

            I18nBundleEntry[] entries = I18nBundleUtil.getBundleEntries(result);

            log.info(bundles.size() + " bundle(s) found, in " +
                     entries.length + " file(s).");
        }

        return result;
    }

}
