/*
 * #%L
 * I18n :: Maven Plugin
 * 
 * $Id: KeysModifier.java 1782 2010-10-25 07:57:22Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/i18n/tags/i18n-2.3/maven-i18n-plugin/src/main/java/org/nuiton/i18n/plugin/parser/KeysModifier.java $
 * %%
 * Copyright (C) 2007 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.i18n.plugin.parser;

import org.nuiton.plugin.PluginHelper;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * IHM permettant de modifier les clés de traduction en direct dans les fichiers
 * parsés et les fichiers de propriétés.
 *
 * @author julien
 * @deprecated since 1.2, no more used actually, since we are using
 *             multi-thread parsing which is not compatible with a sequential
 *             parsing.
 */
@Deprecated
public class KeysModifier extends JFrame implements ParserEvent {

    private static final long serialVersionUID = 1L;

    // Modification des clés dans le fichier

    protected List<String> newKeys;

    protected boolean needModifiedFile;

    protected String patternLeft;

    protected String patternRight;

    protected String encoding;

    // Interface

    protected JLabel name = new JLabel();

    protected JLabel path = new JLabel();

    protected JTextField key = new JTextField();

    protected JTextField pattern = new JTextField(".*");

    protected JCheckBox onlyNewKey = new JCheckBox();

    protected JButton next = new JButton("Next >>");

    private static KeysModifier keysModifier;

    /**
     * Récupération d'une instance de l'interface
     *
     * @param patternLeft  left pattern
     * @param patternRight right pattern
     * @param encoding     encoding
     * @return the shared instance with new config
     */
    public static KeysModifier getInstance(String patternLeft,
                                           String patternRight,
                                           String encoding) {
        if (keysModifier == null) {
            keysModifier = new KeysModifier();
        }


        keysModifier.encoding = encoding;
        keysModifier.patternLeft = patternLeft;
        keysModifier.patternRight = patternRight;

        return keysModifier;
    }

    /** Contructeur de l'interface */
    private KeysModifier() {
        setLayout(new GridLayout(9, 2, 10, 10));

        Container pane = getContentPane();
        pane.add(new JLabel("--- File information ---"));
        pane.add(new JLabel());

        pane.add(new JLabel("Name :"));
        pane.add(name);

        pane.add(new JLabel("Path : "));
        pane.add(path);

        pane.add(new JLabel("--- Files language ---"));
        pane.add(new JLabel());

        pane.add(new JLabel("Key :"));
        pane.add(key);

        pane.add(new JLabel("--- Filters ---"));
        pane.add(new JLabel());

        pane.add(new JLabel("Pattern :"));
        pane.add(pattern);

        pane.add(new JLabel("Only new key :"));
        pane.add(onlyNewKey);

        pane.add(new JLabel());
        pane.add(next);

        next.addActionListener(new EventNextKey());
        addWindowListener(new EventWindows());

        setTitle("Keys modifier");
        setSize(800, 400);
//      pack();
        setVisible(true);
    }

    @Override
    public void eventChangeFile(File file) {
        name.setText(file.getName());
        path.setText(file.getPath());
        key.setText("");
        repaint();

        newKeys = new ArrayList<String>();
        needModifiedFile = false;
    }

    @Override
    public void eventNextFile(File file) {
        if (needModifiedFile) {
            String content;
            int region = 0;

            try {
                content = PluginHelper.readAsString(file, encoding);
            } catch (IOException e) {
                throw new ParserException(e);
            }

            for (Iterator<String> iterator = newKeys.iterator();
                 iterator.hasNext();) {
                String oldKey = iterator.next();
                String realKey = iterator.next();
                Pattern p = Pattern.compile('(' + patternLeft +
                                            ")(" + Pattern.quote(oldKey) +
                                            ")(" + patternRight + ')');
                Matcher matcher = p.matcher(content);
                matcher.region(region, content.length());
                matcher.find();
                region = matcher.start();
                content = matcher.replaceFirst("$1" + realKey + "$3");
            }

            try {
                PluginHelper.writeString(file, content, encoding);
            } catch (IOException e) {
                throw new ParserException(e);
            }
        }
    }

    @Override
    public synchronized void eventChangeKey(String keyI18n, boolean newKey) {
        key.setText(keyI18n);
        newKeys.add(key.getText());
        repaint();
        if (isVisible() &&
            keyI18n.matches(pattern.getText()) &&
            (!onlyNewKey.isSelected() || newKey)) {
            try {
                wait();
            } catch (InterruptedException e) {
                throw new ParserException(e);
            }
        }
    }

    @Override
    public String eventGetRealKey() {
        newKeys.add(key.getText());
        needModifiedFile |= !newKeys.get(newKeys.size() - 1).equals(
                newKeys.get(newKeys.size() - 2));
        return key.getText();
    }

    /** Action sur le boutton pour passer a la cle suivante */
    class EventNextKey implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            eventNextKey();
        }
    }

    /** Action sur la fermeture de la frame */
    class EventWindows extends WindowAdapter {

        @Override
        public void windowClosing(WindowEvent e) {
            setVisible(false);
            eventNextKey();
        }
    }

    /** Permet de passer à la clé suivante */
    public synchronized void eventNextKey() {
        notifyAll();
    }
}
