/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.logging.Log;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.I18nParserConfiguration;
import org.nuiton.io.SortedProperties;
import org.nuiton.plugin.PluginHelper;

public class ParserThread
extends Thread
implements I18nParserConfiguration {
    protected final I18nParserConfiguration configuration;
    protected final BlockingQueue<ParserTask> tasks;
    protected final List<File> treatedFiles;
    protected final List<File> touchedFiles;
    protected int nbFiles;
    private final Object lock = new Object();
    private final Object lock2 = new Object();

    public ParserThread(I18nParserConfiguration configuration) {
        super(ParserThread.class.getSimpleName());
        this.configuration = configuration;
        this.tasks = new LinkedBlockingQueue<ParserTask>();
        this.touchedFiles = new ArrayList<File>();
        this.treatedFiles = new ArrayList<File>();
    }

    @Override
    public boolean isVerbose() {
        return this.getConfiguration().isVerbose();
    }

    @Override
    public boolean isSilent() {
        return this.getConfiguration().isSilent();
    }

    @Override
    public boolean isShowTouchedFiles() {
        return this.getConfiguration().isShowTouchedFiles();
    }

    @Override
    public Log getLog() {
        return this.getConfiguration().getLog();
    }

    @Override
    public SortedProperties getResult() {
        return this.getConfiguration().getResult();
    }

    public List<File> getTreatedFiles() {
        return this.treatedFiles;
    }

    public List<File> getTouchedFiles() {
        return this.touchedFiles;
    }

    public void addFile(FileParser parser, File ... files) {
        for (File f : files) {
            ++this.nbFiles;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("[" + this.nbFiles + "] " + f));
            }
            this.tasks.offer(new ParserTask(parser, f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminatesAndWaits() {
        block12: {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)"add terminate runner");
            }
            this.tasks.offer(new ParserTask(null, null));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                if (!this.getLog().isErrorEnabled()) break block12;
                this.getLog().error((Throwable)e);
            }
        }
        if (this.getNbFilesToTreate() > 0) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)"block until ends...");
            }
            Object object = this.lock;
            synchronized (object) {
                block13: {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        if (!this.getLog().isErrorEnabled()) break block13;
                        this.getLog().error((Throwable)e);
                    }
                }
            }
        }
        if (this.getNbFilesToTreate() > 0) {
            throw new IllegalStateException("should have " + this.nbFiles + " files treated, but found " + this.treatedFiles.size());
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"thread is terminated.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ExecutorService executor = this.createExecutor();
        boolean canQuit = false;
        while (!canQuit) {
            ParserTask runner;
            try {
                runner = this.tasks.take();
            }
            catch (InterruptedException e) {
                if (this.getLog().isErrorEnabled()) {
                    this.getLog().error((Throwable)e);
                }
                canQuit = true;
                continue;
            }
            if (runner.getFile() == null) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)"Termination is asked..., will terminate to resting consume files");
                }
                canQuit = true;
                continue;
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("consume " + runner));
            }
            executor.execute(runner);
            if (!this.getLog().isDebugEnabled()) continue;
            this.getLog().debug((CharSequence)("after consume " + runner));
        }
        executor.shutdown();
        if (this.nbFiles == 0) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)"No file consumed.");
            }
        } else if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Will waits until all files (" + this.nbFiles + ") are consumed (still " + this.getNbFilesToTreate() + " file(s) to consume)"));
        }
        canQuit = false;
        while (!canQuit) {
            int nbFilesToTreate = this.getNbFilesToTreate();
            canQuit = executor.isTerminated() || nbFilesToTreate == 0;
            if (canQuit) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Waiting end... (still " + nbFilesToTreate + " file(s) to consume)"));
            }
            Object object = this.lock2;
            synchronized (object) {
                try {
                    this.lock2.wait();
                }
                catch (InterruptedException e) {
                    this.getLog().error((Throwable)e);
                    break;
                }
            }
            if (!this.getLog().isDebugEnabled()) continue;
            this.getLog().debug((CharSequence)("A task was consumed, still " + this.getNbFilesToTreate() + " file(s) to treate."));
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)"Executor is terminated, will release thread lock.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public void clear() {
        this.treatedFiles.clear();
        this.touchedFiles.clear();
        this.nbFiles = 0;
    }

    protected ExecutorService createExecutor() {
        ThreadFactory factory = new ThreadFactory(){
            final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = this.defaultFactory.newThread(r);
                thread.setName(ParserThread.this + "-" + thread.getName());
                return thread;
            }
        };
        ThreadPoolExecutor executor = new ThreadPoolExecutor(8, 10, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue(), factory){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                try {
                    super.afterExecute(r, t);
                    ParserTask i18n = (ParserTask)r;
                    i18n.registerResult(ParserThread.this.treatedFiles, ParserThread.this.touchedFiles, ParserThread.this.getResult());
                }
                finally {
                    Object object = ParserThread.this.lock2;
                    synchronized (object) {
                        ParserThread.this.lock2.notifyAll();
                    }
                }
            }
        };
        return executor;
    }

    protected I18nParserConfiguration getConfiguration() {
        return this.configuration;
    }

    protected int getNbFilesToTreate() {
        return this.nbFiles - this.treatedFiles.size();
    }

    class ParserTask
    implements Runnable {
        protected final FileParser parser;
        protected final File file;
        protected long startingTime;
        protected long endingTime;

        ParserTask(FileParser parser, File file) {
            this.parser = parser;
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.startingTime = System.nanoTime();
            if (ParserThread.this.getLog().isDebugEnabled()) {
                ParserThread.this.getLog().debug((CharSequence)("starting action for " + this.file));
            }
            try {
                this.parser.parseFile(this.file);
            }
            catch (IOException e) {
                if (ParserThread.this.getLog().isErrorEnabled()) {
                    ParserThread.this.getLog().error((CharSequence)("could not parse file " + this.file), (Throwable)e);
                }
            }
            finally {
                if (ParserThread.this.getLog().isDebugEnabled()) {
                    ParserThread.this.getLog().debug((CharSequence)("ending action for " + this.file));
                }
                this.endingTime = System.nanoTime();
            }
        }

        public String toString() {
            return super.toString() + " - " + this.file;
        }

        protected File getFile() {
            return this.file;
        }

        protected long getDelay() {
            return this.endingTime - this.startingTime;
        }

        protected void destroy() {
            this.parser.destroy();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.destroy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void registerResult(List<File> treatedFiles, List<File> touchedFiles, SortedProperties result) {
            try {
                String delay;
                treatedFiles.add(this.file);
                if (ParserThread.this.getLog().isDebugEnabled()) {
                    delay = PluginHelper.convertTime((long)this.getDelay());
                    ParserThread.this.getLog().debug((CharSequence)("[" + treatedFiles.size() + "] " + this.file + " in " + delay));
                }
                if (this.parser.isTouched()) {
                    touchedFiles.add(this.file);
                    if (ParserThread.this.isShowTouchedFiles()) {
                        ParserThread.this.getLog().info((CharSequence)("touch " + this.file));
                    }
                    if (ParserThread.this.isVerbose()) {
                        delay = PluginHelper.convertTime((long)this.getDelay());
                        ParserThread.this.getLog().info((CharSequence)("[" + treatedFiles.size() + "] touchs " + this.file + " in " + delay));
                    }
                    result.putAll((Map)this.parser.getResult());
                }
            }
            finally {
                this.destroy();
            }
        }
    }
}

