/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser;

import java.io.File;
import java.util.ArrayList;
import org.nuiton.i18n.plugin.parser.AbstractI18nParser;
import org.nuiton.util.SourceEntry;

public class I18nSourceEntry
extends SourceEntry {
    public boolean init(AbstractI18nParser mojo) {
        boolean todo;
        if (!this.useForGoal(mojo.getClass().getSimpleName())) {
            this.skipMessage = "exclude for this goal.";
            return true;
        }
        String[] filesForEntry = this.getFilesForEntry(mojo);
        if (filesForEntry.length == 0) {
            this.skipMessage = "no file found.";
            return true;
        }
        this.setUpdater(mojo.newFileUpdater(this));
        if (mojo.isStrictMode() || this.updater == null) {
            this.skipFiles = new String[0];
            this.files = filesForEntry;
            return false;
        }
        ArrayList<String> listFiles = new ArrayList<String>();
        ArrayList<String> listSkipFiles = new ArrayList<String>();
        for (String foundFile : filesForEntry) {
            File file = new File(this.getBasedir(), foundFile);
            if (this.isFileUptodate(file)) {
                listSkipFiles.add(foundFile);
                continue;
            }
            listFiles.add(foundFile);
        }
        boolean bl = todo = !listFiles.isEmpty();
        if (!todo) {
            this.skipMessage = "all files are up to date.";
            this.skipFiles = listSkipFiles.toArray(new String[listSkipFiles.size()]);
            this.files = new String[0];
            return true;
        }
        this.skipFiles = listSkipFiles.toArray(new String[listSkipFiles.size()]);
        this.files = listFiles.toArray(new String[listFiles.size()]);
        return false;
    }

    protected String[] getFilesForEntry(AbstractI18nParser mojo) {
        return this.getIncludedFiles(mojo.getDefaultBasedir(), mojo.getDefaultIncludes(), mojo.getDefaultExcludes());
    }
}

