/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.i18n.plugin.AbstractI18nPlugin;
import org.nuiton.util.PluginHelper;

public class Generate
extends AbstractI18nPlugin {
    protected boolean checkBundle;
    protected boolean showEmpty;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        if (!this.needGeneration()) {
            this.getLog().info((CharSequence)"Nothing to generate - all files are up to date.");
            return;
        }
        if (!this.silent) {
            this.getLog().info((CharSequence)("config - src basedir : " + this.src.getAbsolutePath()));
            this.getLog().info((CharSequence)("config - out basedir : " + this.out.getAbsolutePath()));
            this.getLog().info((CharSequence)("config - locales     : " + Arrays.toString(this.locales)));
        }
        for (Locale locale : this.locales) {
            if (!this.silent) {
                this.getLog().info((CharSequence)("prepare bundle for locale " + locale));
            }
            try {
                File bundleSrc = this.getI18nFile(this.src, this.artifactId, locale, false);
                File bundleOut = this.getI18nFile(this.out, this.artifactId, locale, false);
                PluginHelper.SortedProperties propertiesSrc = new PluginHelper.SortedProperties(this.encoding);
                if (bundleSrc.exists()) {
                    propertiesSrc.load(bundleSrc);
                }
                PluginHelper.SortedProperties propertiesOut = new PluginHelper.SortedProperties(this.encoding);
                if (!this.strictMode) {
                    propertiesOut.putAll((Map)propertiesSrc);
                }
                propertiesOut.load(bundleOut);
                for (Object key : propertiesOut.keySet()) {
                    Object oldKey = propertiesOut.get(key);
                    Object value = propertiesSrc.get(oldKey);
                    if (!key.equals(oldKey) && value == null) {
                        value = propertiesSrc.get(key);
                    }
                    if (value != null) {
                        propertiesOut.put(key, value);
                        continue;
                    }
                    propertiesOut.put(key, (Object)"");
                }
                propertiesOut.store((OutputStream)new FileOutputStream(bundleOut));
                if (this.genSrc && this.keepBackup) {
                    this.backupFile(bundleSrc);
                }
                if (!this.silent) {
                    this.getLog().info((CharSequence)("merge bundle " + locale + " to out"));
                }
                if (this.checkBundle) {
                    this.checkBundle(locale, (Properties)propertiesOut, this.showEmpty);
                }
                if (!this.genSrc) continue;
                this.copyFile(bundleOut, bundleSrc);
                if (this.silent) continue;
                this.getLog().info((CharSequence)("copy  bundle " + locale + " to src"));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"File Error I/O ", (Throwable)e);
                throw new MojoFailureException("File Error I/O ");
            }
        }
    }
}

