/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.parser.AbstractFileParser;
import org.nuiton.i18n.plugin.parser.AbstractI18nParserMojo;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.I18nSourceEntry;
import org.nuiton.i18n.plugin.parser.ParserException;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.i18n.plugin.parser.java.Java8BaseVisitor;
import org.nuiton.i18n.plugin.parser.java.Java8Lexer;
import org.nuiton.i18n.plugin.parser.java.Java8Parser;
import org.nuiton.io.FileUpdater;
import org.nuiton.io.FileUpdaterHelper;
import org.nuiton.io.SortedProperties;

@Mojo(name="parserJava", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class ParserJavaMojo
extends AbstractI18nParserMojo {
    public static final String DEFAULT_INCLUDES = "**/*.java";
    @Parameter(property="i18n.defaultBasedir", defaultValue="${basedir}/src/main/java")
    protected File defaultBasedir;
    @Parameter(property="i18n.defaultIncludes", defaultValue="**/*.java", required=true)
    protected String defaultIncludes;
    @Parameter(property="i18n.outputGetter", defaultValue="java.getter")
    protected String outputGetter;

    @Override
    public String[] getDefaultIncludes() {
        return new String[]{this.defaultIncludes};
    }

    @Override
    public String[] getDefaultExcludes() {
        return I18nSourceEntry.EMPTY_STRING_ARRAY;
    }

    @Override
    public File getDefaultBasedir() {
        return this.defaultBasedir;
    }

    @Override
    public FileUpdater newFileUpdater(SourceEntry entry) {
        return FileUpdaterHelper.newJavaFileUpdater((File)entry.getBasedir(), (File)this.cp);
    }

    @Override
    protected String getOutGetter() {
        return this.outputGetter;
    }

    @Override
    public FileParser newFileParser(Pattern acceptPattern) {
        return new JavaFileParser(this.getLog(), this.encoding, this.oldParser, acceptPattern, this.isShowTouchedFiles());
    }

    protected static class JavaFileParser
    extends AbstractFileParser {
        public JavaFileParser(Log log, String encoding, SortedProperties oldParser, Pattern acceptKeyPattern, boolean showTouchedFiles) {
            super(log, encoding, oldParser, acceptKeyPattern, showTouchedFiles);
        }

        @Override
        public void parseFile(File file) throws IOException {
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            if (content.contains("org.nuiton.i18n.I18n")) {
                CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)new Java8Lexer((CharStream)CharStreams.fromString((String)content)));
                Java8Parser parser = new Java8Parser((TokenStream)tokenStream);
                try {
                    ((ParserATNSimulator)parser.getInterpreter()).enable_global_context_dfa = true;
                    Java8Parser.CompilationUnitContext compilationUnitContext = parser.compilationUnit();
                    compilationUnitContext.accept(new JavaParserVisitor(file));
                }
                catch (Exception e) {
                    throw new ParserException(e);
                }
            }
        }

        @Override
        public void parseLine(File file, String line) throws IOException {
        }

        protected class JavaParserVisitor
        extends Java8BaseVisitor<Void> {
            protected final Set<String> simpleI18nMethodPrefix;
            protected final Set<String> complexI18nMethodPrefix;
            protected final File file;

            private JavaParserVisitor(File file) {
                this.file = file;
                this.simpleI18nMethodPrefix = new HashSet<String>();
                this.complexI18nMethodPrefix = new HashSet<String>();
                this.simpleI18nMethodPrefix.add("org.nuiton.i18n.I18n.n");
                this.simpleI18nMethodPrefix.add("org.nuiton.i18n.I18n.t");
                this.simpleI18nMethodPrefix.add("I18n.n");
                this.simpleI18nMethodPrefix.add("I18n.t");
                this.simpleI18nMethodPrefix.add("n");
                this.simpleI18nMethodPrefix.add("t");
                this.complexI18nMethodPrefix.add("org.nuiton.i18n.I18n.l");
                this.complexI18nMethodPrefix.add("I18n.l");
                this.complexI18nMethodPrefix.add("l");
            }

            @Override
            public Void visitMethodInvocation_lfno_primary(Java8Parser.MethodInvocation_lfno_primaryContext ctx) {
                Java8Parser.ArgumentListContext list = ctx.argumentList();
                Java8Parser.MethodNameContext mnc = ctx.methodName();
                TerminalNode tn = ctx.Identifier();
                Java8Parser.TypeNameContext tnc = ctx.typeName();
                Void aVoid = null;
                if (!this.visitMethod(list, mnc, tn, tnc)) {
                    aVoid = (Void)super.visitMethodInvocation_lfno_primary(ctx);
                }
                return aVoid;
            }

            @Override
            public Void visitMethodInvocation(Java8Parser.MethodInvocationContext ctx) {
                Java8Parser.ArgumentListContext list = ctx.argumentList();
                Java8Parser.MethodNameContext mnc = ctx.methodName();
                TerminalNode tn = ctx.Identifier();
                Java8Parser.TypeNameContext tnc = ctx.typeName();
                Void aVoid = null;
                if (!this.visitMethod(list, mnc, tn, tnc)) {
                    aVoid = (Void)super.visitMethodInvocation(ctx);
                }
                return aVoid;
            }

            protected boolean visitMethod(Java8Parser.ArgumentListContext list, Java8Parser.MethodNameContext mnc, TerminalNode tn, Java8Parser.TypeNameContext tnc) {
                boolean match = false;
                if (mnc != null || tnc != null && tn != null) {
                    Java8Parser.ExpressionContext argument;
                    String firstArgs;
                    String methodName;
                    String string = methodName = mnc != null ? mnc.getText() : tnc.getText() + "." + tn.getText();
                    if (this.simpleI18nMethodPrefix.contains(methodName)) {
                        Java8Parser.ExpressionContext argument2 = list.expression(0);
                        String firstArgs2 = argument2.getText();
                        if (firstArgs2.matches("^\"[^\"]+\"$")) {
                            String key = firstArgs2.substring(1).substring(0, firstArgs2.length() - 2);
                            if (JavaFileParser.this.getLog().isDebugEnabled()) {
                                JavaFileParser.this.getLog().debug((CharSequence)(this.file.getName() + " detected key = " + key));
                            }
                            JavaFileParser.this.registerKey(key);
                            match = true;
                        }
                    } else if (this.complexI18nMethodPrefix.contains(methodName) && (firstArgs = (argument = list.expression(1)).getText()).matches("^\"[^\"]+\"$")) {
                        String key = firstArgs.substring(1).substring(0, firstArgs.length() - 2);
                        if (JavaFileParser.this.getLog().isDebugEnabled()) {
                            JavaFileParser.this.getLog().debug((CharSequence)(this.file.getName() + " detected key = " + key));
                        }
                        JavaFileParser.this.registerKey(key);
                        match = true;
                    }
                }
                return match;
            }
        }
    }
}

