/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.parser.AbstractFileParser;
import org.nuiton.i18n.plugin.parser.AbstractI18nParserMojo;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.ParserException;
import org.nuiton.io.SortedProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractParserXmlMojo
extends AbstractI18nParserMojo {
    protected static final int BUFFER_SIZE = 8192;
    protected String rules;
    protected XPathFactory factory;
    protected DocumentBuilderFactory documentBuilderFactory;
    @Parameter
    protected String[] userRulesFiles;
    @Parameter
    protected Map<String, String> namespaces;

    protected abstract String getCoreRuleFile();

    protected abstract XmlFileParser newXmlFileParser(XPath var1, DocumentBuilder var2);

    protected List<String> getRulefiles() {
        String[] userFiles;
        ArrayList<String> result = new ArrayList<String>();
        String s = this.getCoreRuleFile();
        if (!StringUtils.isEmpty((CharSequence)s)) {
            result.add(s);
        }
        if ((userFiles = this.getUserRuleFiles()) != null) {
            for (String f : userFiles) {
                if (StringUtils.isEmpty((CharSequence)f)) continue;
                result.add(f);
            }
        }
        return result;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.factory = XPathFactory.newInstance();
        List<String> files = this.getRulefiles();
        if (files.isEmpty()) {
            throw new MojoFailureException("No rules files defined, fill the coreRulesFile or userRulesFiles parameters");
        }
        this.rules = this.loadRules(files);
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setValidating(false);
        this.documentBuilderFactory.setCoalescing(false);
        this.documentBuilderFactory.setIgnoringComments(true);
    }

    public final String[] getUserRuleFiles() {
        return this.userRulesFiles;
    }

    @Override
    public final FileParser newFileParser(Pattern acceptPattern) {
        DocumentBuilder builder;
        try {
            builder = this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("could not load DocumentBuilder for reason " + ex.getMessage(), ex);
        }
        XPath xpath = this.factory.newXPath();
        return this.newXmlFileParser(xpath, builder);
    }

    protected String loadRules(List<String> files) {
        ArrayList<String> rules = new ArrayList<String>();
        boolean verbose = !this.isSilent() && this.isVerbose();
        for (String file : files) {
            this.getLog().info((CharSequence)("Load rules file " + file));
            try {
                String fileRules = this.loadRulesFile(file);
                rules.add(fileRules);
                if (!verbose) continue;
                this.getLog().info((CharSequence)("Rules for file [" + file + "] : " + fileRules));
            }
            catch (IOException e) {
                throw new ParserException(e);
            }
        }
        String result = StringUtils.join(rules, (String)" | ");
        if (verbose) {
            this.getLog().info((CharSequence)("Loaded rules : " + result));
        }
        return result;
    }

    protected String loadRulesFile(String fileRules) throws IOException {
        InputStream inputStream;
        File f = new File(fileRules);
        if (f.exists()) {
            try {
                inputStream = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new ParserException(e);
            }
        } else {
            ClassLoader classLoader = this.getClass().getClassLoader();
            inputStream = classLoader.getResourceAsStream(fileRules);
        }
        if (inputStream == null) {
            throw new ParserException("could not found file of rules : " + fileRules);
        }
        inputStream = new BufferedInputStream(inputStream);
        try {
            String readInputStream;
            String string = readInputStream = this.readInputStream(inputStream);
            return string;
        }
        catch (IOException e) {
            throw new ParserException(e);
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readInputStream(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, this.encoding));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                sb.append(" ").append(line);
            }
        }
        String txt = sb.toString().trim();
        txt = txt.replaceAll("\\s+", " | ");
        txt = txt.replaceAll("(^ \\| )|( \\| $)", "");
        return txt;
    }

    public static abstract class XmlFileParser
    extends AbstractFileParser {
        private final XPath xpath;
        private final String rules;
        private final DocumentBuilder builder;
        private final Map<String, String> namespaces;
        private final Map<String, String> namespaces2;
        private final boolean verbose;

        public abstract String extract(String var1);

        public XmlFileParser(Log log, String encoding, SortedProperties oldParser, Pattern acceptKeyPattern, boolean showTouchedFiles, String rules, XPath xpath, DocumentBuilder builder, Map<String, String> namespaces, boolean verbose) {
            super(log, encoding, oldParser, acceptKeyPattern, showTouchedFiles);
            this.xpath = xpath;
            this.rules = rules;
            this.builder = builder;
            this.verbose = verbose;
            if (namespaces != null && !namespaces.isEmpty()) {
                this.namespaces = namespaces;
                this.namespaces2 = new TreeMap<String, String>();
                for (Map.Entry<String, String> e : namespaces.entrySet()) {
                    this.namespaces2.put(e.getValue(), e.getKey());
                }
                NamespaceContext ctx = new NamespaceContext(){

                    @Override
                    public String getNamespaceURI(String prefix) {
                        return (String)namespaces.get(prefix);
                    }

                    @Override
                    public String getPrefix(String namespaceURI) {
                        return (String)namespaces2.get(namespaceURI);
                    }

                    @Override
                    public Iterator<String> getPrefixes(String namespaceURI) {
                        return null;
                    }
                };
                xpath.setNamespaceContext(ctx);
            } else {
                this.namespaces2 = null;
                this.namespaces = null;
            }
        }

        @Override
        public File prepareFile(File file) throws IOException {
            return file;
        }

        @Override
        public void parseFile(File file) throws IOException {
            File fileToProcess = this.prepareFile(file);
            if (fileToProcess == null) {
                if (this.verbose) {
                    this.getLog().info((CharSequence)("Skip file " + file));
                }
                return;
            }
            try {
                if (this.verbose) {
                    this.getLog().info((CharSequence)("Start parsing file " + fileToProcess));
                }
                Document doc = this.fileToDocument(fileToProcess);
                XPathExpression expression = this.xpath.compile(this.rules);
                NodeList list = (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
                if (this.verbose) {
                    this.getLog().info((CharSequence)("Detected nodes [" + file + "] : " + list.getLength()));
                }
                for (int index = 0; index < list.getLength(); ++index) {
                    Node node = list.item(index);
                    this.parseLine(fileToProcess, node.getTextContent());
                }
            }
            catch (Exception e) {
                throw new ParserException(e);
            }
        }

        @Override
        public void parseLine(File file, String key) throws IOException {
            if ((key = this.extract(key)) != null) {
                this.registerKey(key);
            }
        }

        protected Document fileToDocument(File fileToProcess) throws SAXException, IOException {
            return this.builder.parse(fileToProcess.getAbsolutePath());
        }
    }
}

