/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.eugene.ModelReader;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.writer.ChainedFileWriter;

public class AvailableDataMojo
extends AbstractMojo {
    protected String dataTypes;
    protected Map<String, Model> modelTypes;
    protected Map<String, ModelReader<?>> modelReaders;
    protected Map<String, Template<?>> modelTemplates;
    protected Map<String, ChainedFileWriter> writers;

    public void execute() throws MojoExecutionException, MojoFailureException {
        EnumSet<AvailableData> safeDataTypes;
        StringBuilder buffer = new StringBuilder();
        String string = this.dataTypes = this.dataTypes == null ? "" : this.dataTypes.trim();
        if (StringUtils.isEmpty((String)this.dataTypes)) {
            safeDataTypes = EnumSet.allOf(AvailableData.class);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("will use all data types : " + safeDataTypes));
            }
        } else {
            safeDataTypes = EnumSet.noneOf(AvailableData.class);
            for (String s : this.dataTypes.split(",")) {
                s = s.trim().toLowerCase();
                try {
                    AvailableData data = AvailableData.valueOf(s);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("will use data type " + (Object)((Object)data)));
                    }
                    safeDataTypes.add(data);
                }
                catch (IllegalArgumentException e) {
                    this.getLog().warn((CharSequence)("does not know data type : " + s + " use one of " + Arrays.toString((Object[])AvailableData.values())));
                }
            }
        }
        for (AvailableData data : safeDataTypes) {
            buffer.append("\n");
            this.appendData(data, buffer);
        }
        this.getLog().info((CharSequence)("Get datas for data types : " + safeDataTypes + buffer.toString()));
    }

    protected void appendData(AvailableData data, StringBuilder buffer) {
        Map<String, ?> map = data.getData(this);
        int size = map.size();
        String dataType = data.name();
        if (size == 0) {
            buffer.append("\nNo available ").append(dataType).append(".");
        } else if (size == 1) {
            buffer.append("\nFound one ").append(dataType).append(" : ");
        } else {
            buffer.append("\nFound ");
            buffer.append(size);
            buffer.append(" ");
            buffer.append(dataType);
            buffer.append("s : ");
        }
        for (Map.Entry<String, ?> e : map.entrySet()) {
            String name = e.getKey();
            Object value = e.getValue();
            buffer.append("\n [");
            buffer.append(name);
            buffer.append("] with implementation '");
            buffer.append(data.toString(value));
            buffer.append('\'');
        }
    }

    static enum AvailableData {
        modeltype{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.modelTypes;
            }
        }
        ,
        writer{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.writers;
            }

            @Override
            String toString(Object data) {
                ChainedFileWriter w = (ChainedFileWriter)data;
                StringBuilder b = new StringBuilder(super.toString(data));
                b.append("\n").append("  inputProtocol             : ");
                b.append(w.getInputProtocol());
                b.append("\n").append("  outputProtocol            : ");
                b.append(w.getOutputProtocol("objectmodel"));
                b.append("\n").append("  defaultIncludes           : ");
                b.append(w.getDefaultIncludes());
                b.append("\n").append("  defaultInputDirectory     : ");
                b.append(w.getDefaultInputDirectory());
                b.append("\n").append("  defaultTestInputDirectory : ");
                b.append(w.getDefaultTestInputDirectory());
                return b.toString();
            }
        }
        ,
        modelreader{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.modelReaders;
            }
        }
        ,
        modeltemplate{

            @Override
            public Map<String, ?> getData(AvailableDataMojo mojo) {
                return mojo.modelTemplates;
            }
        };


        abstract Map<String, ?> getData(AvailableDataMojo var1);

        String toString(Object data) {
            return data.getClass().getName();
        }
    }
}

