/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.writer;

import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.nuiton.eugene.writer.AbstractChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;

public abstract class BaseChainedFileWriter
extends AbstractChainedFileWriter {
    private Log log;

    protected BaseChainedFileWriter(String ... propertyNameAndDescriptions) {
        super(propertyNameAndDescriptions);
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    protected void initWriter(ChainedFileWriterConfiguration configuration) {
        super.initWriter(configuration);
        StringBuilder buffer = new StringBuilder();
        Set set = this.getAuthorizedPropertyDescriptions().entrySet();
        if (set.isEmpty()) {
            buffer.append("Writer [");
            buffer.append(this.getInputProtocol());
            buffer.append("]");
            buffer.append(" does not use any specific properties.");
        } else {
            buffer.append("Writer [");
            buffer.append(this.getInputProtocol());
            buffer.append("]");
            buffer.append(" use ");
            buffer.append(this.properties.size());
            buffer.append(" properties :");
            if (this.getLog().isInfoEnabled()) {
                for (Map.Entry e : set) {
                    String key = (String)e.getKey();
                    Object value = this.properties.get(key);
                    if (value == null) continue;
                    buffer.append("\n");
                    buffer.append("  [");
                    buffer.append(key);
                    buffer.append("] (");
                    buffer.append((String)e.getValue());
                    buffer.append(") : ");
                    buffer.append(value);
                }
            }
        }
        this.getLog().info((CharSequence)buffer.toString());
    }

    protected boolean acceptObjectModelOrStateModel(String modelType) {
        return "objectmodel".equals(modelType = modelType.trim().toLowerCase()) || "statemodel".equals(modelType);
    }
}

