/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.writer;

import java.io.File;
import java.io.IOException;
import org.nuiton.eugene.plugin.writer.BaseChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginIOContext;

public class ZargoChainedFileWriter
extends BaseChainedFileWriter {
    public static final String[] XMI_FILE_FILTER = new String[]{"*.xmi", "**/*.xmi"};

    public ZargoChainedFileWriter() {
        super(new String[0]);
    }

    public String getInputProtocol() {
        return "zargo";
    }

    public String getOutputProtocol(String modelType) {
        return "xmi";
    }

    public boolean acceptModel(String modelType) {
        return this.acceptObjectModelOrStateModel(modelType);
    }

    public boolean acceptInclude(String include) {
        return include.startsWith("zargo:") || include.endsWith(".zargo") || include.endsWith(".zuml");
    }

    public String getDefaultIncludes() {
        return "**/*.zargo";
    }

    public String getDefaultInputDirectory() {
        return "src/main/xmi";
    }

    public String getDefaultOutputDirectory() {
        return "xmi";
    }

    public String getDefaultTestInputDirectory() {
        return "src/test/xmi";
    }

    public String getDefaultTestOutputDirectory() {
        return "test-xmi";
    }

    public void generate(ChainedFileWriterConfiguration configuration, File outputDir, File inputDirectory, String includePattern) throws IOException {
        boolean overwrite = configuration.isOverwrite();
        PluginIOContext ioContext = new PluginIOContext();
        ioContext.setInput(inputDirectory);
        ioContext.setOutput(outputDir);
        this.getLog().info((CharSequence)("Expanding xmi from " + inputDirectory + " : " + includePattern));
        PluginHelper.expandFiles((PluginIOContext)ioContext, (String[])new String[]{includePattern}, null, (String[])XMI_FILE_FILTER, (boolean)overwrite);
        this.getLog().info((CharSequence)("Copying resources from " + inputDirectory + " : " + includePattern));
        PluginHelper.copyFiles((PluginIOContext)ioContext, null, (String[])new String[]{includePattern}, (boolean)overwrite);
    }
}

