/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.modelextension;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.nuiton.eugene.plugin.modelextension.AttributeBean;
import org.nuiton.eugene.plugin.modelextension.ElementBean;

public class ClassBean
extends ElementBean {
    protected final Set<AttributeBean> attributes = new TreeSet<AttributeBean>();

    public ClassBean(String name) {
        super(name);
    }

    public Set<AttributeBean> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getAttributesTagValues() {
        TreeMap<String, String> attributesTagValues = new TreeMap<String, String>();
        for (AttributeBean attributeBean : this.attributes) {
            for (Map.Entry entry : attributeBean.tagValues.entrySet()) {
                attributesTagValues.put(attributeBean.name + "." + (String)entry.getKey(), (String)entry.getValue());
            }
        }
        return attributesTagValues;
    }

    public Set<String> getAttributesStereotypes() {
        TreeSet<String> attributesStereotypes = new TreeSet<String>();
        for (AttributeBean attributeBean : this.attributes) {
            for (String entry : attributeBean.stereotypes) {
                attributesStereotypes.add(attributeBean.name + "." + entry);
            }
        }
        return attributesStereotypes;
    }

    public AttributeBean getOrCreateAttribute(String attributeName) {
        AttributeBean result = null;
        for (AttributeBean attributeBean : this.attributes) {
            if (!attributeName.equals(attributeBean.name)) continue;
            result = attributeBean;
            break;
        }
        if (result == null) {
            result = new AttributeBean(attributeName);
            this.attributes.add(result);
        }
        return result;
    }
}

