/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorException;
import org.nuiton.eugene.java.AbstractJavaBeanTransformer;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.JavaTemplatesGeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;

public class SimpleJavaBeanTransformer
extends AbstractJavaBeanTransformer {
    private static final Log log = LogFactory.getLog(SimpleJavaBeanTransformer.class);

    public void transformFromModel(ObjectModel model) {
        String className = model.getName() + "BeanFactory";
        if (this.canGenerateFactory(model, className)) {
            this.generateBeanFactory(model, className);
        }
    }

    public void transformFromClass(ObjectModelClass input) {
        if (!JavaTemplatesGeneratorUtil.hasBeanStereotype((ObjectModelClassifier)input)) {
            return;
        }
        String interfaceName = this.getBeanInterfaceName(input);
        String className = this.getBeanClassName(input);
        boolean generateInterface = this.canGenerateInterface(input, interfaceName);
        boolean generateClass = this.canGenerateBean(input, className);
        if (generateClass || generateInterface) {
            ObjectModelClass outputClass = this.generateBeanClass(input, className, interfaceName);
            if (generateInterface) {
                this.generateBeanInterface(input, interfaceName, outputClass);
                if (generateClass) {
                    for (ObjectModelOperation operation : this.getPublicOperations(outputClass)) {
                        this.addAnnotation((ObjectModelClassifier)outputClass, (ObjectModelElement)operation, Override.class.getSimpleName());
                    }
                }
            }
            if (!generateClass) {
                this.builder.getModel().getClasses().remove(outputClass);
            }
        }
    }

    protected boolean canGenerateFactory(ObjectModel model, String className) {
        String generateTagValue = JavaTemplatesGeneratorUtil.getSimpleBeanGenerateFactoryTagValue(model);
        boolean generateFactory = generateTagValue != null && Boolean.valueOf(generateTagValue) != false;
        String defaultPackage = this.getConfiguration().getProperty("defaultPackage");
        String fqn = defaultPackage + "." + className;
        boolean canGenerate = generateFactory && !this.isInClassPath(fqn);
        return canGenerate;
    }

    protected boolean canGenerateInterface(ObjectModelClass input, String className) {
        boolean canGenerate;
        String generateTagValue = JavaTemplatesGeneratorUtil.getSimpleBeanGenerateInterfaceTagValue((ObjectModel)this.model, (ObjectModelClassifier)input);
        boolean generateInterface = generateTagValue != null && Boolean.valueOf(generateTagValue) != false;
        String fqn = input.getPackageName() + "." + className;
        boolean bl = canGenerate = generateInterface && !this.isInClassPath(fqn);
        if (canGenerate && !input.getOperations().isEmpty()) {
            throw new GeneratorException("Can't generate a simple bean interface as class " + fqn + " contains so operations." + "\nUse instead the JavaBeanTransformer.");
        }
        return canGenerate;
    }

    protected boolean canGenerateBean(ObjectModelClass input, String className) {
        boolean canGenerate;
        String fqn = input.getPackageName() + "." + className;
        boolean bl = canGenerate = !this.isInClassPath(fqn);
        if (canGenerate && !input.getOperations().isEmpty()) {
            throw new GeneratorException("Can't generate a simple bean as class " + fqn + " contains so operations." + "\nUse instead the JavaBeanTransformer.");
        }
        return canGenerate;
    }

    protected void generateBeanFactory(ObjectModel model, String className) {
        String defaultPackage = this.getConfiguration().getProperty("defaultPackage");
        ObjectModelClass output = this.createClass(className, defaultPackage);
        for (ObjectModelClass aClass : model.getClasses()) {
            if (aClass.isAbstract() || !JavaTemplatesGeneratorUtil.hasBeanStereotype((ObjectModelClassifier)aClass)) continue;
            String packageName = aClass.getPackageName();
            String typeName = this.getBeanInterfaceName(aClass);
            String typeBeanName = this.getBeanClassName(aClass);
            this.addImport((ObjectModelClassifier)output, packageName + "." + typeName);
            this.addImport((ObjectModelClassifier)output, packageName + "." + typeBeanName);
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "typeOf" + typeName, "Class<? extends " + typeName + ">", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.setOperationBody(operation, "\n        return " + typeBeanName + ".class;\n" + "    ");
            operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, typeName, new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.setOperationBody(operation, "\n        return new " + typeBeanName + "();\n" + "    ");
        }
    }

    protected ObjectModelInterface generateBeanInterface(ObjectModelClass input, String className, ObjectModelClass outputClass) {
        boolean serializableFound;
        ObjectModelInterface output = this.createInterface(className, input.getPackageName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("will generate " + output.getQualifiedName()));
        }
        boolean superClassIsBean = false;
        String superClass = null;
        Collection superclasses = input.getSuperclasses();
        if (CollectionUtils.isNotEmpty((Collection)superclasses)) {
            for (ObjectModelClass superclass : superclasses) {
                if (JavaTemplatesGeneratorUtil.hasBeanStereotype((ObjectModelClassifier)superclass)) {
                    superClassIsBean = true;
                    superClass = superclass.getPackageName() + "." + this.getBeanInterfaceName(superclass);
                    break;
                }
                superClass = superclass.getQualifiedName();
            }
        }
        if (superClass == null) {
            superClass = JavaTemplatesGeneratorUtil.getSimpleBeanInterfaceSuperClassTagValue((ObjectModel)this.model, (ObjectModelClassifier)input);
        }
        if ((serializableFound = this.addInterfaces(input, (ObjectModelClassifier)output, superClass)) || superClassIsBean) {
            this.addInterface((ObjectModelClassifier)output, Serializable.class);
        }
        this.generateI18nBlockAndConstants(input, (ObjectModelClassifier)output);
        for (ObjectModelOperation operation : this.getPublicOperations(outputClass)) {
            this.cloneOperation(operation, (ObjectModelClassifier)output, true, new ObjectModelJavaModifier[0]);
        }
        return output;
    }

    protected ObjectModelClass generateBeanClass(ObjectModelClass input, String className, String interfaceName) {
        boolean serializableFound;
        boolean generateInterface = interfaceName != null;
        String superClass = null;
        boolean superClassIsBean = false;
        Collection superclasses = input.getSuperclasses();
        if (CollectionUtils.isNotEmpty((Collection)superclasses)) {
            for (ObjectModelClass superclass : superclasses) {
                if (JavaTemplatesGeneratorUtil.hasBeanStereotype((ObjectModelClassifier)superclass)) {
                    superClassIsBean = true;
                    superClass = this.getBeanClassName(superclass);
                    break;
                }
                superClass = superclass.getQualifiedName();
            }
        }
        if (!superClassIsBean && (superClass = JavaTemplatesGeneratorUtil.getSimpleBeanSuperClassTagValue((ObjectModel)this.model, (ObjectModelClassifier)input)) != null) {
            superClassIsBean = true;
        }
        ObjectModelClass output = input.isAbstract() ? this.createAbstractClass(className, input.getPackageName()) : this.createClass(className, input.getPackageName());
        if (superClass != null) {
            this.setSuperClass(output, superClass);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("will generate " + output.getQualifiedName()));
        }
        if (generateInterface) {
            this.addInterface((ObjectModelClassifier)output, interfaceName);
            serializableFound = true;
        } else {
            serializableFound = this.addInterfaces(input, (ObjectModelClassifier)output, null);
            this.generateI18nBlockAndConstants(input, (ObjectModelClassifier)output);
        }
        this.addSerializable(input, output, serializableFound || superClassIsBean);
        List<ObjectModelAttribute> properties = this.getProperties(input);
        String noPCSTagValue = JavaTemplatesGeneratorUtil.getNoPCSTagValue((ObjectModel)this.model, (ObjectModelClassifier)input);
        boolean usePCS = StringUtils.isEmpty((CharSequence)noPCSTagValue) || !"true".equals(noPCSTagValue.trim());
        String noGenerateBooleanGetMethods = JavaGeneratorUtil.getDoNotGenerateBooleanGetMethods((ObjectModel)((ObjectModel)this.model), (ObjectModelClassifier)input);
        boolean generateBooleanGetMethods = StringUtils.isEmpty((CharSequence)noGenerateBooleanGetMethods) || !"true".equals(noGenerateBooleanGetMethods.trim());
        for (ObjectModelAttribute attr : properties) {
            this.createProperty(output, attr, usePCS, generateBooleanGetMethods);
        }
        if (!superClassIsBean) {
            this.addDefaultMethodForNoneBeanSuperClass(output, usePCS, properties);
        }
        return output;
    }

    protected Collection<ObjectModelOperation> getPublicOperations(ObjectModelClass clazz) {
        ArrayList<ObjectModelOperation> result = new ArrayList<ObjectModelOperation>();
        for (ObjectModelOperation operation : clazz.getOperations()) {
            ObjectModelJavaModifier visibility = ObjectModelJavaModifier.fromVisibility((String)operation.getVisibility());
            if (ObjectModelJavaModifier.PUBLIC != visibility) continue;
            result.add(operation);
        }
        return result;
    }

    protected String getBeanInterfaceName(ObjectModelClass input) {
        String interfaceNamePrefix = JavaTemplatesGeneratorUtil.getSimpleBeanInterfaceNamePrefixTagValue((ObjectModel)this.model, (ObjectModelClassifier)input);
        String interfaceNameSuffix = JavaTemplatesGeneratorUtil.getSimpleBeanInterfaceNameSuffixTagValue((ObjectModel)this.model, (ObjectModelClassifier)input);
        return this.generateName(interfaceNamePrefix, input.getName(), interfaceNameSuffix);
    }

    protected String getBeanClassName(ObjectModelClass input) {
        String classNamePrefix = JavaTemplatesGeneratorUtil.getSimpleBeanClassNamePrefixTagValue((ObjectModel)this.model, (ObjectModelClassifier)input);
        String classNameSuffix = JavaTemplatesGeneratorUtil.getSimpleBeanClassNameSuffixTagValue((ObjectModel)this.model, (ObjectModelClassifier)input);
        return this.generateName(classNamePrefix, input.getName(), classNameSuffix);
    }

    protected String generateName(String prefix, String name, String suffix) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            sb.append(prefix);
        }
        sb.append(name);
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }
}

