/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.index.impl.lucene.ConnectionBroker;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.LuceneIndexImplementation;
import org.neo4j.index.impl.lucene.LuceneXaConnection;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.ConfigProxy;
import org.neo4j.kernel.impl.index.IndexConnectionBroker;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.index.ReadOnlyIndexConnectionBroker;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;

public class LuceneIndexProvider
extends IndexProvider {
    private static List<WeakReference<LuceneIndexImplementation>> previousProviders = new ArrayList<WeakReference<LuceneIndexImplementation>>();

    public LuceneIndexProvider() {
        super("lucene");
    }

    public IndexImplementation load(DependencyResolver dependencyResolver) {
        Map params = (Map)dependencyResolver.resolveDependency(Map.class);
        AbstractGraphDatabase gdb = (AbstractGraphDatabase)dependencyResolver.resolveDependency(AbstractGraphDatabase.class);
        TransactionManager txManager = (TransactionManager)dependencyResolver.resolveDependency(TransactionManager.class);
        IndexStore indexStore = (IndexStore)dependencyResolver.resolveDependency(IndexStore.class);
        XaFactory xaFactory = (XaFactory)dependencyResolver.resolveDependency(XaFactory.class);
        FileSystemAbstraction fileSystemAbstraction = (FileSystemAbstraction)dependencyResolver.resolveDependency(FileSystemAbstraction.class);
        XaDataSourceManager xaDataSourceManager = (XaDataSourceManager)dependencyResolver.resolveDependency(XaDataSourceManager.class);
        Configuration conf = (Configuration)ConfigProxy.config((Map)params, Configuration.class);
        LuceneDataSource luceneDataSource = new LuceneDataSource((LuceneDataSource.Configuration)ConfigProxy.config((Map)params, LuceneDataSource.Configuration.class), indexStore, fileSystemAbstraction, xaFactory);
        xaDataSourceManager.registerDataSource((XaDataSource)luceneDataSource);
        Object broker = conf.read_only(false) ? new ReadOnlyIndexConnectionBroker(txManager) : new ConnectionBroker(txManager, luceneDataSource);
        Iterator<WeakReference<LuceneIndexImplementation>> iterator = previousProviders.iterator();
        while (iterator.hasNext()) {
            WeakReference<LuceneIndexImplementation> previousProvider = iterator.next();
            LuceneIndexImplementation indexImplementation = (LuceneIndexImplementation)previousProvider.get();
            if (indexImplementation == null) {
                iterator.remove();
                continue;
            }
            if (!indexImplementation.matches((GraphDatabaseService)gdb)) continue;
            indexImplementation.reset(luceneDataSource, (IndexConnectionBroker<LuceneXaConnection>)broker);
        }
        LuceneIndexImplementation indexImplementation = new LuceneIndexImplementation((GraphDatabaseService)gdb, luceneDataSource, (IndexConnectionBroker<LuceneXaConnection>)broker);
        previousProviders.add(new WeakReference<LuceneIndexImplementation>(indexImplementation));
        return indexImplementation;
    }

    public static interface Configuration {
        public boolean read_only(boolean var1);
    }
}

