/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.index.impl.lucene.LuceneIndex;
import org.neo4j.index.impl.lucene.LuceneTransaction;
import org.neo4j.kernel.impl.index.IndexXaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceHelpImpl;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;

public class LuceneXaConnection
extends IndexXaConnection {
    private final LuceneXaResource xaResource;
    private LuceneTransaction luceneTx;

    LuceneXaConnection(Object identifier, XaResourceManager xaRm, byte[] branchId) {
        super(xaRm);
        this.xaResource = new LuceneXaResource(identifier, xaRm, branchId);
    }

    public XAResource getXaResource() {
        return this.xaResource;
    }

    LuceneTransaction getLuceneTx() {
        if (this.luceneTx == null) {
            try {
                this.luceneTx = (LuceneTransaction)this.getTransaction();
            }
            catch (XAException e) {
                throw new RuntimeException("Unable to get lucene tx", e);
            }
        }
        return this.luceneTx;
    }

    <T extends PropertyContainer> void add(LuceneIndex<T> index, T entity, String key, Object value) {
        this.getLuceneTx().add(index, entity, key, value);
    }

    <T extends PropertyContainer> void remove(LuceneIndex<T> index, T entity, String key, Object value) {
        this.getLuceneTx().remove(index, entity, key, value);
    }

    <T extends PropertyContainer> void remove(LuceneIndex<T> index, T entity, String key) {
        this.getLuceneTx().remove(index, entity, key);
    }

    <T extends PropertyContainer> void remove(LuceneIndex<T> index, T entity) {
        this.getLuceneTx().remove(index, entity);
    }

    <T extends PropertyContainer> void deleteIndex(LuceneIndex<T> index) {
        this.getLuceneTx().delete(index);
    }

    public void createIndex(Class<? extends PropertyContainer> entityType, String name, Map<String, String> config) {
        this.getLuceneTx().createIndex(entityType, name, config);
    }

    private static class LuceneXaResource
    extends XaResourceHelpImpl {
        private final Object identifier;

        LuceneXaResource(Object identifier, XaResourceManager xaRm, byte[] branchId) {
            super(xaRm, branchId);
            this.identifier = identifier;
        }

        public boolean isSameRM(XAResource xares) {
            if (xares instanceof LuceneXaResource) {
                return this.identifier.equals(((LuceneXaResource)((Object)xares)).identifier);
            }
            return false;
        }
    }
}

