/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.util.IO;
import org.mortbay.jetty.plugin.PluginLog;
import org.mortbay.jetty.runner.Runner;

public class JettyRunForkedMojo
extends AbstractMojo {
    private MavenProject project;
    private String jettyXml;
    private String contextPath;
    private File webApp;
    private String webAppXml;
    protected RequestLog requestLog;
    private boolean skip;
    protected int stopPort;
    protected String stopKey;
    private List pluginArtifacts;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Configuring Jetty for project: " + this.project.getName()));
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Jetty start: jetty.skip==true");
            return;
        }
        PluginLog.setLog(this.getLog());
        this.checkPomConfiguration();
        this.startJettyRunner();
    }

    public void startJettyRunner() throws MojoExecutionException {
        Process process = null;
        try {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this.getJavaBin());
            String classPath = this.getClassPath();
            if (classPath != null && classPath.length() > 0) {
                cmd.add("-cp");
                cmd.add(classPath);
            }
            cmd.add(Runner.class.getCanonicalName());
            if (this.stopPort > 0 && this.stopKey != null) {
                cmd.add("--stop-port");
                cmd.add(Integer.toString(this.stopPort));
                cmd.add("--stop-key");
                cmd.add(this.stopKey);
            }
            if (this.jettyXml != null) {
                cmd.add("--config");
                cmd.add(this.jettyXml);
            }
            if (this.requestLog != null) {
                cmd.add("--log");
                cmd.add(this.requestLog.toString());
            }
            if (this.webAppXml != null) {
                cmd.add(this.webAppXml);
            } else {
                if (this.contextPath != null) {
                    cmd.add("--path");
                    cmd.add(this.contextPath);
                }
                cmd.add(this.webApp.getCanonicalPath());
            }
            ProcessBuilder builder = new ProcessBuilder(cmd);
            builder.directory(this.project.getBasedir());
            process = builder.start();
            ConsoleParser parser = new ConsoleParser();
            List<String[]> connList = parser.newPattern("Started [A-Za-z]*Connector@([0-9]*\\.[0-9]*\\.[0-9]*\\.[0-9]*):([0-9]*)", 1);
            this.startPump("STDOUT", parser, process.getInputStream());
            this.startPump("STDERR", parser, process.getErrorStream());
            parser.waitForDone(60L, TimeUnit.SECONDS);
            if (connList.isEmpty()) {
                throw new InterruptedException();
            }
        }
        catch (InterruptedException ex) {
            if (process != null) {
                process.destroy();
            }
            throw new MojoExecutionException("Failed to start Jetty within time limit");
        }
        catch (Exception ex) {
            if (process != null) {
                process.destroy();
            }
            throw new MojoExecutionException("Failed to create Jetty process", ex);
        }
    }

    public void checkPomConfiguration() throws MojoExecutionException {
    }

    public String getClassPath() throws IOException {
        StringBuilder classPath = new StringBuilder();
        for (Object obj : this.pluginArtifacts) {
            Artifact artifact = (Artifact)obj;
            if (!"jar".equals(artifact.getType())) continue;
            if (classPath.length() > 0) {
                classPath.append(':');
            }
            classPath.append(artifact.getFile().getCanonicalPath());
        }
        return JettyRunForkedMojo.pathSeparators(classPath.toString());
    }

    private String getJavaBin() {
        String[] javaexes = new String[]{"java", "java.exe"};
        File javaHomeDir = new File(System.getProperty("java.home"));
        for (String javaexe : javaexes) {
            File javabin = new File(javaHomeDir, JettyRunForkedMojo.fileSeparators("bin/" + javaexe));
            if (!javabin.exists() || !javabin.isFile()) continue;
            return javabin.getAbsolutePath();
        }
        return "java";
    }

    public static String fileSeparators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == '/' || c == '\\') {
                ret.append(File.separatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String pathSeparators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == ',' || c == ':') {
                ret.append(File.pathSeparatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    private void startPump(String mode, ConsoleParser parser, InputStream inputStream) {
        ConsoleStreamer pump = new ConsoleStreamer(mode, inputStream);
        pump.setParser(parser);
        Thread thread = new Thread((Runnable)pump, "ConsoleStreamer/" + mode);
        thread.start();
    }

    private static class ConsoleStreamer
    implements Runnable {
        private String mode;
        private BufferedReader reader;
        private ConsoleParser parser;

        public ConsoleStreamer(String mode, InputStream is) {
            this.mode = mode;
            this.reader = new BufferedReader(new InputStreamReader(is));
        }

        public void setParser(ConsoleParser connector) {
            this.parser = connector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    if (this.parser != null) {
                        this.parser.parse(line);
                    }
                    System.out.println("[" + this.mode + "] " + line);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                IO.close((Reader)this.reader);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConsolePattern {
        private Pattern pattern;
        private List<String[]> matches;
        private int count;

        ConsolePattern(String exp, int cnt) {
            this.pattern = Pattern.compile(exp);
            this.matches = new ArrayList<String[]>();
            this.count = cnt;
        }

        public Matcher getMatcher(String line) {
            return this.pattern.matcher(line);
        }

        public List<String[]> getMatches() {
            return this.matches;
        }

        public int getCount() {
            return this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConsoleParser {
        private List<ConsolePattern> patterns = new ArrayList<ConsolePattern>();
        private CountDownLatch latch;
        private int count;

        private ConsoleParser() {
        }

        public List<String[]> newPattern(String exp, int cnt) {
            ConsolePattern pat = new ConsolePattern(exp, cnt);
            this.patterns.add(pat);
            this.count += cnt;
            return pat.getMatches();
        }

        public void parse(String line) {
            for (ConsolePattern pat : this.patterns) {
                Matcher mat = pat.getMatcher(line);
                if (!mat.find()) continue;
                int num = 0;
                int count = mat.groupCount();
                String[] match = new String[count];
                while (num++ < count) {
                    match[num - 1] = mat.group(num);
                }
                pat.getMatches().add(match);
                if (pat.getCount() <= 0) continue;
                this.getLatch().countDown();
            }
        }

        public void waitForDone(long timeout, TimeUnit unit) throws InterruptedException {
            this.getLatch().await(timeout, unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CountDownLatch getLatch() {
            ConsoleParser consoleParser = this;
            synchronized (consoleParser) {
                if (this.latch == null) {
                    this.latch = new CountDownLatch(this.count);
                }
            }
            return this.latch;
        }
    }
}

