/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.mortbay.jetty.plugin.ConsoleScanner;
import org.mortbay.jetty.plugin.JettyServer;
import org.mortbay.jetty.plugin.JettyWebAppContext;
import org.mortbay.jetty.plugin.Monitor;
import org.mortbay.jetty.plugin.PluginLog;
import org.mortbay.jetty.plugin.SystemProperties;
import org.mortbay.jetty.plugin.SystemProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJettyMojo
extends AbstractMojo {
    protected JettyServer server;
    protected Connector[] connectors;
    protected ContextHandler[] contextHandlers;
    protected LoginService[] loginServices;
    protected RequestLog requestLog;
    protected JettyWebAppContext webAppConfig;
    protected MavenProject project;
    protected String contextPath;
    protected File tmpDirectory;
    protected int scanIntervalSeconds;
    protected String reload;
    protected File systemPropertiesFile;
    protected SystemProperties systemProperties;
    protected String jettyConfig;
    protected int stopPort;
    protected String stopKey;
    protected boolean daemon;
    protected boolean skip;
    protected String webAppXml;
    protected Scanner scanner;
    protected ArrayList<File> scanList;
    protected ArrayList<Scanner.BulkListener> scannerListeners;
    protected Thread consoleScanner;
    public String PORT_SYSPROPERTY = "jetty.port";

    public abstract void restartWebApp(boolean var1) throws Exception;

    public abstract void checkPomConfiguration() throws MojoExecutionException;

    public abstract void configureScanner() throws MojoExecutionException;

    public abstract void applyJettyXml() throws Exception;

    public abstract void finishConfigurationBeforeStart() throws Exception;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Configuring Jetty for project: " + this.getProject().getName()));
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Jetty start: jetty.skip==true");
            return;
        }
        PluginLog.setLog(this.getLog());
        this.checkPomConfiguration();
        this.startJetty();
    }

    public void startJetty() throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)"Starting Jetty Server ...");
            this.printSystemProperties();
            this.server = new JettyServer();
            this.setServer(this.server);
            this.applyJettyXml();
            Connector[] connectors = this.server.getConnectors();
            if (connectors == null || connectors.length == 0) {
                this.server.setConnectors(this.connectors);
                connectors = this.server.getConnectors();
                if (connectors == null || connectors.length == 0) {
                    this.connectors = new Connector[]{this.server.createDefaultConnector(System.getProperty(this.PORT_SYSPROPERTY, null))};
                    this.server.setConnectors(this.connectors);
                }
            }
            if (this.requestLog != null) {
                this.getServer().setRequestLog(this.requestLog);
            }
            this.server.configureHandlers();
            this.configureWebApplication();
            this.server.addWebApplication(this.webAppConfig);
            for (int i = 0; this.loginServices != null && i < this.loginServices.length; ++i) {
                this.getLog().debug((CharSequence)(this.loginServices[i].getClass().getName() + ": " + this.loginServices[i].toString()));
                this.getServer().addBean(this.loginServices[i]);
            }
            this.finishConfigurationBeforeStart();
            this.server.start();
            this.getLog().info((CharSequence)"Started Jetty Server");
            if (this.stopPort > 0 && this.stopKey != null) {
                Monitor monitor = new Monitor(this.stopPort, this.stopKey, new Server[]{this.server}, !this.daemon);
                monitor.start();
            }
            this.configureScanner();
            this.startScanner();
            this.startConsoleScanner();
            if (!this.daemon) {
                this.server.join();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure", e);
        }
        finally {
            if (!this.daemon) {
                this.getLog().info((CharSequence)"Jetty server exiting.");
            }
        }
    }

    public void configureWebApplication() throws Exception {
        String cp;
        if (this.webAppConfig == null) {
            this.webAppConfig = new JettyWebAppContext();
        }
        if (this.webAppXml != null) {
            File file = FileUtils.getFile((String)this.webAppXml);
            XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.toURL((File)file));
            this.getLog().info((CharSequence)("Applying context xml file " + this.webAppXml));
            xmlConfiguration.configure((Object)this.webAppConfig);
        }
        if ((cp = this.webAppConfig.getContextPath()) == null || "".equals(cp)) {
            this.webAppConfig.setContextPath(this.contextPath.startsWith("/") ? this.contextPath : "/" + this.contextPath);
        }
        if (this.webAppConfig.getTempDirectory() == null && this.tmpDirectory != null) {
            if (!this.tmpDirectory.exists()) {
                this.tmpDirectory.mkdirs();
            }
            this.webAppConfig.setTempDirectory(this.tmpDirectory);
        }
        this.getLog().info((CharSequence)("Context path = " + this.webAppConfig.getContextPath()));
        this.getLog().info((CharSequence)("Tmp directory = " + (this.webAppConfig.getTempDirectory() == null ? " determined at runtime" : this.webAppConfig.getTempDirectory())));
        this.getLog().info((CharSequence)("Web defaults = " + (this.webAppConfig.getDefaultsDescriptor() == null ? " jetty default" : this.webAppConfig.getDefaultsDescriptor())));
        this.getLog().info((CharSequence)("Web overrides = " + (this.webAppConfig.getOverrideDescriptor() == null ? " none" : this.webAppConfig.getOverrideDescriptor())));
    }

    private void startScanner() throws Exception {
        Iterator itor;
        if (this.getScanIntervalSeconds() <= 0) {
            return;
        }
        if ("manual".equalsIgnoreCase(this.reload)) {
            this.getLog().warn((CharSequence)("scanIntervalSeconds is set to " + this.scanIntervalSeconds + " but will be IGNORED due to manual reloading"));
            return;
        }
        this.scanner = new Scanner();
        this.scanner.setReportExistingFilesOnStartup(false);
        this.scanner.setScanInterval(this.getScanIntervalSeconds());
        this.scanner.setScanDirs(this.getScanList());
        this.scanner.setRecursive(true);
        ArrayList listeners = this.getScannerListeners();
        Iterator iterator = itor = listeners == null ? null : listeners.iterator();
        while (itor != null && itor.hasNext()) {
            this.scanner.addListener((Scanner.Listener)itor.next());
        }
        this.getLog().info((CharSequence)("Starting scanner at interval of " + this.getScanIntervalSeconds() + " seconds."));
        this.scanner.start();
    }

    protected void startConsoleScanner() throws Exception {
        if ("manual".equalsIgnoreCase(this.reload)) {
            this.getLog().info((CharSequence)"Console reloading is ENABLED. Hit ENTER on the console to restart the context.");
            this.consoleScanner = new ConsoleScanner(this);
            this.consoleScanner.start();
        }
    }

    private void printSystemProperties() {
        if (this.getLog().isDebugEnabled() && this.systemProperties != null) {
            for (SystemProperty prop : this.systemProperties.getSystemProperties()) {
                this.getLog().debug((CharSequence)("Property " + prop.getName() + "=" + prop.getValue() + " was " + (prop.isSet() ? "set" : "skipped")));
            }
        }
    }

    public File findJettyWebXmlFile(File webInfDir) {
        if (webInfDir == null) {
            return null;
        }
        if (!webInfDir.exists()) {
            return null;
        }
        File f = new File(webInfDir, "jetty-web.xml");
        if (f.exists()) {
            return f;
        }
        f = new File(webInfDir, "web-jetty.xml");
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public File getTmpDirectory() {
        return this.tmpDirectory;
    }

    public void setTmpDirectory(File tmpDirectory) {
        this.tmpDirectory = tmpDirectory;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public int getScanIntervalSeconds() {
        return this.scanIntervalSeconds;
    }

    public void setScanIntervalSeconds(int scanIntervalSeconds) {
        this.scanIntervalSeconds = scanIntervalSeconds;
    }

    public File getSystemPropertiesFile() {
        return this.systemPropertiesFile;
    }

    public void setSystemPropertiesFile(File file) throws Exception {
        this.systemPropertiesFile = file;
        FileInputStream propFile = new FileInputStream(this.systemPropertiesFile);
        Properties properties = new Properties();
        properties.load(propFile);
        if (this.systemProperties == null) {
            this.systemProperties = new SystemProperties();
        }
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (this.systemProperties.containsSystemProperty(key)) continue;
            SystemProperty prop = new SystemProperty();
            prop.setKey(key);
            prop.setValue(properties.getProperty(key));
            this.systemProperties.setSystemProperty(prop);
        }
    }

    public void setSystemProperties(SystemProperties systemProperties) {
        if (this.systemProperties == null) {
            this.systemProperties = systemProperties;
        } else {
            for (SystemProperty prop : systemProperties.getSystemProperties()) {
                this.systemProperties.setSystemProperty(prop);
            }
        }
    }

    public SystemProperties getSystemProperties() {
        return this.systemProperties;
    }

    public List<File> getJettyXmlFiles() {
        if (this.jettyConfig == null) {
            return null;
        }
        ArrayList<File> jettyXmlFiles = new ArrayList<File>();
        if (this.jettyConfig.indexOf(44) == -1) {
            jettyXmlFiles.add(new File(this.jettyConfig));
        } else {
            String[] files;
            for (String file : files = this.jettyConfig.split(",")) {
                jettyXmlFiles.add(new File(file));
            }
        }
        return jettyXmlFiles;
    }

    public JettyServer getServer() {
        return this.server;
    }

    public void setServer(JettyServer server) {
        this.server = server;
    }

    public void setScanList(ArrayList<File> list) {
        this.scanList = new ArrayList<File>(list);
    }

    public ArrayList<File> getScanList() {
        return this.scanList;
    }

    public void setScannerListeners(ArrayList<Scanner.BulkListener> listeners) {
        this.scannerListeners = new ArrayList<Scanner.BulkListener>(listeners);
    }

    public ArrayList getScannerListeners() {
        return this.scannerListeners;
    }

    public JettyWebAppContext getWebAppConfig() {
        return this.webAppConfig;
    }

    public void setWebAppConfig(JettyWebAppContext webAppConfig) {
        this.webAppConfig = webAppConfig;
    }

    public RequestLog getRequestLog() {
        return this.requestLog;
    }

    public void setRequestLog(RequestLog requestLog) {
        this.requestLog = requestLog;
    }

    public LoginService[] getLoginServices() {
        return this.loginServices;
    }

    public void setLoginServices(LoginService[] loginServices) {
        this.loginServices = loginServices;
    }

    public ContextHandler[] getContextHandlers() {
        return this.contextHandlers;
    }

    public void setContextHandlers(ContextHandler[] contextHandlers) {
        this.contextHandlers = contextHandlers;
    }

    public Connector[] getConnectors() {
        return this.connectors;
    }

    public void setConnectors(Connector[] connectors) {
        this.connectors = connectors;
    }

    public String getReload() {
        return this.reload;
    }

    public void setReload(String reload) {
        this.reload = reload;
    }

    public String getJettyConfig() {
        return this.jettyConfig;
    }

    public void setJettyConfig(String jettyConfig) {
        this.jettyConfig = jettyConfig;
    }

    public String getWebAppXml() {
        return this.webAppXml;
    }

    public void setWebAppXml(String webAppXml) {
        this.webAppXml = webAppXml;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public String getStopKey() {
        return this.stopKey;
    }

    public void setStopKey(String stopKey) {
        this.stopKey = stopKey;
    }

    public int getStopPort() {
        return this.stopPort;
    }

    public void setStopPort(int stopPort) {
        this.stopPort = stopPort;
    }
}

