/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.log;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventListenerProviderFactory;
import org.keycloak.events.log.JBossLoggingEventListenerProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class JBossLoggingEventListenerProviderFactory
implements EventListenerProviderFactory {
    public static final String ID = "jboss-logging";
    private static final Logger logger = Logger.getLogger((String)"org.keycloak.events");
    private Logger.Level successLevel;
    private Logger.Level errorLevel;
    private boolean sanitize;
    private Character quotes;

    public EventListenerProvider create(KeycloakSession session) {
        return new JBossLoggingEventListenerProvider(session, logger, this.successLevel, this.errorLevel, this.quotes, this.sanitize);
    }

    public void init(Config.Scope config) {
        this.successLevel = Logger.Level.valueOf((String)config.get("success-level", "debug").toUpperCase());
        this.errorLevel = Logger.Level.valueOf((String)config.get("error-level", "warn").toUpperCase());
        this.sanitize = config.getBoolean("sanitize", Boolean.valueOf(true));
        String quotesString = config.get("quotes", "\"");
        if (!quotesString.equals("none") && quotesString.length() > 1) {
            logger.warn((Object)"Invalid quotes configuration, it should be none or one character to use as quotes. Using default \" quotes");
            quotesString = "\"";
        }
        this.quotes = quotesString.equals("none") ? null : Character.valueOf(quotesString.charAt(0));
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        String[] logLevels = (String[])Arrays.stream(Logger.Level.values()).map(Enum::name).map(String::toLowerCase).sorted(Comparator.naturalOrder()).toArray(String[]::new);
        return ProviderConfigurationBuilder.create().property().name("success-level").type("string").helpText("The log level for success messages.").options(logLevels).defaultValue((Object)"debug").add().property().name("error-level").type("string").helpText("The log level for error messages.").options(logLevels).defaultValue((Object)"warn").add().property().name("sanitize").type("boolean").helpText("If true the log messages are sanitized to avoid line breaks. If false messages are not sanitized.").defaultValue((Object)"true").add().property().name("quotes").type("string").helpText("The quotes to use for values, it should be one character like \" or '. Use \"none\" if quotes are not needed.").defaultValue((Object)"\"").add().build();
    }
}

