/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Set;
import org.keycloak.Config;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.common.util.SystemEnvProperties;

public class JsonConfigProvider
implements Config.ConfigProvider {
    private JsonNode config;

    public JsonConfigProvider(JsonNode config) {
        this.config = config;
    }

    public String getProvider(String spi) {
        JsonNode n = JsonConfigProvider.getNode(this.config, spi, "provider");
        return n != null ? this.replaceProperties(n.textValue()) : null;
    }

    public String getDefaultProvider(String spi) {
        JsonNode n = JsonConfigProvider.getNode(this.config, spi, "provider-default");
        return n != null ? this.replaceProperties(n.textValue()) : null;
    }

    public Config.Scope scope(String ... path) {
        return new JsonScope(JsonConfigProvider.getNode(this.config, path));
    }

    private static JsonNode getNode(JsonNode root, String ... path) {
        if (root == null) {
            return null;
        }
        JsonNode n = root;
        for (String p : path) {
            if ((n = n.get(p)) != null) continue;
            return null;
        }
        return n;
    }

    private String replaceProperties(String value) {
        return StringPropertyReplacer.replaceProperties((String)value, arg_0 -> ((SystemEnvProperties)SystemEnvProperties.UNFILTERED).getProperty(arg_0));
    }

    public class JsonScope
    implements Config.Scope {
        private JsonNode config;

        public JsonScope(JsonNode config) {
            this.config = config;
        }

        public String get(String key) {
            return this.get(key, null);
        }

        public String get(String key, String defaultValue) {
            if (this.config == null) {
                return defaultValue;
            }
            JsonNode n = this.config.get(key);
            if (n == null) {
                return defaultValue;
            }
            String v = JsonConfigProvider.this.replaceProperties(n.textValue());
            return !v.isEmpty() ? v : defaultValue;
        }

        public String[] getArray(String key) {
            if (this.config == null) {
                return null;
            }
            JsonNode n = this.config.get(key);
            if (n == null) {
                return null;
            }
            if (n.isArray()) {
                String[] a = new String[n.size()];
                for (int i = 0; i < a.length; ++i) {
                    a[i] = JsonConfigProvider.this.replaceProperties(n.get(i).textValue());
                }
                return a;
            }
            return new String[]{JsonConfigProvider.this.replaceProperties(n.textValue())};
        }

        public Integer getInt(String key) {
            return this.getInt(key, null);
        }

        public Integer getInt(String key, Integer defaultValue) {
            if (this.config == null) {
                return defaultValue;
            }
            JsonNode n = this.config.get(key);
            if (n == null) {
                return defaultValue;
            }
            if (n.isTextual()) {
                String v = JsonConfigProvider.this.replaceProperties(n.textValue());
                return !v.isEmpty() ? Integer.valueOf(v) : defaultValue;
            }
            return n.intValue();
        }

        public Long getLong(String key) {
            return this.getLong(key, null);
        }

        public Long getLong(String key, Long defaultValue) {
            if (this.config == null) {
                return defaultValue;
            }
            JsonNode n = this.config.get(key);
            if (n == null) {
                return defaultValue;
            }
            if (n.isTextual()) {
                String v = JsonConfigProvider.this.replaceProperties(n.textValue());
                return !v.isEmpty() ? Long.valueOf(v) : defaultValue;
            }
            return n.longValue();
        }

        public Boolean getBoolean(String key) {
            return this.getBoolean(key, null);
        }

        public Boolean getBoolean(String key, Boolean defaultValue) {
            if (this.config == null) {
                return defaultValue;
            }
            JsonNode n = this.config.get(key);
            if (n == null) {
                return defaultValue;
            }
            if (n.isTextual()) {
                String v = JsonConfigProvider.this.replaceProperties(n.textValue());
                return !v.isEmpty() ? Boolean.valueOf(v) : defaultValue;
            }
            return n.booleanValue();
        }

        public Config.Scope scope(String ... path) {
            return new JsonScope(JsonConfigProvider.getNode(this.config, path));
        }

        public Set<String> getPropertyNames() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

