/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.keycloak.services.util.LocaleUtil;

public class LocaleUtilTest {
    private static final Locale LOCALE_DE_CH = Locale.forLanguageTag("de-CH");
    private static final Locale LOCALE_DE_CH_1996 = Locale.forLanguageTag("de-CH-1996");

    @Test
    public void getParentLocale() {
        MatcherAssert.assertThat((Object)LocaleUtil.getParentLocale((Locale)LOCALE_DE_CH_1996), (Matcher)CoreMatchers.equalTo((Object)LOCALE_DE_CH));
        MatcherAssert.assertThat((Object)LocaleUtil.getParentLocale((Locale)LOCALE_DE_CH), (Matcher)CoreMatchers.equalTo((Object)Locale.GERMAN));
        MatcherAssert.assertThat((Object)LocaleUtil.getParentLocale((Locale)Locale.GERMAN), (Matcher)CoreMatchers.equalTo((Object)Locale.ENGLISH));
        MatcherAssert.assertThat((Object)LocaleUtil.getParentLocale((Locale)Locale.ENGLISH), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void getApplicableLocales() {
        MatcherAssert.assertThat((Object)LocaleUtil.getApplicableLocales((Locale)LOCALE_DE_CH_1996), (Matcher)CoreMatchers.equalTo(Arrays.asList(LOCALE_DE_CH_1996, LOCALE_DE_CH, Locale.GERMAN, Locale.ENGLISH)));
        MatcherAssert.assertThat((Object)LocaleUtil.getApplicableLocales((Locale)LOCALE_DE_CH), (Matcher)CoreMatchers.equalTo(Arrays.asList(LOCALE_DE_CH, Locale.GERMAN, Locale.ENGLISH)));
        MatcherAssert.assertThat((Object)LocaleUtil.getApplicableLocales((Locale)Locale.GERMAN), (Matcher)CoreMatchers.equalTo(Arrays.asList(Locale.GERMAN, Locale.ENGLISH)));
        MatcherAssert.assertThat((Object)LocaleUtil.getApplicableLocales((Locale)Locale.ENGLISH), (Matcher)CoreMatchers.equalTo(Collections.singletonList(Locale.ENGLISH)));
    }

    @Test
    public void mergeGroupedMessages() {
        HashMap<Locale, Properties> groupedMessages = new HashMap<Locale, Properties>();
        String keyDefinedEverywhere = "everywhere";
        String keyDefinedForRegionAndParents = "region-and-parents";
        String keyDefinedForLanguageAndParents = "language-and-parents";
        String keyDefinedForEnglishOnly = "english-only";
        Properties irrelevantMessages = new Properties();
        LocaleUtilTest.addTestValue(irrelevantMessages, "french-only", Locale.FRENCH);
        groupedMessages.put(Locale.FRENCH, irrelevantMessages);
        Properties variantMessages = new Properties();
        LocaleUtilTest.addTestValue(variantMessages, keyDefinedEverywhere, LOCALE_DE_CH_1996);
        groupedMessages.put(LOCALE_DE_CH_1996, variantMessages);
        Properties regionMessages = new Properties();
        LocaleUtilTest.addTestValues(regionMessages, Arrays.asList(keyDefinedEverywhere, keyDefinedForRegionAndParents), LOCALE_DE_CH);
        groupedMessages.put(LOCALE_DE_CH, regionMessages);
        Properties languageMessages = new Properties();
        LocaleUtilTest.addTestValues(languageMessages, Arrays.asList(keyDefinedEverywhere, keyDefinedForRegionAndParents, keyDefinedForLanguageAndParents), Locale.GERMAN);
        groupedMessages.put(Locale.GERMAN, languageMessages);
        Properties englishMessages = new Properties();
        LocaleUtilTest.addTestValues(englishMessages, Arrays.asList(keyDefinedEverywhere, keyDefinedForRegionAndParents, keyDefinedForLanguageAndParents, keyDefinedForEnglishOnly), Locale.ENGLISH);
        groupedMessages.put(Locale.ENGLISH, englishMessages);
        Properties mergedMessages = LocaleUtil.mergeGroupedMessages((Locale)LOCALE_DE_CH_1996, groupedMessages);
        Properties expectedMergedMessages = new Properties();
        LocaleUtilTest.addTestValue(expectedMergedMessages, keyDefinedEverywhere, LOCALE_DE_CH_1996);
        LocaleUtilTest.addTestValue(expectedMergedMessages, keyDefinedForRegionAndParents, LOCALE_DE_CH);
        LocaleUtilTest.addTestValue(expectedMergedMessages, keyDefinedForLanguageAndParents, Locale.GERMAN);
        LocaleUtilTest.addTestValue(expectedMergedMessages, keyDefinedForEnglishOnly, Locale.ENGLISH);
        MatcherAssert.assertThat((Object)mergedMessages, (Matcher)CoreMatchers.equalTo((Object)expectedMergedMessages));
    }

    @Test
    public void mergeGroupedMessagesFromTwoSources() {
        HashMap<Locale, Properties> groupedMessages1 = new HashMap<Locale, Properties>();
        HashMap<Locale, Properties> groupedMessages2 = new HashMap<Locale, Properties>();
        String messages1Prefix = "msg1";
        String messages2Prefix = "msg2";
        String keyDefinedForVariantFromMessages1AndFallbacks = "variant1-and-fallbacks";
        String keyDefinedForVariantFromMessages2AndFallbacks = "variant2-and-fallbacks";
        String keyDefinedForRegionFromMessages1AndFallbacks = "region1-and-fallbacks";
        String keyDefinedForRegionFromMessages2AndFallbacks = "region2-and-fallbacks";
        String keyDefinedForLanguageFromMessages1AndFallbacks = "language1-and-fallbacks";
        String keyDefinedForLanguageFromMessages2AndFallbacks = "language2-and-fallbacks";
        String keyDefinedForEnglishFromMessages1AndFallback = "english1-and-fallback";
        String keyDefinedForEnglishFromMessages2only = "english2-only";
        Properties irrelevantMessages = new Properties();
        LocaleUtilTest.addTestValue(irrelevantMessages, "french-only", Locale.FRENCH);
        groupedMessages1.put(Locale.FRENCH, irrelevantMessages);
        groupedMessages2.put(Locale.FRENCH, irrelevantMessages);
        Properties variant1Messages = new Properties();
        LocaleUtilTest.addTestValue(variant1Messages, keyDefinedForVariantFromMessages1AndFallbacks, LOCALE_DE_CH_1996, messages1Prefix);
        groupedMessages1.put(LOCALE_DE_CH_1996, variant1Messages);
        Properties variant2Messages = new Properties();
        LocaleUtilTest.addTestValues(variant2Messages, Arrays.asList(keyDefinedForVariantFromMessages1AndFallbacks, keyDefinedForVariantFromMessages2AndFallbacks), LOCALE_DE_CH_1996, messages2Prefix);
        groupedMessages2.put(LOCALE_DE_CH_1996, variant2Messages);
        Properties region1Messages = new Properties();
        LocaleUtilTest.addTestValues(region1Messages, Arrays.asList(keyDefinedForVariantFromMessages1AndFallbacks, keyDefinedForVariantFromMessages2AndFallbacks, keyDefinedForRegionFromMessages1AndFallbacks), LOCALE_DE_CH, messages1Prefix);
        groupedMessages1.put(LOCALE_DE_CH, region1Messages);
        Properties region2Messages = new Properties();
        LocaleUtilTest.addTestValues(region2Messages, Arrays.asList(keyDefinedForVariantFromMessages1AndFallbacks, keyDefinedForVariantFromMessages2AndFallbacks, keyDefinedForRegionFromMessages1AndFallbacks, keyDefinedForRegionFromMessages2AndFallbacks), LOCALE_DE_CH, messages2Prefix);
        groupedMessages2.put(LOCALE_DE_CH, region2Messages);
        Properties language1Messages = new Properties();
        LocaleUtilTest.addTestValues(language1Messages, Arrays.asList(keyDefinedForVariantFromMessages1AndFallbacks, keyDefinedForVariantFromMessages2AndFallbacks, keyDefinedForRegionFromMessages1AndFallbacks, keyDefinedForRegionFromMessages2AndFallbacks, keyDefinedForLanguageFromMessages1AndFallbacks), Locale.GERMAN, messages1Prefix);
        groupedMessages1.put(Locale.GERMAN, language1Messages);
        Properties language2Messages = new Properties();
        LocaleUtilTest.addTestValues(language2Messages, Arrays.asList(keyDefinedForVariantFromMessages1AndFallbacks, keyDefinedForVariantFromMessages2AndFallbacks, keyDefinedForRegionFromMessages1AndFallbacks, keyDefinedForRegionFromMessages2AndFallbacks, keyDefinedForLanguageFromMessages1AndFallbacks, keyDefinedForLanguageFromMessages2AndFallbacks), Locale.GERMAN, messages2Prefix);
        groupedMessages2.put(Locale.GERMAN, language2Messages);
        Properties english1Messages = new Properties();
        LocaleUtilTest.addTestValues(english1Messages, Arrays.asList(keyDefinedForVariantFromMessages1AndFallbacks, keyDefinedForVariantFromMessages2AndFallbacks, keyDefinedForRegionFromMessages1AndFallbacks, keyDefinedForRegionFromMessages2AndFallbacks, keyDefinedForLanguageFromMessages1AndFallbacks, keyDefinedForLanguageFromMessages2AndFallbacks, keyDefinedForEnglishFromMessages1AndFallback), Locale.ENGLISH, messages1Prefix);
        groupedMessages1.put(Locale.ENGLISH, english1Messages);
        Properties english2Messages = new Properties();
        LocaleUtilTest.addTestValues(english2Messages, Arrays.asList(keyDefinedForVariantFromMessages1AndFallbacks, keyDefinedForVariantFromMessages2AndFallbacks, keyDefinedForRegionFromMessages1AndFallbacks, keyDefinedForRegionFromMessages2AndFallbacks, keyDefinedForLanguageFromMessages1AndFallbacks, keyDefinedForLanguageFromMessages2AndFallbacks, keyDefinedForEnglishFromMessages1AndFallback, keyDefinedForEnglishFromMessages2only), Locale.ENGLISH, messages2Prefix);
        groupedMessages2.put(Locale.ENGLISH, english2Messages);
        Properties mergedMessages = LocaleUtil.mergeGroupedMessages((Locale)LOCALE_DE_CH_1996, groupedMessages1, groupedMessages2);
        Properties expectedMergedMessages = new Properties();
        LocaleUtilTest.addTestValue(expectedMergedMessages, keyDefinedForVariantFromMessages1AndFallbacks, LOCALE_DE_CH_1996, messages1Prefix);
        LocaleUtilTest.addTestValue(expectedMergedMessages, keyDefinedForVariantFromMessages2AndFallbacks, LOCALE_DE_CH_1996, messages2Prefix);
        LocaleUtilTest.addTestValue(expectedMergedMessages, keyDefinedForRegionFromMessages1AndFallbacks, LOCALE_DE_CH, messages1Prefix);
        LocaleUtilTest.addTestValue(expectedMergedMessages, keyDefinedForRegionFromMessages2AndFallbacks, LOCALE_DE_CH, messages2Prefix);
        LocaleUtilTest.addTestValue(expectedMergedMessages, keyDefinedForLanguageFromMessages1AndFallbacks, Locale.GERMAN, messages1Prefix);
        LocaleUtilTest.addTestValue(expectedMergedMessages, keyDefinedForLanguageFromMessages2AndFallbacks, Locale.GERMAN, messages2Prefix);
        LocaleUtilTest.addTestValue(expectedMergedMessages, keyDefinedForEnglishFromMessages1AndFallback, Locale.ENGLISH, messages1Prefix);
        LocaleUtilTest.addTestValue(expectedMergedMessages, keyDefinedForEnglishFromMessages2only, Locale.ENGLISH, messages2Prefix);
        MatcherAssert.assertThat((Object)mergedMessages, (Matcher)CoreMatchers.equalTo((Object)expectedMergedMessages));
    }

    private static void addTestValues(Properties messages, List<String> keys, Locale locale) {
        keys.forEach(k -> LocaleUtilTest.addTestValue(messages, k, locale));
    }

    private static void addTestValue(Properties messages, String key, Locale locale) {
        messages.put(key, LocaleUtilTest.createTestValue(key, locale, null));
    }

    private static void addTestValues(Properties messages, List<String> keys, Locale locale, String prefix) {
        keys.forEach(k -> LocaleUtilTest.addTestValue(messages, k, locale, prefix));
    }

    private static void addTestValue(Properties messages, String key, Locale locale, String prefix) {
        messages.put(key, LocaleUtilTest.createTestValue(key, locale, prefix));
    }

    private static String createTestValue(String key, Locale locale, String prefix) {
        return (String)(prefix != null ? prefix + ":" : "") + locale.toLanguageTag() + ":" + key;
    }
}

