/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.securityprofile;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.crypto.CryptoProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.securityprofile.SecurityProfileProvider;
import org.keycloak.services.resteasy.ResteasyKeycloakSession;
import org.keycloak.services.resteasy.ResteasyKeycloakSessionFactory;
import org.keycloak.services.securityprofile.DefaultSecurityProfileProviderFactory;
import org.keycloak.utils.ScopeUtil;

@RunWith(value=Parameterized.class)
public class DefaultSecurityProfileProverFactoryTest {
    private static KeycloakSession session;
    private final String name;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"none-security-profile"}, {"lax-security-profile"}, {"strict-security-profile"});
    }

    public DefaultSecurityProfileProverFactoryTest(String name) {
        this.name = name;
    }

    @BeforeClass
    public static void beforeClass() {
        Profile.defaults();
        CryptoIntegration.init((ClassLoader)CryptoProvider.class.getClassLoader());
        ResteasyKeycloakSessionFactory sessionFactory = new ResteasyKeycloakSessionFactory();
        sessionFactory.init();
        session = new ResteasyKeycloakSession(sessionFactory);
    }

    @Test
    public void testConfigurationFile() {
        DefaultSecurityProfileProviderFactory fact = new DefaultSecurityProfileProviderFactory();
        fact.init((Config.Scope)ScopeUtil.createScope(Collections.singletonMap("name", this.name)));
        SecurityProfileProvider prov = (SecurityProfileProvider)fact.create(session);
        Assert.assertNotNull((Object)prov.getName());
        Assert.assertNotNull((Object)prov.getDefaultClientProfiles());
        Assert.assertNotNull((Object)prov.getDefaultClientPolicies());
    }
}

