/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.keycloak.dom.saml.v2.protocol.ArtifactResponseType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.saml.SAML2LoginResponseBuilder;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.processing.core.saml.v2.common.IDGenerator;
import org.keycloak.saml.processing.core.saml.v2.writers.SAMLResponseWriter;
import org.w3c.dom.Document;

public class SamlProtocolUtilsTest {
    @Test
    public void testBuildArtifactResponse() throws ConfigurationException, ProcessingException, ParsingException {
        ResponseType response = new SAML2LoginResponseBuilder().requestID(IDGenerator.create((String)"ID_")).destination("http://localhost:8180/auth/realms/demo/broker/saml-broker/endpoint").issuer("http://saml.idp/saml").assertionExpiration(1000000).subjectExpiration(1000000).requestIssuer("http://localhost:8180/auth/realms/demo").nameIdentifier(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get(), "a@b.c").authMethod(JBossSAMLURIConstants.AC_UNSPECIFIED.get()).sessionIndex("idp:" + String.valueOf(UUID.randomUUID())).buildModel();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SAMLResponseWriter writer = new SAMLResponseWriter(StaxUtil.getXMLStreamWriter((OutputStream)bos));
        writer.write(response);
        Document responseDoc = DocumentUtil.getDocument((InputStream)new ByteArrayInputStream(bos.toByteArray()));
        ArtifactResponseType artifactResponseType = SamlProtocolUtils.buildArtifactResponse((Document)responseDoc);
        Document doc = SamlProtocolUtils.convert((ArtifactResponseType)artifactResponseType);
        String artifactResponse = DocumentUtil.asString((Document)doc);
        MatcherAssert.assertThat((Object)artifactResponse, (Matcher)Matchers.containsString((String)"samlp:ArtifactResponse"));
        MatcherAssert.assertThat((Object)artifactResponse, (Matcher)Matchers.containsString((String)"samlp:Response"));
        MatcherAssert.assertThat((Object)artifactResponse, (Matcher)Matchers.containsString((String)"saml:Assertion"));
        MatcherAssert.assertThat((Object)artifactResponse.indexOf("samlp:ArtifactResponse"), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(artifactResponse.indexOf("samlp:Response"))));
        MatcherAssert.assertThat((Object)artifactResponse.indexOf("samlp:Response"), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(artifactResponse.indexOf("saml:Assertion"))));
        MatcherAssert.assertThat((Object)artifactResponse.split("\\Q<saml:Issuer>http://saml.idp/saml</saml:Issuer>\\E").length, (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)artifactResponse.split("\\Q<samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\"/>\\E").length, (Matcher)Matchers.is((Object)3));
    }
}

