/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.io.File;
import java.util.Optional;

public final class StringPropertyReplacer {
    private static final String FILE_SEPARATOR = File.separator;
    private static final String PATH_SEPARATOR = File.pathSeparator;
    private static final String FILE_SEPARATOR_ALIAS = "/";
    private static final String PATH_SEPARATOR_ALIAS = ":";
    private static final int NORMAL = 0;
    private static final int SEEN_DOLLAR = 1;
    private static final int IN_BRACKET = 2;
    private static final PropertyResolver NULL_RESOLVER = property -> null;
    private static PropertyResolver DEFAULT_PROPERTY_RESOLVER;

    public static void setDefaultPropertyResolver(PropertyResolver systemVariables) {
        DEFAULT_PROPERTY_RESOLVER = systemVariables;
    }

    public static String replaceProperties(String string) {
        return StringPropertyReplacer.replaceProperties(string, StringPropertyReplacer.getDefaultPropertyResolver());
    }

    public static String replaceProperties(String string, PropertyResolver resolver) {
        if (string == null) {
            return null;
        }
        char[] chars = string.toCharArray();
        StringBuilder buffer = new StringBuilder();
        boolean properties = false;
        int state = 0;
        int start = 0;
        int openBracketsCount = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '$' && state != 2) {
                state = 1;
                continue;
            }
            if (c == '{' && state == 1) {
                buffer.append(string.substring(start, i - 1));
                state = 2;
                start = i - 1;
                openBracketsCount = 1;
                continue;
            }
            if (c == '{' && state == 2) {
                ++openBracketsCount;
                continue;
            }
            if (state == 1) {
                state = 0;
                continue;
            }
            if (c == '}' && state == 2 && openBracketsCount > 1) {
                --openBracketsCount;
                continue;
            }
            if (c != '}' || state != 2) continue;
            if (start + 2 == i) {
                buffer.append("${}");
            } else {
                String value = null;
                String key = string.substring(start + 2, i);
                if (FILE_SEPARATOR_ALIAS.equals(key)) {
                    value = FILE_SEPARATOR;
                } else if (PATH_SEPARATOR_ALIAS.equals(key)) {
                    value = PATH_SEPARATOR;
                } else {
                    value = StringPropertyReplacer.resolveValue(resolver, key);
                    if (value == null) {
                        int colon = key.indexOf(58);
                        if (colon > 0) {
                            String realKey = key.substring(0, colon);
                            value = StringPropertyReplacer.resolveValue(resolver, realKey);
                            if (value == null && (value = StringPropertyReplacer.resolveCompositeKey(realKey, resolver)) == null) {
                                value = key.substring(colon + 1);
                            }
                        } else {
                            value = StringPropertyReplacer.resolveCompositeKey(key, resolver);
                        }
                    }
                }
                if (value != null) {
                    properties = true;
                    buffer.append(value);
                } else {
                    buffer.append("${");
                    buffer.append(key);
                    buffer.append('}');
                }
            }
            start = i + 1;
            state = 0;
        }
        if (!properties) {
            return string;
        }
        if (start != chars.length) {
            buffer.append(string.substring(start, chars.length));
        }
        if (buffer.indexOf("${") != -1) {
            try {
                return StringPropertyReplacer.replaceProperties(buffer.toString(), resolver);
            }
            catch (StackOverflowError ex) {
                throw new IllegalStateException("Infinite recursion happening when replacing properties on '" + buffer + "'");
            }
        }
        return buffer.toString();
    }

    private static String resolveCompositeKey(String key, PropertyResolver resolver) {
        String value = null;
        int comma = key.indexOf(44);
        if (comma > -1) {
            if (comma > 0) {
                String key1 = key.substring(0, comma);
                value = StringPropertyReplacer.resolveValue(resolver, key1);
            }
            if (value == null && comma < key.length() - 1) {
                String key2 = key.substring(comma + 1);
                value = StringPropertyReplacer.resolveValue(resolver, key2);
            }
        }
        return value;
    }

    private static String resolveValue(PropertyResolver resolver, String key) {
        if (resolver == null) {
            return StringPropertyReplacer.getDefaultPropertyResolver().resolve(key);
        }
        return resolver.resolve(key);
    }

    private static PropertyResolver getDefaultPropertyResolver() {
        return Optional.ofNullable(DEFAULT_PROPERTY_RESOLVER).orElse(NULL_RESOLVER);
    }

    public static interface PropertyResolver {
        public String resolve(String var1);
    }
}

