/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.AnnotationBasedArgumentsProvider;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvArgumentsProvider;
import org.junit.jupiter.params.provider.CsvFileSource;
import org.junit.jupiter.params.provider.CsvParserFactory;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvParser;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;

class CsvFileArgumentsProvider
extends AnnotationBasedArgumentsProvider<CsvFileSource> {
    private final InputStreamProvider inputStreamProvider;
    private Charset charset;
    private int numLinesToSkip;
    private CsvParser csvParser;

    CsvFileArgumentsProvider() {
        this(DefaultInputStreamProvider.INSTANCE);
    }

    CsvFileArgumentsProvider(InputStreamProvider inputStreamProvider) {
        this.inputStreamProvider = inputStreamProvider;
    }

    @Override
    protected Stream<? extends Arguments> provideArguments(ExtensionContext context, CsvFileSource csvFileSource) {
        this.charset = this.getCharsetFrom(csvFileSource);
        this.numLinesToSkip = csvFileSource.numLinesToSkip();
        this.csvParser = CsvParserFactory.createParserFor(csvFileSource);
        Stream<Source> resources = Arrays.stream(csvFileSource.resources()).map(this.inputStreamProvider::classpathResource);
        Stream<Source> files = Arrays.stream(csvFileSource.files()).map(this.inputStreamProvider::file);
        List sources = Stream.concat(resources, files).collect(Collectors.toList());
        return ((List)Preconditions.notEmpty(sources, (String)"Resources or files must not be empty")).stream().map(source -> source.open(context)).map(inputStream -> this.beginParsing((InputStream)inputStream, csvFileSource)).flatMap(parser -> this.toStream((CsvParser)parser, csvFileSource));
    }

    private Charset getCharsetFrom(CsvFileSource csvFileSource) {
        try {
            return Charset.forName(csvFileSource.encoding());
        }
        catch (Exception ex) {
            throw new PreconditionViolationException("The charset supplied in " + csvFileSource + " is invalid", (Throwable)ex);
        }
    }

    private CsvParser beginParsing(InputStream inputStream, CsvFileSource csvFileSource) {
        try {
            this.csvParser.beginParsing(inputStream, this.charset);
        }
        catch (Throwable throwable) {
            CsvArgumentsProvider.handleCsvException(throwable, csvFileSource);
        }
        return this.csvParser;
    }

    private Stream<Arguments> toStream(CsvParser csvParser, CsvFileSource csvFileSource) {
        CsvParserIterator iterator = new CsvParserIterator(csvParser, csvFileSource);
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).skip(this.numLinesToSkip).onClose(() -> {
            try {
                csvParser.stopParsing();
            }
            catch (Throwable throwable) {
                CsvArgumentsProvider.handleCsvException(throwable, csvFileSource);
            }
        });
    }

    private static class DefaultInputStreamProvider
    implements InputStreamProvider {
        private static final DefaultInputStreamProvider INSTANCE = new DefaultInputStreamProvider();

        private DefaultInputStreamProvider() {
        }

        @Override
        public InputStream openClasspathResource(Class<?> baseClass, String path) {
            Preconditions.notBlank((String)path, () -> "Classpath resource [" + path + "] must not be null or blank");
            InputStream inputStream = baseClass.getResourceAsStream(path);
            return (InputStream)Preconditions.notNull((Object)inputStream, () -> "Classpath resource [" + path + "] does not exist");
        }

        @Override
        public InputStream openFile(String path) {
            Preconditions.notBlank((String)path, () -> "File [" + path + "] must not be null or blank");
            try {
                return Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new JUnitException("File [" + path + "] could not be read", (Throwable)e);
            }
        }
    }

    static interface InputStreamProvider {
        public InputStream openClasspathResource(Class<?> var1, String var2);

        public InputStream openFile(String var1);

        default public Source classpathResource(String path) {
            return context -> this.openClasspathResource(context.getRequiredTestClass(), path);
        }

        default public Source file(String path) {
            return context -> this.openFile(path);
        }
    }

    private static class CsvParserIterator
    implements Iterator<Arguments> {
        private final CsvParser csvParser;
        private final CsvFileSource csvFileSource;
        private final boolean useHeadersInDisplayName;
        private final Set<String> nullValues;
        private Arguments nextArguments;
        private String[] headers;

        CsvParserIterator(CsvParser csvParser, CsvFileSource csvFileSource) {
            this.csvParser = csvParser;
            this.csvFileSource = csvFileSource;
            this.useHeadersInDisplayName = csvFileSource.useHeadersInDisplayName();
            this.nullValues = CollectionUtils.toSet((Object[])csvFileSource.nullValues());
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextArguments != null;
        }

        @Override
        public Arguments next() {
            Arguments result = this.nextArguments;
            this.advance();
            return result;
        }

        private void advance() {
            try {
                Object[] csvRecord = this.csvParser.parseNext();
                if (csvRecord != null) {
                    if (this.useHeadersInDisplayName && this.headers == null) {
                        this.headers = CsvArgumentsProvider.getHeaders(this.csvParser);
                    }
                    this.nextArguments = CsvArgumentsProvider.processCsvRecord(csvRecord, this.nullValues, this.useHeadersInDisplayName, this.headers);
                } else {
                    this.nextArguments = null;
                }
            }
            catch (Throwable throwable) {
                CsvArgumentsProvider.handleCsvException(throwable, this.csvFileSource);
            }
        }
    }

    @FunctionalInterface
    private static interface Source {
        public InputStream open(ExtensionContext var1);
    }
}

