/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.EffectSystem;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImplicitIntegerCoercion;
import org.jetbrains.kotlin.resolve.MissingSupertypesResolver;
import org.jetbrains.kotlin.resolve.RecursiveContractHelperKt;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolverKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.checkers.MissingDependencySupertypeChecker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u001a\u001a\u00020\u0017\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001eH\u0002J(\u0010\u001f\u001a\u00020\u0017\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001eH\u0002J4\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001e\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001e2\u0006\u0010!\u001a\u00020\"J\u001e\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J@\u0010+\u001a\u00020\u0017\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u0002H\u001b\u0018\u00010-2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010.\u001a\u0004\u0018\u00010/2\n\u00100\u001a\u0006\u0012\u0002\b\u000301H\u0002J\u0018\u00102\u001a\u0002032\u0006\u0010$\u001a\u00020%2\u0006\u00104\u001a\u000205H\u0002J6\u00106\u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u0001072\b\u00109\u001a\u0004\u0018\u0001072\u0006\u0010:\u001a\u00020%2\u0006\u0010;\u001a\u00020<2\u0006\u00104\u001a\u000205H\u0002J,\u0010=\u001a\u00020\u0017\"\b\b\u0000\u0010\u001b*\u00020\u001c*\b\u0012\u0004\u0012\u0002H\u001b0-2\u0006\u0010>\u001a\u0002072\u0006\u00104\u001a\u000205H\u0002J,\u0010?\u001a\u00020\u0017\"\b\b\u0000\u0010\u001b*\u00020\u001c*\b\u0012\u0004\u0012\u0002H\u001b0-2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010@\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030-2\u0006\u0010A\u001a\u000205H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "candidateResolver", "Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "callCheckers", "", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "effectSystem", "Lorg/jetbrains/kotlin/contracts/EffectSystem;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "missingSupertypesResolver", "Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;Lorg/jetbrains/kotlin/contracts/EffectSystem;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;)V", "checkMissingSupertypes", "", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "completeAllCandidates", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "results", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "completeArguments", "completeCall", "tracing", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "completeCallForArgument", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "completeOneArgument", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "completeResolvedCallAndArguments", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/MutableResolvedCall;", "createTypeForConvertableConstant", "Lorg/jetbrains/kotlin/types/SimpleType;", "constant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "hasNecessarySafeCall", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "updateRecordedTypeForArgument", "Lorg/jetbrains/kotlin/types/KotlinType;", "updatedType", "recordedType", "argumentExpression", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "completeConstraintSystem", "expectedType", "updateResolutionStatusFromConstraintSystem", "updateResultDataFlowInfoUsingEffects", "bindingTrace", "frontend"})
public final class CallCompleter {
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final CandidateResolver candidateResolver;
    @NotNull
    private final DataFlowAnalyzer dataFlowAnalyzer;
    @NotNull
    private final Iterable<CallChecker> callCheckers;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final DeprecationResolver deprecationResolver;
    @NotNull
    private final EffectSystem effectSystem;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    private final MissingSupertypesResolver missingSupertypesResolver;

    public CallCompleter(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull CandidateResolver candidateResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull Iterable<? extends CallChecker> callCheckers, @NotNull ModuleDescriptor moduleDescriptor, @NotNull DeprecationResolver deprecationResolver, @NotNull EffectSystem effectSystem, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull MissingSupertypesResolver missingSupertypesResolver) {
        Intrinsics.checkNotNullParameter((Object)argumentTypeResolver, (String)"argumentTypeResolver");
        Intrinsics.checkNotNullParameter((Object)candidateResolver, (String)"candidateResolver");
        Intrinsics.checkNotNullParameter((Object)dataFlowAnalyzer, (String)"dataFlowAnalyzer");
        Intrinsics.checkNotNullParameter(callCheckers, (String)"callCheckers");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)deprecationResolver, (String)"deprecationResolver");
        Intrinsics.checkNotNullParameter((Object)effectSystem, (String)"effectSystem");
        Intrinsics.checkNotNullParameter((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        Intrinsics.checkNotNullParameter((Object)missingSupertypesResolver, (String)"missingSupertypesResolver");
        this.argumentTypeResolver = argumentTypeResolver;
        this.candidateResolver = candidateResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.callCheckers = callCheckers;
        this.moduleDescriptor = moduleDescriptor;
        this.deprecationResolver = deprecationResolver;
        this.effectSystem = effectSystem;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.missingSupertypesResolver = missingSupertypesResolver;
    }

    @NotNull
    public final <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> completeCall(@NotNull BasicCallResolutionContext context2, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter((Object)tracing, (String)"tracing");
        ResolvedCall resolvedCall2 = results.isSingleResult() ? results.getResultingCall() : null;
        Object object = context2.call;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.call");
        if (!CallResolverUtilKt.isInvokeCallOnVariable((Call)object)) {
            this.completeResolvedCallAndArguments((MutableResolvedCall<D>)resolvedCall2, results, context2, tracing);
            this.completeAllCandidates(context2, results);
        }
        if (context2.trace.wantsDiagnostics()) {
            if (resolvedCall2 == null) {
                this.checkMissingSupertypes(context2, this.missingSupertypesResolver);
            } else {
                KtExpression calleeExpression = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getCall().getCalleeExpression() : resolvedCall2.getCall().getCalleeExpression();
                KtElement ktElement = calleeExpression != null && !CallUtilKt.isFakeElement(calleeExpression) ? (KtElement)calleeExpression : resolvedCall2.getCall().getCallElement();
                Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"if (calleeExpression != null && !calleeExpression.isFakeElement) calleeExpression\n                    else resolvedCall.call.callElement");
                KtElement reportOn = ktElement;
                CallCheckerContext callCheckerContext = new CallCheckerContext(context2, this.deprecationResolver, this.moduleDescriptor, this.missingSupertypesResolver, null, 16, null);
                for (CallChecker callChecker : this.callCheckers) {
                    callChecker.check(resolvedCall2, reportOn, callCheckerContext);
                    if (!(resolvedCall2 instanceof VariableAsFunctionResolvedCall)) continue;
                    callChecker.check(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall(), reportOn, callCheckerContext);
                }
            }
        }
        if (results.isSingleResult() && results.getResultingCall().getStatus().isSuccess()) {
            object = results.changeStatusToSuccess();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"results.changeStatusToSuccess()");
            return object;
        }
        return results;
    }

    private final void checkMissingSupertypes(BasicCallResolutionContext context2, MissingSupertypesResolver missingSupertypesResolver) {
        Object object;
        Call call2 = context2.call;
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"context.call");
        Call call3 = call2;
        Receiver $this$safeAs$iv = call3.getExplicitReceiver();
        boolean $i$f$safeAs = false;
        Receiver receiver = $this$safeAs$iv;
        if (!(receiver instanceof ReceiverValue)) {
            receiver = null;
        }
        if ((object = (ReceiverValue)receiver) == null) {
            return;
        }
        ReceiverValue explicitReceiver = object;
        object = explicitReceiver.getType();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"explicitReceiver.type");
        Object object2 = object;
        object = call3.getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"call.callElement");
        PsiElement psiElement = (PsiElement)object;
        object = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.trace");
        MissingDependencySupertypeChecker.INSTANCE.checkSupertypes((KotlinType)object2, psiElement, (BindingTrace)object, missingSupertypesResolver);
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor> void completeAllCandidates(BasicCallResolutionContext context2, OverloadResolutionResultsImpl<D> results) {
        void $this$forEach$iv;
        void $this$filterNotTo$iv$iv;
        Collection<ResolvedCall<D>> collection;
        Collection<ResolvedCall<D>> collection2;
        Object object;
        if (context2.collectAllCandidates) {
            object = results.getAllCandidates();
            Intrinsics.checkNotNull(object);
            collection = collection2 = object;
        } else {
            collection2 = results.getResultingCalls();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"{\n            results.resultingCalls\n        }");
            collection = collection2;
        }
        Collection<ResolvedCall<D>> candidates2 = collection;
        object = TemporaryBindingTrace.create(context2.trace, "Trace to complete a candidate that is not a resulting call");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(context.trace, \"Trace to complete a candidate that is not a resulting call\")");
        Object temporaryBindingTrace = object;
        Iterable $this$filterNot$iv = candidates2;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            MutableResolvedCall resolvedCall2 = (MutableResolvedCall)element$iv$iv;
            boolean bl = false;
            if (resolvedCall2.isCompleted()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableResolvedCall resolvedCall3 = (MutableResolvedCall)element$iv;
            boolean bl = false;
            Object object2 = context2.replaceBindingTrace((BindingTrace)temporaryBindingTrace);
            Intrinsics.checkNotNullExpressionValue(object2, (String)"context.replaceBindingTrace(temporaryBindingTrace)");
            BasicCallResolutionContext basicCallResolutionContext = (BasicCallResolutionContext)object2;
            object2 = TracingStrategy.EMPTY;
            Intrinsics.checkNotNullExpressionValue(object2, (String)"EMPTY");
            this.completeResolvedCallAndArguments(resolvedCall3, results, basicCallResolutionContext, (TracingStrategy)object2);
        }
    }

    private final <D extends CallableDescriptor> void completeResolvedCallAndArguments(MutableResolvedCall<D> resolvedCall2, OverloadResolutionResultsImpl<D> results, BasicCallResolutionContext context2, TracingStrategy tracing) {
        Object object = context2.call;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.call");
        Call call2 = object;
        object = resolvedCall2;
        CallableDescriptor callableDescriptor = object == null ? null : (CallableDescriptor)object.getResultingDescriptor();
        object = context2.scope;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.scope");
        MutableResolvedCall<D> mutableResolvedCall = object;
        object = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.trace");
        RecursiveContractHelperKt.disableContractsInsideContractsBlock(call2, callableDescriptor, (LexicalScope)((Object)mutableResolvedCall), (BindingTrace)object);
        if (resolvedCall2 == null || resolvedCall2.isCompleted() || resolvedCall2.getConstraintSystem() == null) {
            this.completeArguments(context2, results);
            object = resolvedCall2;
            if (object != null) {
                BindingTrace bindingTrace = context2.trace;
                Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
                this.updateResultDataFlowInfoUsingEffects((MutableResolvedCall<?>)object, bindingTrace);
            }
            object = resolvedCall2;
            if (object != null) {
                object.markCallAsCompleted();
            }
            return;
        }
        object = context2.expectedType;
        Intrinsics.checkNotNullExpressionValue(object, (String)"context.expectedType");
        MutableResolvedCall<D> mutableResolvedCall2 = object;
        object = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.trace");
        this.completeConstraintSystem(resolvedCall2, (KotlinType)((Object)mutableResolvedCall2), (BindingTrace)object);
        this.completeArguments(context2, results);
        this.updateResolutionStatusFromConstraintSystem(resolvedCall2, context2, tracing);
        object = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.trace");
        this.updateResultDataFlowInfoUsingEffects(resolvedCall2, (BindingTrace)object);
        resolvedCall2.markCallAsCompleted();
    }

    private final <D extends CallableDescriptor> void completeConstraintSystem(MutableResolvedCall<D> $this$completeConstraintSystem, KotlinType expectedType2, BindingTrace trace) {
        ConstraintSystemCompleter constraintSystemCompleter;
        KotlinType expectedReturnType;
        KotlinType kotlinType;
        KotlinType returnType2 = $this$completeConstraintSystem.getCandidateDescriptor().getReturnType();
        Object object = $this$completeConstraintSystem.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"call");
        if (CallUtilKt.isCallableReference((Call)object)) {
            if (!TypeUtils.noExpectedType(expectedType2) && FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType2)) {
                kotlinType = FunctionTypesKt.getReturnTypeFromFunctionType(expectedType2);
            } else {
                object = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NO_EXPECTED_TYPE");
                kotlinType = (KotlinType)object;
            }
        } else {
            kotlinType = expectedReturnType = expectedType2;
        }
        if (returnType2 != null && !TypeUtils.noExpectedType(expectedReturnType)) {
            CallCompleter.completeConstraintSystem$updateSystemIfNeeded($this$completeConstraintSystem, (Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)((Function1)new Function1<ConstraintSystem.Builder, ConstraintSystem>(returnType2, expectedReturnType, $this$completeConstraintSystem){
                final /* synthetic */ KotlinType $returnType;
                final /* synthetic */ KotlinType $expectedReturnType;
                final /* synthetic */ MutableResolvedCall<D> $this_completeConstraintSystem;
                {
                    this.$returnType = $returnType;
                    this.$expectedReturnType = $expectedReturnType;
                    this.$this_completeConstraintSystem = $receiver;
                    super(1);
                }

                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder2) {
                    ConstraintSystem constraintSystem;
                    Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                    KotlinType returnTypeInSystem = CallCompleter.access$completeConstraintSystem$typeInSystem(builder2, this.$this_completeConstraintSystem, this.$returnType);
                    if (returnTypeInSystem != null) {
                        builder2.addSubtypeConstraint(returnTypeInSystem, this.$expectedReturnType, ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
                        constraintSystem = builder2.build();
                    } else {
                        constraintSystem = null;
                    }
                    return constraintSystem;
                }
            }));
        }
        if ((constraintSystemCompleter = (ConstraintSystemCompleter)trace.get(BindingContext.CONSTRAINT_SYSTEM_COMPLETER, $this$completeConstraintSystem.getCall().getCalleeExpression())) != null) {
            CallCompleter.completeConstraintSystem$updateSystemIfNeeded($this$completeConstraintSystem, (Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)((Function1)new Function1<ConstraintSystem.Builder, ConstraintSystem>(constraintSystemCompleter, $this$completeConstraintSystem){
                final /* synthetic */ ConstraintSystemCompleter $constraintSystemCompleter;
                final /* synthetic */ MutableResolvedCall<D> $this_completeConstraintSystem;
                {
                    this.$constraintSystemCompleter = $constraintSystemCompleter;
                    this.$this_completeConstraintSystem = $receiver;
                    super(1);
                }

                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder2) {
                    Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                    this.$constraintSystemCompleter.completeConstraintSystem(builder2, (ResolvedCall)this.$this_completeConstraintSystem);
                    ConstraintSystem system2 = builder2.build();
                    ConstraintSystemStatus status2 = ConstraintSystemUtilsKt.filterConstraintsOut(system2, ConstraintPositionKind.TYPE_BOUND_POSITION).getStatus();
                    return status2.hasOnlyErrorsDerivedFrom(ConstraintPositionKind.FROM_COMPLETER) ? null : system2;
                }
            }));
        }
        if (returnType2 != null && expectedReturnType == TypeUtils.UNIT_EXPECTED_TYPE) {
            CallCompleter.completeConstraintSystem$updateSystemIfNeeded($this$completeConstraintSystem, (Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)((Function1)new Function1<ConstraintSystem.Builder, ConstraintSystem>(returnType2, this, $this$completeConstraintSystem){
                final /* synthetic */ KotlinType $returnType;
                final /* synthetic */ CallCompleter this$0;
                final /* synthetic */ MutableResolvedCall<D> $this_completeConstraintSystem;
                {
                    this.$returnType = $returnType;
                    this.this$0 = $receiver;
                    this.$this_completeConstraintSystem = $receiver2;
                    super(1);
                }

                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder2) {
                    ConstraintSystem constraintSystem;
                    Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                    KotlinType returnTypeInSystem = CallCompleter.access$completeConstraintSystem$typeInSystem(builder2, this.$this_completeConstraintSystem, this.$returnType);
                    if (returnTypeInSystem != null) {
                        builder2.addSubtypeConstraint(returnTypeInSystem, CallCompleter.access$getModuleDescriptor$p(this.this$0).getBuiltIns().getUnitType(), ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
                        ConstraintSystem system2 = builder2.build();
                        constraintSystem = system2.getStatus().isSuccessful() ? system2 : null;
                    } else {
                        constraintSystem = null;
                    }
                    return constraintSystem;
                }
            }));
        }
        Call call2 = $this$completeConstraintSystem.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"call");
        if (CallUtilKt.isCallableReference(call2) && !TypeUtils.noExpectedType(expectedType2) && FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType2)) {
            CallCompleter.completeConstraintSystem$updateSystemIfNeeded($this$completeConstraintSystem, (Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)((Function1)new Function1<ConstraintSystem.Builder, ConstraintSystem>($this$completeConstraintSystem, expectedType2){
                final /* synthetic */ MutableResolvedCall<D> $this_completeConstraintSystem;
                final /* synthetic */ KotlinType $expectedType;
                {
                    this.$this_completeConstraintSystem = $receiver;
                    this.$expectedType = $expectedType;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder2) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                    Iterable<ValueParameterDescriptor> iterable = this.$this_completeConstraintSystem.getCandidateDescriptor().getValueParameters();
                    Intrinsics.checkNotNullExpressionValue(iterable, (String)"candidateDescriptor.valueParameters");
                    iterable = CollectionsKt.zip((Iterable)iterable, (Iterable)FunctionTypesKt.getValueParameterTypesFromFunctionType(this.$expectedType));
                    MutableResolvedCall<D> mutableResolvedCall = this.$this_completeConstraintSystem;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Pair $dstr$parameter$argument = (Pair)element$iv;
                        boolean bl = false;
                        ValueParameterDescriptor parameter = (ValueParameterDescriptor)$dstr$parameter$argument.component1();
                        TypeProjection argument2 = (TypeProjection)$dstr$parameter$argument.component2();
                        KotlinType valueParameterInSystem = CallCompleter.access$completeConstraintSystem$typeInSystem(builder2, mutableResolvedCall, parameter.getType());
                        builder2.addSubtypeConstraint(valueParameterInSystem, argument2.getType(), ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(parameter.getIndex()));
                    }
                    return builder2.build();
                }
            }));
        }
        ConstraintSystem constraintSystem = $this$completeConstraintSystem.getConstraintSystem();
        Intrinsics.checkNotNull((Object)constraintSystem);
        ConstraintSystem constraintSystem2 = constraintSystem;
        ConstraintSystem.Builder builder2 = ConstraintSystem.DefaultImpls.toBuilder$default(constraintSystem2, null, 1, null);
        builder2.fixVariables();
        ConstraintSystem system2 = builder2.build();
        $this$completeConstraintSystem.setConstraintSystem(system2);
        boolean isNewInferenceEnabled = this.effectSystem.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference);
        TypeSubstitutor typeSubstitutor2 = isNewInferenceEnabled ? system2.getResultingSubstitutor().replaceWithContravariantApproximatingSubstitution() : system2.getResultingSubstitutor();
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"if (isNewInferenceEnabled) {\n            system.resultingSubstitutor.replaceWithContravariantApproximatingSubstitution()\n        } else system.resultingSubstitutor");
        TypeSubstitutor resultingSubstitutor2 = typeSubstitutor2;
        $this$completeConstraintSystem.setResultingSubstitutor(resultingSubstitutor2);
    }

    private final <D extends CallableDescriptor> void updateResolutionStatusFromConstraintSystem(MutableResolvedCall<D> $this$updateResolutionStatusFromConstraintSystem, BasicCallResolutionContext context2, TracingStrategy tracing) {
        CallCandidateResolutionContext<D> callCandidateResolutionContext = CallCandidateResolutionContext.createForCallBeingAnalyzed($this$updateResolutionStatusFromConstraintSystem, context2, tracing);
        Intrinsics.checkNotNullExpressionValue(callCandidateResolutionContext, (String)"createForCallBeingAnalyzed(this, context, tracing)");
        CallCandidateResolutionContext<D> contextWithResolvedCall = callCandidateResolutionContext;
        CandidateResolver.ValueArgumentsCheckingResult valueArgumentsCheckingResult = this.candidateResolver.checkAllValueArguments(contextWithResolvedCall, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        Object object = $this$updateResolutionStatusFromConstraintSystem.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"status");
        ResolutionStatus status2 = object;
        object = $this$updateResolutionStatusFromConstraintSystem.getConstraintSystem();
        Intrinsics.checkNotNull((Object)object);
        if (object.getStatus().isSuccessful()) {
            if (status2 == ResolutionStatus.UNKNOWN_STATUS || status2 == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                $this$updateResolutionStatusFromConstraintSystem.setStatusToSuccess();
            }
            return;
        }
        ReceiverValue receiverValue = $this$updateResolutionStatusFromConstraintSystem.getExtensionReceiver();
        KotlinType receiverType = receiverValue == null ? null : receiverValue.getType();
        Object d = $this$updateResolutionStatusFromConstraintSystem.getCandidateDescriptor();
        ConstraintSystem constraintSystem = $this$updateResolutionStatusFromConstraintSystem.getConstraintSystem();
        Intrinsics.checkNotNull((Object)constraintSystem);
        InferenceErrorData inferenceErrorData = InferenceErrorData.create(d, constraintSystem, valueArgumentsCheckingResult.getArgumentTypes(), receiverType, context2.expectedType, context2.call);
        Intrinsics.checkNotNullExpressionValue((Object)inferenceErrorData, (String)"create(\n            candidateDescriptor, constraintSystem!!, valueArgumentsCheckingResult.argumentTypes,\n            receiverType, context.expectedType, context.call\n        )");
        InferenceErrorData errorData = inferenceErrorData;
        tracing.typeInferenceFailed(context2, errorData);
        $this$updateResolutionStatusFromConstraintSystem.addStatus(ResolutionStatus.OTHER_ERROR);
    }

    private final <D extends CallableDescriptor> void completeArguments(BasicCallResolutionContext context2, OverloadResolutionResultsImpl<D> results) {
        if (context2.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        Function1 getArgumentMapping = null;
        Function1 getDataFlowInfoForArgument = null;
        if (results.isSingleResult()) {
            ResolvedCall resolvedCall2 = results.getResultingCall();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedCall2, (String)"results.resultingCall");
            ResolvedCall resolvedCall3 = resolvedCall2;
            getArgumentMapping = (Function1)new Function1<ValueArgument, ArgumentMapping>(resolvedCall3){
                final /* synthetic */ MutableResolvedCall<D> $resolvedCall;
                {
                    this.$resolvedCall = $resolvedCall;
                    super(1);
                }

                @NotNull
                public final ArgumentMapping invoke(@NotNull ValueArgument argument2) {
                    Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
                    ArgumentMapping argumentMapping = this.$resolvedCall.getArgumentMapping(argument2);
                    Intrinsics.checkNotNullExpressionValue((Object)argumentMapping, (String)"resolvedCall.getArgumentMapping(argument)");
                    return argumentMapping;
                }
            };
            getDataFlowInfoForArgument = (Function1)new Function1<ValueArgument, DataFlowInfo>(resolvedCall3){
                final /* synthetic */ MutableResolvedCall<D> $resolvedCall;
                {
                    this.$resolvedCall = $resolvedCall;
                    super(1);
                }

                @NotNull
                public final DataFlowInfo invoke(@NotNull ValueArgument argument2) {
                    Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
                    DataFlowInfo dataFlowInfo = this.$resolvedCall.getDataFlowInfoForArguments().getInfo(argument2);
                    Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"resolvedCall.dataFlowInfoForArguments.getInfo(argument)");
                    return dataFlowInfo;
                }
            };
        } else {
            getArgumentMapping = completeArguments.3.INSTANCE;
            getDataFlowInfoForArgument = (Function1)new Function1<ValueArgument, DataFlowInfo>(context2){
                final /* synthetic */ BasicCallResolutionContext $context;
                {
                    this.$context = $context;
                    super(1);
                }

                @NotNull
                public final DataFlowInfo invoke(@NotNull ValueArgument it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    DataFlowInfo dataFlowInfo = this.$context.dataFlowInfo;
                    Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"context.dataFlowInfo");
                    return dataFlowInfo;
                }
            };
        }
        for (ValueArgument valueArgument : context2.call.getValueArguments()) {
            Object object;
            Intrinsics.checkNotNull((Object)valueArgument);
            ArgumentMapping argumentMapping = (ArgumentMapping)getArgumentMapping.invoke((Object)valueArgument);
            KotlinType expectedType2 = null;
            CallPosition callPosition = null;
            ValueParameterDescriptor parameter = null;
            ArgumentMapping argumentMapping2 = argumentMapping;
            if (argumentMapping2 instanceof ArgumentMatch) {
                expectedType2 = CallResolverUtilKt.getEffectiveExpectedType(((ArgumentMatch)argumentMapping).getValueParameter(), valueArgument, context2);
                object = results.getResultingCall();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"results.resultingCall");
                callPosition = new CallPosition.ValueArgumentPosition((ResolvedCall)object, ((ArgumentMatch)argumentMapping).getValueParameter(), valueArgument);
                parameter = ((ArgumentMatch)argumentMapping).getValueParameter();
            } else {
                object = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NO_EXPECTED_TYPE");
                expectedType2 = (KotlinType)object;
                callPosition = CallPosition.Unknown.INSTANCE;
                parameter = null;
            }
            object = ((BasicCallResolutionContext)((BasicCallResolutionContext)context2.replaceDataFlowInfo((DataFlowInfo)getDataFlowInfoForArgument.invoke((Object)valueArgument))).replaceExpectedType(expectedType2)).replaceCallPosition(callPosition);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.replaceDataFlowInfo(getDataFlowInfoForArgument(valueArgument))\n                    .replaceExpectedType(expectedType)\n                    .replaceCallPosition(callPosition)");
            BasicCallResolutionContext newContext = (BasicCallResolutionContext)object;
            this.completeOneArgument(valueArgument, parameter, newContext);
        }
    }

    private final SimpleType createTypeForConvertableConstant(CompileTimeConstant<?> constant) {
        Object object;
        Long l;
        SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"NO_EXPECTED_TYPE");
        Object $this$safeAs$iv = constant.getValue(simpleType2);
        boolean $i$f$safeAs = false;
        Object obj = $this$safeAs$iv;
        if (!(obj instanceof Number)) {
            obj = null;
        }
        Long l2 = l = (object = (Number)obj) == null ? null : Long.valueOf(((Number)object).longValue());
        if (l == null) {
            return null;
        }
        long value2 = l;
        IntegerValueTypeConstructor typeConstructor2 = new IntegerValueTypeConstructor(value2, this.moduleDescriptor, constant.getParameters());
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        TypeConstructor typeConstructor3 = typeConstructor2;
        List list2 = CollectionsKt.emptyList();
        object = ErrorUtils.createErrorScope("Scope for number value type (" + typeConstructor2 + ')', true);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createErrorScope(\"Scope for number value type ($typeConstructor)\", true)");
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations2, typeConstructor3, list2, false, (MemberScope)object);
    }

    private final void completeOneArgument(ValueArgument argument2, ValueParameterDescriptor parameter, BasicCallResolutionContext context2) {
        boolean bl;
        boolean bl2;
        Object resolvedCall2;
        Object object;
        boolean convertedConst;
        KtExpression ktExpression;
        if (argument2.isExternal()) {
            return;
        }
        KtExpression ktExpression2 = argument2.getArgumentExpression();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression expression2 = ktExpression2;
        KtExpression ktExpression3 = KtPsiUtil.getLastElementDeparenthesized(expression2, context2.statementFilter);
        if (ktExpression3 == null) {
            return;
        }
        KtExpression deparenthesized = ktExpression = ktExpression3;
        KotlinType recordedType = context2.trace.getType(expression2);
        Object updatedType = recordedType;
        OverloadResolutionResultsImpl<?> results = this.completeCallForArgument(deparenthesized, context2);
        CompileTimeConstant constant = (CompileTimeConstant)context2.trace.get(BindingContext.COMPILE_TIME_VALUE, deparenthesized);
        boolean bl3 = convertedConst = constant instanceof IntegerValueTypeConstant && ((IntegerValueTypeConstant)constant).getConvertedFromSigned();
        if (results != null && results.isSingleResult()) {
            object = results.getResultingCall();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"results.resultingCall");
            resolvedCall2 = object;
            if (!convertedConst) {
                Object object2 = resolvedCall2.hasInferredReturnType() ? ResolvedCallUtilKt.makeNullableTypeIfSafeReceiver((ResolvedCall)resolvedCall2, (object = resolvedCall2.getResultingDescriptor()) == null ? null : object.getReturnType(), context2) : (updatedType = null);
            }
        }
        if (recordedType != null && !recordedType.getConstructor().isDenotable()) {
            resolvedCall2 = this.argumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context2, expression2);
            Object object3 = updatedType = resolvedCall2 == null ? updatedType : resolvedCall2;
        }
        if (parameter != null && ImplicitIntegerCoercion.INSTANCE.isEnabledForParameter(parameter)) {
            SimpleType generalNumberType;
            CompileTimeConstant argumentCompileTimeValue = (CompileTimeConstant)context2.trace.get(BindingContext.COMPILE_TIME_VALUE, deparenthesized);
            if (argumentCompileTimeValue != null && argumentCompileTimeValue.getParameters().isConvertableConstVal() && (generalNumberType = this.createTypeForConvertableConstant(argumentCompileTimeValue)) != null) {
                updatedType = this.argumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context2.trace, context2.statementFilter, context2.expectedType, generalNumberType, expression2);
            }
        } else if (convertedConst) {
            context2.trace.report(Errors.SIGNED_CONSTANT_CONVERTED_TO_UNSIGNED.on((KtExpression)((PsiElement)deparenthesized)));
        }
        Object object4 = context2.statementFilter;
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"context.statementFilter");
        StatementFilter statementFilter = object4;
        object4 = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"context.trace");
        updatedType = this.updateRecordedTypeForArgument((KotlinType)updatedType, recordedType, expression2, statementFilter, (BindingTrace)object4);
        object4 = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context2);
        if (object4 != null) {
            object = object4;
            bl2 = false;
            bl = false;
            Object functionLiteralArgument = object;
            boolean bl4 = false;
            this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression2, (KtFunction)functionLiteralArgument, context2, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, false);
        }
        object4 = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context2);
        if (object4 != null) {
            object = object4;
            bl2 = false;
            bl = false;
            Object callableReferenceArgument = object;
            boolean bl5 = false;
            this.argumentTypeResolver.getCallableReferenceTypeInfo(expression2, (KtCallableReferenceExpression)callableReferenceArgument, context2, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        }
        this.dataFlowAnalyzer.checkType((KotlinType)updatedType, deparenthesized, (ResolutionContext)context2);
    }

    private final OverloadResolutionResultsImpl<?> completeCallForArgument(KtExpression expression2, BasicCallResolutionContext context2) {
        ResolutionResultsCache.CachedData cachedData;
        ResolutionResultsCache.CachedData cachedData2 = GenericCandidateResolverKt.getResolutionResultsCachedData(expression2, context2);
        if (cachedData2 == null) {
            return null;
        }
        cachedData2 = cachedData = cachedData2;
        OverloadResolutionResultsImpl<?> cachedResolutionResults = cachedData2.component1();
        BasicCallResolutionContext cachedContext = cachedData2.component2();
        TracingStrategy tracing = cachedData2.component3();
        Object Context2 = ((BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)cachedContext.replaceBindingTrace(context2.trace)).replaceExpectedType(context2.expectedType)).replaceCollectAllCandidates(false)).replaceCallPosition(context2.callPosition);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"cachedContext.replaceBindingTrace(context.trace)\n            .replaceExpectedType(context.expectedType).replaceCollectAllCandidates(false).replaceCallPosition(context.callPosition)");
        BasicCallResolutionContext contextForArgument = (BasicCallResolutionContext)Context2;
        return this.completeCall(contextForArgument, cachedResolutionResults, tracing);
    }

    private final KotlinType updateRecordedTypeForArgument(KotlinType updatedType, KotlinType recordedType, KtExpression argumentExpression, StatementFilter statementFilter, BindingTrace trace) {
        if (!ErrorUtils.containsErrorType(recordedType) && Intrinsics.areEqual((Object)recordedType, (Object)updatedType) || updatedType == null) {
            return updatedType;
        }
        ArrayList<KtExpression> expressions = new ArrayList<KtExpression>();
        KtExpression expression2 = argumentExpression;
        while (expression2 != null) {
            expressions.add(expression2);
            expression2 = CallCompleter.updateRecordedTypeForArgument$deparenthesizeOrGetSelector(statementFilter, expression2);
        }
        boolean shouldBeMadeNullable = false;
        Iterable $this$forEach$iv = CollectionsKt.asReversedMutable((List)expressions);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression ktExpression = (KtExpression)element$iv;
            boolean bl = false;
            if (!(ktExpression instanceof KtParenthesizedExpression || ktExpression instanceof KtLabeledExpression || ktExpression instanceof KtAnnotatedExpression)) {
                shouldBeMadeNullable = this.hasNecessarySafeCall(ktExpression, trace);
            }
            BindingContextUtils.updateRecordedType(updatedType, ktExpression, trace, shouldBeMadeNullable);
        }
        return trace.getType(argumentExpression);
    }

    private final boolean hasNecessarySafeCall(KtExpression expression2, BindingTrace trace) {
        if (!(expression2 instanceof KtSafeQualifiedExpression)) {
            return false;
        }
        KotlinType expressionType = trace.getType(((KtSafeQualifiedExpression)expression2).getReceiverExpression());
        return expressionType != null && TypeUtils.isNullableType(expressionType);
    }

    private final void updateResultDataFlowInfoUsingEffects(MutableResolvedCall<?> $this$updateResultDataFlowInfoUsingEffects, BindingTrace bindingTrace) {
        DeclarationDescriptor declarationDescriptor;
        if ($this$updateResultDataFlowInfoUsingEffects.getDataFlowInfoForArguments() instanceof MutableDataFlowInfoForArguments.WithoutArgumentsCheck) {
            return;
        }
        Object d = $this$updateResultDataFlowInfoUsingEffects.getResultingDescriptor();
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor = d == null ? null : d.getContainingDeclaration();
        if (declarationDescriptor == null) {
            return;
        }
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(declarationDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"getContainingModule(this.resultingDescriptor?.containingDeclaration ?: return)");
        ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
        DataFlowInfo resultDFIfromES = this.effectSystem.getDataFlowInfoForFinishedCall((ResolvedCall)$this$updateResultDataFlowInfoUsingEffects, bindingTrace, moduleDescriptor2);
        $this$updateResultDataFlowInfoUsingEffects.getDataFlowInfoForArguments().updateResultInfo(resultDFIfromES);
        this.effectSystem.recordDefiniteInvocations((ResolvedCall)$this$updateResultDataFlowInfoUsingEffects, bindingTrace, moduleDescriptor2);
    }

    private static final <D extends CallableDescriptor> KotlinType completeConstraintSystem$typeInSystem(ConstraintSystem.Builder $this$completeConstraintSystem_u24typeInSystem, MutableResolvedCall<D> $this_completeConstraintSystem, KotlinType type2) {
        KotlinType kotlinType;
        KotlinType kotlinType2 = type2;
        if (kotlinType2 == null) {
            kotlinType = null;
        } else {
            KotlinType kotlinType3 = kotlinType2;
            boolean bl = false;
            boolean bl2 = false;
            KotlinType it = kotlinType3;
            boolean bl3 = false;
            Map<CallHandle, TypeSubstitutor> map = $this$completeConstraintSystem_u24typeInSystem.getTypeVariableSubstitutors();
            Object object = $this_completeConstraintSystem.getCall();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"call");
            TypeSubstitutor typeSubstitutor2 = map.get(TypeVariableKt.toHandle((Call)object));
            if (typeSubstitutor2 == null) {
                object = Intrinsics.stringPlus((String)"No substitutor for call: ", (Object)$this_completeConstraintSystem.getCall());
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            TypeSubstitutor substitutor2 = typeSubstitutor2;
            kotlinType = substitutor2.substitute(it, Variance.INVARIANT);
        }
        return kotlinType;
    }

    private static final <D extends CallableDescriptor> void completeConstraintSystem$updateSystemIfNeeded(MutableResolvedCall<D> $this_completeConstraintSystem, Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem> buildSystemWithAdditionalConstraints) {
        ConstraintSystem constraintSystem = $this_completeConstraintSystem.getConstraintSystem();
        Intrinsics.checkNotNull((Object)constraintSystem);
        ConstraintSystem constraintSystem2 = constraintSystem;
        ConstraintSystem system2 = (ConstraintSystem)buildSystemWithAdditionalConstraints.invoke((Object)ConstraintSystem.DefaultImpls.toBuilder$default(constraintSystem2, null, 1, null));
        if (system2 != null) {
            $this_completeConstraintSystem.setConstraintSystem(system2);
        }
    }

    private static final KtExpression updateRecordedTypeForArgument$deparenthesizeOrGetSelector(StatementFilter $statementFilter, KtExpression expression2) {
        KtExpression deparenthesized = KtPsiUtil.deparenthesizeOnce(expression2);
        if (!Intrinsics.areEqual((Object)deparenthesized, (Object)expression2)) {
            return deparenthesized;
        }
        if (expression2 instanceof KtBlockExpression) {
            return StatementFilterKt.getLastStatementInABlock($statementFilter, (KtBlockExpression)expression2);
        }
        KtQualifiedExpression ktQualifiedExpression = expression2 instanceof KtQualifiedExpression ? (KtQualifiedExpression)expression2 : null;
        return ktQualifiedExpression == null ? null : ktQualifiedExpression.getSelectorExpression();
    }

    public static final /* synthetic */ KotlinType access$completeConstraintSystem$typeInSystem(ConstraintSystem.Builder $receiver, MutableResolvedCall $this_completeConstraintSystem, KotlinType type2) {
        return CallCompleter.completeConstraintSystem$typeInSystem($receiver, $this_completeConstraintSystem, type2);
    }

    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(CallCompleter $this) {
        return $this.moduleDescriptor;
    }
}

