/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirFakeSourceElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtModifierListOwner;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0014\u0010\u0017\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u0019H\u0002R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantVisibilityModifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "containingPropertyVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getContainingPropertyVisibility", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Lorg/jetbrains/kotlin/descriptors/Visibility;", "isLocalMember", "", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)Z", "check", "", "declaration", "context", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "findFunctionVisibility", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "implicitVisibility", "visibility", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkers"})
public final class RedundantVisibilityModifierChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final RedundantVisibilityModifierChecker INSTANCE = new RedundantVisibilityModifierChecker();

    private RedundantVisibilityModifierChecker() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        void $this$report$iv;
        Visibility visibility2;
        FirDeclaration firDeclaration;
        Object object;
        Visibility implicitVisibility;
        Visibility explicitVisibility;
        FirSourceElement source;
        block13: {
            LighterASTNode visibilityModifier;
            LighterASTNode lighterASTNode2;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirSourceElement firSourceElement = declaration2.getSource();
            if (firSourceElement == null) {
                return;
            }
            source = firSourceElement;
            if (declaration2 instanceof FirConstructor && source.getKind() instanceof FirFakeSourceElementKind) {
                return;
            }
            if (source instanceof FirFakeSourceElement) {
                return;
            }
            if (!(declaration2 instanceof FirMemberDeclaration)) {
                if (!(declaration2 instanceof FirPropertyAccessor)) return;
                FirPropertyAccessor $this$visibility$iv = (FirPropertyAccessor)declaration2;
                boolean $i$f$getVisibility = false;
                if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)this.getContainingPropertyVisibility(context2))) {
                    return;
                }
            }
            IElementType iElementType = (lighterASTNode2 = (visibilityModifier = LightTreePositioningStrategiesKt.visibilityModifier(source.getTreeStructure(), source.getLighterASTNode()))) == null ? null : lighterASTNode2.getTokenType();
            KtModifierKeywordToken ktModifierKeywordToken = iElementType instanceof KtModifierKeywordToken ? (KtModifierKeywordToken)iElementType : null;
            explicitVisibility = ktModifierKeywordToken == null ? null : FirHelpersKt.toVisibilityOrNull(ktModifierKeywordToken);
            implicitVisibility = this.implicitVisibility(declaration2, context2);
            CheckerContext this_$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed(this_$iv.getContainingDeclarations())) {
                FirDeclaration firDeclaration2 = it$iv;
                if (!(firDeclaration2 instanceof FirMemberDeclaration)) {
                    firDeclaration2 = null;
                }
                if ((object = (FirDeclaration)((FirMemberDeclaration)firDeclaration2)) == null) continue;
                firDeclaration = object;
                break block13;
            }
            firDeclaration = null;
        }
        FirMemberDeclaration containingMemberDeclaration = (FirMemberDeclaration)firDeclaration;
        if (Intrinsics.areEqual((Object)explicitVisibility, (Object)implicitVisibility)) {
            visibility2 = implicitVisibility;
        } else {
            if (!Intrinsics.areEqual((Object)explicitVisibility, (Object)Visibilities.Internal.INSTANCE)) return;
            FirMemberDeclaration $i$f$findClosest = containingMemberDeclaration;
            boolean bl = false;
            boolean it$iv = false;
            FirMemberDeclaration decl = $i$f$findClosest;
            boolean bl2 = false;
            if (decl == null) return;
            if (!INSTANCE.isLocalMember(decl)) return;
            boolean bl3 = true;
            if (!bl3) return;
            visibility2 = Visibilities.Internal.INSTANCE;
        }
        Visibility redundantVisibility = visibility2;
        if (Intrinsics.areEqual((Object)redundantVisibility, (Object)Visibilities.Public.INSTANCE) && declaration2 instanceof FirProperty && LightTreePositioningStrategiesKt.overrideModifier(source.getTreeStructure(), source.getLighterASTNode()) != null && ((FirProperty)declaration2).isVar()) {
            Visibility visibility3;
            FirPropertyAccessor $i$f$findClosest = ((FirProperty)declaration2).getSetter();
            if ($i$f$findClosest == null) {
                visibility3 = null;
            } else {
                FirPropertyAccessor $this$visibility$iv = $i$f$findClosest;
                boolean $i$f$getVisibility = false;
                visibility3 = $this$visibility$iv.getStatus().getVisibility();
            }
            if (Intrinsics.areEqual(visibility3, (Object)Visibilities.Public.INSTANCE)) {
                return;
            }
        }
        DiagnosticReporter $i$f$findClosest = reporter;
        FirDiagnosticFactory0<FirSourceElement, KtModifierListOwner> factory$iv = FirErrors.INSTANCE.getREDUNDANT_VISIBILITY_MODIFIER();
        boolean $i$f$report = false;
        Object object2 = object = source;
        boolean bl = false;
        boolean bl4 = false;
        Object it$iv = object2;
        boolean bl5 = false;
        $this$report$iv.report((FirDiagnostic)factory$iv.on((FirSourceElement)it$iv));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Visibility implicitVisibility(FirDeclaration $this$implicitVisibility, CheckerContext context2) {
        Visibility visibility2;
        if ($this$implicitVisibility instanceof FirPropertyAccessor && ((FirPropertyAccessor)$this$implicitVisibility).isSetter() && ((FirPropertyAccessor)$this$implicitVisibility).getStatus().isOverride()) {
            FirPropertyAccessor $this$visibility$iv = (FirPropertyAccessor)$this$implicitVisibility;
            boolean $i$f$getVisibility = false;
            visibility2 = $this$visibility$iv.getStatus().getVisibility();
            return visibility2;
        }
        if ($this$implicitVisibility instanceof FirPropertyAccessor) {
            Visibility $this$visibility$iv;
            Visibility visibility3;
            FirDeclaration firDeclaration;
            block11: {
                CheckerContext this_$iv = context2;
                boolean $i$f$findClosest = false;
                for (FirDeclaration it$iv : CollectionsKt.asReversed(this_$iv.getContainingDeclarations())) {
                    FirDeclaration firDeclaration2;
                    FirDeclaration firDeclaration3 = it$iv;
                    if (!(firDeclaration3 instanceof FirProperty)) {
                        firDeclaration3 = null;
                    }
                    if ((firDeclaration2 = (FirDeclaration)((FirProperty)firDeclaration3)) == null) continue;
                    firDeclaration = firDeclaration2;
                    break block11;
                }
                firDeclaration = null;
            }
            FirProperty $i$f$getVisibility = (FirProperty)firDeclaration;
            if ($i$f$getVisibility == null) {
                visibility3 = null;
            } else {
                FirMemberDeclaration $this$visibility$iv2 = $i$f$getVisibility;
                boolean $i$f$getVisibility2 = false;
                visibility3 = $this$visibility$iv = $this$visibility$iv2.getStatus().getVisibility();
            }
            if ($this$visibility$iv == null) {
                visibility2 = Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
                return visibility2;
            }
            visibility2 = $this$visibility$iv;
            return visibility2;
        }
        if ($this$implicitVisibility instanceof FirConstructor) {
            FirClassLikeDeclaration<?> clazz = FirHelpersKt.getContainingClass((FirSymbolOwner)((Object)$this$implicitVisibility), context2);
            if (clazz instanceof FirClass && (((FirClass)clazz).getClassKind() == ClassKind.ENUM_CLASS || FirHelpersKt.modality((FirClass)clazz) == Modality.SEALED)) {
                visibility2 = Visibilities.Private.INSTANCE;
                return visibility2;
            }
            visibility2 = Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
            return visibility2;
        }
        if ($this$implicitVisibility instanceof FirSimpleFunction && CollectionsKt.last(context2.getContainingDeclarations()) instanceof FirClass) {
            FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)$this$implicitVisibility;
            boolean $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                visibility2 = this.findFunctionVisibility((FirSimpleFunction)$this$implicitVisibility, context2);
                return visibility2;
            }
        }
        visibility2 = Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
        return visibility2;
    }

    private final Visibility findFunctionVisibility(FirSimpleFunction function2, CheckerContext context2) {
        FirClass<?> firClass = FirHelpersKt.findClosestClassOrObject(context2);
        if (firClass == null) {
            return Visibilities.Unknown.INSTANCE;
        }
        FirClass<?> currentClass = firClass;
        List<FirFunctionSymbol<?>> overriddenFunctions2 = FirHelpersKt.overriddenFunctions(function2, currentClass, context2);
        Visibility visibility2 = Visibilities.Private.INSTANCE;
        for (FirFunctionSymbol<?> func : overriddenFunctions2) {
            Integer compareResult;
            Visibility currentVisibility = this.visibility((FirFunction)func.getFir());
            if (currentVisibility == null || (compareResult = Visibilities.INSTANCE.compare(currentVisibility, visibility2)) == null || compareResult <= 0) continue;
            visibility2 = currentVisibility;
        }
        return visibility2;
    }

    private final Visibility visibility(FirFunction<?> $this$visibility) {
        boolean $i$f$getVisibility;
        Object $this$visibility$iv;
        FirMemberDeclaration firMemberDeclaration;
        Object object = $this$visibility.getSymbol().getFir();
        FirMemberDeclaration firMemberDeclaration2 = firMemberDeclaration = object instanceof FirMemberDeclaration ? (FirMemberDeclaration)object : null;
        if (firMemberDeclaration != null) {
            $this$visibility$iv = firMemberDeclaration;
            $i$f$getVisibility = false;
            object = $this$visibility$iv.getStatus().getVisibility();
            if (object != null) {
                $this$visibility$iv = object;
                $i$f$getVisibility = false;
                boolean bl = false;
                Object it = $this$visibility$iv;
                boolean bl2 = false;
                return it;
            }
        }
        object = $this$visibility.getSymbol().getFir();
        FirMemberDeclaration firMemberDeclaration3 = firMemberDeclaration = object instanceof FirPropertyAccessor ? (FirPropertyAccessor)object : null;
        if (firMemberDeclaration != null) {
            $this$visibility$iv = firMemberDeclaration;
            $i$f$getVisibility = false;
            object = ((FirPropertyAccessor)$this$visibility$iv).getStatus().getVisibility();
            if (object != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl3 = false;
                Object it = object2;
                boolean bl4 = false;
                return it;
            }
        }
        return null;
    }

    private final boolean isLocalMember(FirMemberDeclaration $this$isLocalMember) {
        boolean bl;
        FirMemberDeclaration firMemberDeclaration = $this$isLocalMember;
        if (firMemberDeclaration instanceof FirProperty) {
            bl = ((FirProperty)$this$isLocalMember).isLocal();
        } else if (firMemberDeclaration instanceof FirRegularClass) {
            FirRegularClass $this$isLocal$iv = (FirRegularClass)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = $this$isLocal$iv.getSymbol().getClassId().isLocal();
        } else if (firMemberDeclaration instanceof FirSimpleFunction) {
            FirSimpleFunction $this$isLocal$iv = (FirSimpleFunction)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = Intrinsics.areEqual((Object)$this$isLocal$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE);
        } else {
            bl = false;
        }
        return bl;
    }

    private final Visibility getContainingPropertyVisibility(CheckerContext $this$containingPropertyVisibility) {
        Visibility visibility2;
        FirProperty firProperty;
        Object object = CollectionsKt.last($this$containingPropertyVisibility.getContainingDeclarations());
        FirProperty firProperty2 = firProperty = object instanceof FirProperty ? (FirProperty)object : null;
        if (firProperty == null) {
            visibility2 = null;
        } else {
            FirMemberDeclaration $this$visibility$iv = firProperty;
            boolean $i$f$getVisibility = false;
            visibility2 = $this$visibility$iv.getStatus().getVisibility();
        }
        return visibility2;
    }
}

