/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.bootstrap;

import java.util.List;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.filter.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.convert.MavenConverter;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MavenResolutionFilterWrap
implements DependencyFilter {
    private final MavenResolutionFilter[] filters;
    private final List<MavenDependency> dependenciesForResolution;

    public MavenResolutionFilterWrap(MavenResolutionFilter[] filters, List<MavenDependency> dependenciesForResolution) {
        assert (filters != null) : "filters must be specified, even if empty";
        assert (dependenciesForResolution != null) : "declaredDependencies must be specified";
        this.dependenciesForResolution = dependenciesForResolution;
        this.filters = filters;
    }

    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return false;
        }
        for (MavenResolutionFilter filter : this.filters) {
            if (filter.accepts(MavenConverter.fromDependency(dependency), this.dependenciesForResolution)) continue;
            return false;
        }
        return true;
    }
}

