/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenModelResolver;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenRepositorySettings;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenResolutionFilterWrap;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenRepositorySystem {
    private final MavenRepositorySettings settings;
    private final RepositorySystem system;

    public MavenRepositorySystem(MavenRepositorySettings settings) {
        this.settings = settings;
        this.system = this.getRepositorySystem();
    }

    public RepositorySystemSession getSession() {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        session.setLocalRepositoryManager(this.system.newLocalRepositoryManager(this.settings.getLocalRepository()));
        session.setTransferListener(this.settings.getTransferListener());
        session.setRepositoryListener(this.settings.getRepositoryListener());
        return session;
    }

    public Model loadPom(File pom, RepositorySystemSession session) throws ResolutionException {
        ModelBuildingResult result;
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
        request.setPomFile(pom);
        request.setModelResolver((ModelResolver)new MavenModelResolver(this.system, session, this.getRemoteRepositories()));
        DefaultModelBuilder builder = new DefaultModelBuilderFactory().newInstance();
        try {
            result = builder.build((ModelBuildingRequest)request);
        }
        catch (ModelBuildingException e) {
            StringBuilder sb = new StringBuilder("Found ").append(e.getProblems().size()).append(" problems while building POM model from ").append(pom.getAbsolutePath());
            int counter = 1;
            for (ModelProblem problem : e.getProblems()) {
                sb.append(counter++).append("/ ").append(problem).append("\n");
            }
            throw new ResolutionException(sb.toString(), (Throwable)e);
        }
        Model model = result.getEffectiveModel();
        this.settings.setRemoteRepositories(model);
        return model;
    }

    public void loadSettings(File file, RepositorySystemSession session) {
        if (!(session instanceof MavenRepositorySystemSession)) {
            throw new IllegalArgumentException("Cannot set local repository path for a Maven repository, expecting instance of " + MavenRepositorySystemSession.class.getName() + ", but got " + session.getClass().getName());
        }
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setUserSettingsFile(file);
        this.settings.buildSettings((SettingsBuildingRequest)request);
        ((MavenRepositorySystemSession)session).setLocalRepositoryManager(this.system.newLocalRepositoryManager(this.settings.getLocalRepository()));
    }

    public List<RemoteRepository> getRemoteRepositories() {
        return this.settings.getRemoteRepositories();
    }

    public Collection<ArtifactResult> resolveDependencies(RepositorySystemSession session, CollectRequest request, MavenResolutionFilter filter) throws DependencyCollectionException, ArtifactResolutionException {
        return this.system.resolveDependencies(session, request, (DependencyFilter)new MavenResolutionFilterWrap(filter));
    }

    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        return this.system.resolveArtifact(session, request);
    }

    private RepositorySystem getRepositorySystem() {
        try {
            return (RepositorySystem)new DefaultPlexusContainer().lookup(RepositorySystem.class);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Unable to lookup component RepositorySystem, cannot establish Aether dependency resolver.", e);
        }
        catch (PlexusContainerException e) {
            throw new RuntimeException("Unable to load RepositorySystem component by Plexus, cannot establish Aether dependency resolver.", e);
        }
    }
}

