/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.touri;

import java.util.ArrayList;
import java.util.List;
import org.jboss.resteasy.spi.touri.MappedByAnnotationResolver;
import org.jboss.resteasy.spi.touri.URIResolver;
import org.jboss.resteasy.spi.touri.URITemplateAnnotationResolver;
import org.jboss.resteasy.spi.touri.URIableURIResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectToURI {
    private static ObjectToURI instance = null;
    private List<URIResolver> resolvers = new ArrayList<URIResolver>();
    private List<URIResolver> defaultResolvers = new ArrayList<URIResolver>();

    public static ObjectToURI getInstance() {
        return instance;
    }

    public void registerURIResolver(URIResolver uriResolver) {
        this.resolvers.add(uriResolver);
    }

    public String resolveURI(Object object) {
        String result = this.getResolver(object, this.resolvers);
        if (result == null) {
            result = this.getResolver(object, this.defaultResolvers);
        }
        return result;
    }

    private String getResolver(Object object, List<URIResolver> resolvers) {
        Class<?> type = object.getClass();
        for (URIResolver resolver : resolvers) {
            if (!resolver.handles(type)) continue;
            return resolver.resolveURI(object);
        }
        return null;
    }

    static {
        instance = new ObjectToURI();
        ObjectToURI.instance.defaultResolvers.add(new URIableURIResolver());
        ObjectToURI.instance.defaultResolvers.add(new URITemplateAnnotationResolver());
        ObjectToURI.instance.defaultResolvers.add(new MappedByAnnotationResolver());
    }
}

