/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logmanager.ConcurrentReferenceHashMap;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LoggerInstance;

final class LoggerNode {
    private final LogContext context;
    private final LoggerNode parent;
    private final String fullName;
    private WeakReference<LoggerInstance> loggerRef = null;
    private final ConcurrentMap<String, LoggerNode> children = new ConcurrentReferenceHashMap<String, LoggerNode>(8, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    LoggerNode(LogContext context) {
        this.parent = null;
        this.fullName = "";
        this.context = context;
    }

    private LoggerNode(LogContext context, LoggerNode parent, String nodeName) {
        if (nodeName.trim().length() == 0) {
            throw new IllegalArgumentException("nodeName is empty, or just whitespace");
        }
        this.parent = parent;
        this.fullName = parent.parent == null ? nodeName : parent.fullName + "." + nodeName;
        parent.children.put(nodeName, this);
        this.context = context;
    }

    LoggerNode getOrCreate(String name) {
        LoggerNode appearingNode;
        if (name == null || name.length() == 0) {
            return this;
        }
        int i = name.indexOf(46);
        String nextName = i == -1 ? name : name.substring(0, i);
        LoggerNode nextNode = (LoggerNode)this.children.get(nextName);
        if (nextNode == null && (appearingNode = this.children.putIfAbsent(nextName, nextNode = new LoggerNode(this.context, this, nextName))) != null) {
            nextNode = appearingNode;
        }
        if (i == -1) {
            return nextNode;
        }
        return nextNode.getOrCreate(name.substring(i + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LoggerInstance getOrCreateLogger() {
        LoggerNode loggerNode = this;
        synchronized (loggerNode) {
            LoggerInstance instance;
            LoggerInstance loggerInstance = instance = this.loggerRef == null ? null : (LoggerInstance)this.loggerRef.get();
            if (instance == null) {
                instance = new LoggerInstance(this, this.fullName);
                this.loggerRef = new WeakReference<LoggerInstance>(instance);
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LoggerInstance getParentLogger() {
        LoggerNode node = this.parent;
        while (node != null) {
            LoggerNode loggerNode = node;
            synchronized (loggerNode) {
                LoggerInstance instance;
                LoggerInstance loggerInstance = instance = node.loggerRef == null ? null : (LoggerInstance)node.loggerRef.get();
                if (instance != null) {
                    return instance;
                }
                node = node.parent;
            }
        }
        return null;
    }

    LogContext getContext() {
        return this.context;
    }

    void updateChildEffectiveLevel(int newLevel) {
        for (LoggerNode node : this.children.values()) {
            LoggerInstance instance;
            WeakReference<LoggerInstance> loggerRef;
            if (node == null || (loggerRef = node.loggerRef) == null || (instance = (LoggerInstance)loggerRef.get()) == null) continue;
            instance.setEffectiveLevel(newLevel);
        }
    }
}

