/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.service.PersistentBundlesIntegration;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Services;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.IntegrationServices;
import org.jboss.osgi.framework.StorageState;
import org.jboss.osgi.framework.StorageStateProvider;
import org.osgi.framework.Bundle;

public class PersistentBundleInstallService
extends AbstractService<Void> {
    static final ServiceName SERVICE_NAME_BASE = OSGiConstants.SERVICE_BASE_NAME.append(new String[]{"persistent", "bundle", "install"});
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<StorageStateProvider> injectedStorageProvider = new InjectedValue();
    private final PersistentBundlesIntegration.InitialDeploymentTracker deploymentTracker;
    private final Deployment deployment;

    private PersistentBundleInstallService(PersistentBundlesIntegration.InitialDeploymentTracker deploymentTracker, Deployment deployment) {
        this.deploymentTracker = deploymentTracker;
        this.deployment = deployment;
    }

    public static ServiceName addService(PersistentBundlesIntegration.InitialDeploymentTracker deploymentTracker, DeploymentPhaseContext phaseContext, Deployment deployment) {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        PersistentBundleInstallService service = new PersistentBundleInstallService(deploymentTracker, deployment);
        String contextName = depUnit.getName();
        ServiceName serviceName = PersistentBundleInstallService.getServiceName(depUnit);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service);
        builder.addDependency(org.jboss.osgi.framework.Services.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.addDependency(org.jboss.osgi.framework.Services.STORAGE_STATE_PROVIDER, StorageStateProvider.class, service.injectedStorageProvider);
        builder.addDependency(Services.deploymentUnitName((String)contextName));
        builder.addDependency(IntegrationServices.AUTOINSTALL_COMPLETE);
        builder.install();
        return serviceName;
    }

    private static ServiceName getServiceName(DeploymentUnit depUnit) {
        ServiceName deploymentServiceName = Services.deploymentUnitName((String)depUnit.getName());
        return SERVICE_NAME_BASE.append(new String[]{deploymentServiceName.getSimpleName()});
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", controller.getName(), controller.getMode());
        try {
            BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
            StorageStateProvider storageStateProvider = (StorageStateProvider)this.injectedStorageProvider.getValue();
            StorageState storageState = storageStateProvider.getByLocation(this.deployment.getLocation());
            if (storageState != null) {
                this.deployment.addAttachment(StorageState.class, (Object)storageState);
            }
            ServiceListener<Bundle> listener = this.deploymentTracker.getBundleInstallListener();
            bundleManager.installBundle(this.deployment, listener);
        }
        catch (Throwable th) {
            throw OSGiMessages.MESSAGES.startFailedToInstallDeployment(th, this.deployment);
        }
    }
}

