/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.ejb;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.testenricher.ejb.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBInjectionEnricher
implements TestEnricher {
    private static final String ANNOTATION_NAME = "javax.ejb.EJB";
    private static final Logger log = Logger.getLogger(TestEnricher.class.getName());
    @Inject
    private Instance<Context> contextInst;

    public void enrich(Object testCase) {
        if (SecurityActions.isClassPresent(ANNOTATION_NAME) && this.contextInst.get() != null) {
            this.injectClass(testCase);
        }
    }

    public Object[] resolve(Method method) {
        return new Object[method.getParameterTypes().length];
    }

    protected List<Field> getFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz must be specified");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("annotation must be specified");
        }
        return SecurityActions.getFieldsWithAnnotation(clazz, annotation);
    }

    protected void injectClass(Object testCase) {
        try {
            Class<?> ejbAnnotation = SecurityActions.getThreadContextClassLoader().loadClass(ANNOTATION_NAME);
            List<Field> annotatedFields = SecurityActions.getFieldsWithAnnotation(testCase.getClass(), ejbAnnotation);
            for (Field field : annotatedFields) {
                if (field.get(testCase) != null) continue;
                EJB fieldAnnotation = (EJB)field.getAnnotation(ejbAnnotation);
                try {
                    Object ejb = this.lookupEJB(field.getType(), fieldAnnotation.mappedName());
                    field.set(testCase, ejb);
                }
                catch (Exception e) {
                    log.fine("Could not lookup " + fieldAnnotation + ", other Enrichers might, move on. Exception: " + e.getMessage());
                }
            }
            List<Method> methods = SecurityActions.getMethodsWithAnnotation(testCase.getClass(), ejbAnnotation);
            for (Method method : methods) {
                if (method.getParameterTypes().length != 1) {
                    throw new RuntimeException("@EJB only allowed on single argument methods");
                }
                if (!method.getName().startsWith("set")) {
                    throw new RuntimeException("@EJB only allowed on 'set' methods");
                }
                EJB parameterAnnotation = null;
                for (Annotation annotation : method.getParameterAnnotations()[0]) {
                    if (!EJB.class.isAssignableFrom(annotation.annotationType())) continue;
                    parameterAnnotation = (EJB)annotation;
                }
                String mappedName = parameterAnnotation == null ? null : parameterAnnotation.mappedName();
                Object ejb = this.lookupEJB(method.getParameterTypes()[0], mappedName);
                method.invoke(testCase, ejb);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not inject members", e);
        }
    }

    protected Object lookupEJB(Class<?> fieldType, String mappedName) throws Exception {
        Context initcontext = this.createContext();
        String[] jndiNames = new String[]{"java:global/test.ear/test/" + fieldType.getSimpleName() + "Bean", "java:global/test.ear/test/" + fieldType.getSimpleName(), "java:global/test/" + fieldType.getSimpleName(), "java:global/test/" + fieldType.getSimpleName() + "Bean", "java:global/test/" + fieldType.getSimpleName() + "/no-interface", "test/" + fieldType.getSimpleName() + "Bean/local", "test/" + fieldType.getSimpleName() + "Bean/remote", "test/" + fieldType.getSimpleName() + "/no-interface", fieldType.getSimpleName() + "Bean/local", fieldType.getSimpleName() + "Bean/remote", fieldType.getSimpleName() + "/no-interface", "ejblocal:" + fieldType.getCanonicalName(), fieldType.getCanonicalName()};
        if (mappedName != null && !mappedName.equals("")) {
            jndiNames = new String[]{mappedName};
        }
        for (String jndiName : jndiNames) {
            try {
                return initcontext.lookup(jndiName);
            }
            catch (NamingException e) {
            }
        }
        throw new NamingException("No EJB found in JNDI, tried the following names: " + this.joinJndiNames(jndiNames));
    }

    protected Context createContext() throws Exception {
        return (Context)this.contextInst.get();
    }

    private String joinJndiNames(String[] strings) {
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            sb.append(string).append(", ");
        }
        return sb.toString();
    }
}

