/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.CapabilitiesOptionsMapper;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.utils.FirefoxPrefsReader;
import org.jboss.arquillian.drone.webdriver.utils.StringUtils;
import org.jboss.arquillian.drone.webdriver.utils.Validate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.GeckoDriverService;

public class FirefoxDriverFactory
extends AbstractWebDriverFactory<FirefoxDriver>
implements Configurator<FirefoxDriver, WebDriverConfiguration>,
Instantiator<FirefoxDriver, WebDriverConfiguration>,
Destructor<FirefoxDriver> {
    public static final String FIREFOX_DRIVER_BINARY_PROPERTY = "firefoxDriverBinary";
    private static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.Firefox().getReadableName();

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(FirefoxDriver instance) {
        instance.quit();
    }

    public FirefoxDriver createInstance(WebDriverConfiguration configuration) {
        FirefoxOptions firefoxOptions = this.getFirefoxOptions(configuration, true);
        FirefoxDriverService firefoxDriverService = (FirefoxDriverService)((GeckoDriverService.Builder)new GeckoDriverService.Builder().withLogOutput((OutputStream)System.out)).build();
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{FirefoxDriverService.class, FirefoxOptions.class}, new Object[]{firefoxDriverService, firefoxOptions}, FirefoxDriver.class);
    }

    public FirefoxOptions getFirefoxOptions(WebDriverConfiguration configuration, boolean performValidations) {
        Capabilities capabilities = configuration.getCapabilities();
        String binary = (String)capabilities.getCapability(FIREFOX_DRIVER_BINARY_PROPERTY);
        if (Validate.nonEmpty(binary) && performValidations) {
            Validate.isExecutable(binary, "Firefox binary does not point to a valid executable,  " + binary);
        }
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        CapabilitiesOptionsMapper.mapCapabilities(firefoxOptions, capabilities, BROWSER_CAPABILITIES);
        FirefoxProfile firefoxProfile = this.getFirefoxProfile(capabilities, performValidations);
        if (firefoxProfile != null) {
            firefoxOptions.setProfile(firefoxProfile);
        }
        this.addUserPreferencesFromFile(capabilities, firefoxOptions);
        return firefoxOptions;
    }

    private FirefoxProfile getFirefoxProfile(Capabilities capabilities, boolean performValidations) {
        FirefoxProfile firefoxProfile;
        String profile = (String)capabilities.getCapability("firefox_profile");
        if (profile == null) {
            profile = (String)capabilities.getCapability("firefoxProfile");
        }
        boolean profileShouldBeSet = false;
        if (Validate.nonEmpty(profile)) {
            if (performValidations) {
                Validate.isValidPath(profile, "Firefox profile does not point to a valid path " + profile);
            }
            firefoxProfile = new FirefoxProfile(new File(profile));
            profileShouldBeSet = true;
        } else {
            firefoxProfile = new FirefoxProfile();
        }
        String firefoxExtensions = (String)capabilities.getCapability("firefoxExtensions");
        for (String extensionPath : StringUtils.tokenize(firefoxExtensions)) {
            firefoxProfile.addExtension(new File(extensionPath));
            profileShouldBeSet = true;
        }
        return profileShouldBeSet ? firefoxProfile : null;
    }

    private void addUserPreferencesFromFile(Capabilities capabilities, FirefoxOptions firefoxOptions) {
        String userPreferences = (String)capabilities.getCapability("firefoxUserPreferences");
        if (Validate.nonEmpty(userPreferences)) {
            Validate.isValidPath(userPreferences, "User preferences does not point to a valid path " + userPreferences);
            for (Map.Entry<String, Object> preference : FirefoxPrefsReader.getPreferences(new File(userPreferences)).entrySet()) {
                String key = preference.getKey();
                Object value = preference.getValue();
                if (value instanceof Boolean) {
                    firefoxOptions.addPreference(key, (Object)((Boolean)value));
                    continue;
                }
                if (value instanceof Integer) {
                    firefoxOptions.addPreference(key, (Object)((Integer)value));
                    continue;
                }
                if (!(value instanceof String)) continue;
                firefoxOptions.addPreference(key, (Object)((String)value));
            }
        }
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }
}

