/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.drone.api.annotation.lifecycle.ClassLifecycle;
import org.jboss.arquillian.drone.api.annotation.lifecycle.MethodLifecycle;
import org.jboss.arquillian.drone.impl.DronePointImpl;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.deployment.DeploymentNameKey;

final class InjectionPoints {
    private InjectionPoints() {
    }

    static Set<DronePoint<?>> allInClass(DroneContext context, Class<?> cls) {
        ArrayList dronePoints = new ArrayList();
        dronePoints.addAll(InjectionPoints.fieldsInClass(context, cls).values());
        for (DronePoint<?>[] methodDronePoints : InjectionPoints.parametersInClass(context, cls).values()) {
            for (DronePoint<?> dronePoint : methodDronePoints) {
                if (dronePoint == null) continue;
                dronePoints.add(dronePoint);
            }
        }
        return new HashSet(dronePoints);
    }

    static Map<Field, DronePoint<?>> fieldsInClass(DroneContext context, Class<?> cls) {
        HashMap injectionPoints = new HashMap();
        List<Field> fields = SecurityActions.getFieldsWithAnnotation(cls, Drone.class);
        for (Field field : fields) {
            DronePoint<?> dronePoint = InjectionPoints.resolveInjectionPoint(context, field);
            injectionPoints.put(field, dronePoint);
        }
        return injectionPoints;
    }

    static Map<Method, DronePoint<?>[]> parametersInClass(DroneContext context, Class<?> cls) {
        Method[] methods;
        HashMap<Method, DronePoint<?>[]> mergedInjectionPoints = new HashMap<Method, DronePoint<?>[]>();
        for (Method method : methods = cls.getMethods()) {
            DronePoint<?>[] dronePoints = InjectionPoints.parametersInMethod(context, method);
            mergedInjectionPoints.put(method, dronePoints);
        }
        return mergedInjectionPoints;
    }

    static DronePoint<?>[] parametersInMethod(DroneContext context, Method method) {
        Class<?>[] parameters = method.getParameterTypes();
        Map<Integer, Annotation[]> droneParameters = SecurityActions.getParametersWithAnnotation(method, Drone.class);
        DronePoint[] dronePoints = new DronePoint[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            DronePoint<?> dronePoint;
            if (!droneParameters.containsKey(i)) {
                dronePoints[i] = null;
                continue;
            }
            Annotation[] parameterAnnotations = droneParameters.get(i);
            Class<?> droneType = parameters[i];
            dronePoints[i] = dronePoint = InjectionPoints.resolveInjectionPoint(context, droneType, parameterAnnotations);
        }
        return dronePoints;
    }

    static DronePoint<?> resolveInjectionPoint(DroneContext context, Field field) {
        Class<?> droneType = field.getType();
        Annotation[] annotations = SecurityActions.getAnnotations(field);
        return InjectionPoints.createInjectionPoint(context, droneType, annotations, DronePoint.Lifecycle.CLASS);
    }

    static <T> DronePoint<T> resolveInjectionPoint(DroneContext context, Class<T> droneType, Annotation[] parameterAnnotations) {
        return InjectionPoints.createInjectionPoint(context, droneType, parameterAnnotations, DronePoint.Lifecycle.METHOD);
    }

    static <T> DronePoint<T> createInjectionPoint(DroneContext context, Class<T> droneType, Annotation[] annotations, DronePoint.Lifecycle defaultLifecycle) {
        Class<? extends Annotation> scopeAnnotation = SecurityActions.getScope(annotations);
        OperateOnDeployment operateOnDeployment = SecurityActions.findAnnotation(annotations, OperateOnDeployment.class);
        DronePoint.Lifecycle lifecycle = InjectionPoints.scopeForAnnotation(scopeAnnotation, operateOnDeployment, defaultLifecycle);
        DronePointImpl<T> dronePoint = new DronePointImpl<T>(droneType, lifecycle, annotations);
        context.get(dronePoint);
        if (lifecycle == DronePoint.Lifecycle.DEPLOYMENT) {
            String deployment = operateOnDeployment.value();
            context.get(dronePoint).setMetadata(DeploymentNameKey.class, (Object)deployment);
        }
        return dronePoint;
    }

    static DronePoint.Lifecycle scopeForAnnotation(Class<? extends Annotation> annotation, OperateOnDeployment deployment, DronePoint.Lifecycle defaultLifecycle) {
        if (annotation == ClassLifecycle.class) {
            return DronePoint.Lifecycle.CLASS;
        }
        if (annotation == MethodLifecycle.class) {
            return DronePoint.Lifecycle.METHOD;
        }
        if (deployment != null) {
            return DronePoint.Lifecycle.DEPLOYMENT;
        }
        return defaultLifecycle;
    }
}

