/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.drone.spi.command.DestroyDrone;
import org.jboss.arquillian.drone.spi.event.AfterDroneDestroyed;
import org.jboss.arquillian.drone.spi.event.BeforeDroneDestroyed;
import org.jboss.arquillian.drone.spi.event.DroneLifecycleEvent;

public class DroneDestructor {
    private static final Logger log = Logger.getLogger(DroneDestructor.class.getName());
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Instance<DroneRegistry> registry;
    @Inject
    private Event<DroneLifecycleEvent> droneLifecycleEvent;
    @Inject
    private Event<DestroyDrone> destroyDroneCommand;
    @Inject
    private Instance<DroneContext> droneContext;

    public void destroyDrone(@Observes DestroyDrone command) {
        DroneContext context = (DroneContext)this.droneContext.get();
        DronePoint dronePoint = command.getDronePoint();
        if (dronePoint == null || !context.contains(dronePoint)) {
            return;
        }
        boolean wasInstantiated = context.get(dronePoint).isInstantiated();
        if (wasInstantiated) {
            Destructor destructor = this.getDestructorFor(dronePoint.getDroneType());
            this.droneLifecycleEvent.fire((Object)new BeforeDroneDestroyed(dronePoint));
            Object drone = context.get(dronePoint).getInstance();
            destructor.destroyInstance(drone);
        }
        if (wasInstantiated) {
            this.droneLifecycleEvent.fire((Object)new AfterDroneDestroyed(dronePoint));
        }
        context.remove(dronePoint);
    }

    private Destructor getDestructorFor(Class<?> typeClass) {
        Destructor destructor = (Destructor)((DroneRegistry)this.registry.get()).getEntryFor(typeClass, Destructor.class);
        if (log.isLoggable(Level.FINER)) {
            log.fine("Using destructor defined in class: " + destructor.getClass().getName() + ", with precedence " + destructor.getPrecedence());
        }
        return destructor;
    }
}

