/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.anchored.impl;

import io.reactivex.rxjava3.core.Flowable;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.RemoteMetadata;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.Metadata;
import org.infinispan.reactive.publisher.impl.Notifications;
import org.infinispan.reactive.publisher.impl.SegmentPublisherSupplier;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.statetransfer.StateProviderImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class AnchoredStateProvider
extends StateProviderImpl
implements StateProvider {
    private static final Log log = LogFactory.getLog(AnchoredStateProvider.class);
    @Inject
    InternalEntryFactory internalEntryFactory;

    protected Flowable<SegmentPublisherSupplier.Notification<InternalCacheEntry<?, ?>>> readEntries(IntSet segments) {
        return super.readEntries(segments).map(notification -> {
            if (notification.isValue()) {
                InternalCacheEntry ice = (InternalCacheEntry)notification.value();
                return Notifications.value(this.replaceValueWithLocation((InternalCacheEntry<Object, Object>)ice), (int)notification.valueSegment());
            }
            return notification;
        });
    }

    private InternalCacheEntry<Object, Object> replaceValueWithLocation(InternalCacheEntry<Object, Object> ice) {
        if (ice.getMetadata() instanceof RemoteMetadata) {
            return ice;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Replaced state transfer value for key %s: %s", ice.getKey(), (Object)this.rpcManager.getAddress());
        }
        RemoteMetadata metadata = new RemoteMetadata(this.rpcManager.getAddress(), null);
        return this.internalEntryFactory.create(ice.getKey(), null, (Metadata)metadata);
    }
}

